/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.validation;

import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"org.apache.qpid.server.model.ManagedAnnotation"})
public class ManagedAnnotationValidator
extends AbstractProcessor {
    public static final String MANAGED_ANNOTATION_CLASS_NAME = "org.apache.qpid.server.model.ManagedAnnotation";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeElement annotationElement = elementUtils.getTypeElement(MANAGED_ANNOTATION_CLASS_NAME);
        String className = "org.apache.qpid.server.model.ManagedInterface";
        TypeMirror configuredObjectType = this.getErasure(className);
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationElement)) {
            if (element.getKind() != ElementKind.INTERFACE) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + String.valueOf(annotationElement.getSimpleName()) + " can only be applied to an interface", element);
            }
            if (typeUtils.isAssignable(typeUtils.erasure(element.asType()), configuredObjectType)) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + String.valueOf(annotationElement.getSimpleName()) + " can only be applied to an interface which extends " + className, element);
        }
        return false;
    }

    private TypeMirror getErasure(String className) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        Elements elementUtils = this.processingEnv.getElementUtils();
        return typeUtils.erasure(elementUtils.getTypeElement(className).asType());
    }
}

