/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.validation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"org.apache.qpid.server.model.ManagedAttribute", "org.apache.qpid.server.model.DerivedAttribute", "org.apache.qpid.server.model.ManagedStatistic"})
public class AttributeAnnotationValidator
extends AbstractProcessor {
    public static final String MANAGED_ATTRIBUTE_CLASS_NAME = "org.apache.qpid.server.model.ManagedAttribute";
    public static final String DERIVED_ATTRIBUTE_CLASS_NAME = "org.apache.qpid.server.model.DerivedAttribute";
    public static final String MANAGED_STATISTIC_CLASS_NAME = "org.apache.qpid.server.model.ManagedStatistic";
    private static final Set<TypeKind> VALID_PRIMITIVE_TYPES = new HashSet<TypeKind>(Arrays.asList(TypeKind.BOOLEAN, TypeKind.BYTE, TypeKind.CHAR, TypeKind.DOUBLE, TypeKind.FLOAT, TypeKind.INT, TypeKind.LONG, TypeKind.SHORT));
    private Elements elementUtils;
    private Types typeUtils;
    private Messager messager;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.elementUtils = this.processingEnv.getElementUtils();
        this.typeUtils = this.processingEnv.getTypeUtils();
        this.messager = this.processingEnv.getMessager();
        this.processAttributes(roundEnv, MANAGED_ATTRIBUTE_CLASS_NAME, false, false);
        this.processAttributes(roundEnv, DERIVED_ATTRIBUTE_CLASS_NAME, true, true);
        this.processStatistics(roundEnv, MANAGED_STATISTIC_CLASS_NAME);
        return false;
    }

    public void processAttributes(RoundEnvironment roundEnv, String elementName, boolean allowedNamed, boolean allowAbstractManagedTypes) {
        TypeElement annotationElement = this.elementUtils.getTypeElement(elementName);
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationElement)) {
            this.checkAnnotationIsOnMethodInInterface(annotationElement, element);
            ExecutableElement methodElement = (ExecutableElement)element;
            this.checkInterfaceExtendsConfiguredObject(annotationElement, methodElement);
            this.checkMethodTakesNoArgs(annotationElement, methodElement);
            this.checkMethodName(annotationElement, methodElement);
            this.checkMethodReturnType(annotationElement, methodElement, allowedNamed, allowAbstractManagedTypes);
            this.checkTypeAgreesWithName(annotationElement, methodElement);
            if (!MANAGED_ATTRIBUTE_CLASS_NAME.equals(elementName)) continue;
            this.checkValidValuesPatternOnAppropriateTypes(methodElement);
        }
    }

    void checkValidValuesPatternOnAppropriateTypes(ExecutableElement methodElement) {
        AnnotationMirror annotationMirror = this.getAnnotationMirror(methodElement, MANAGED_ATTRIBUTE_CLASS_NAME);
        if (this.hasValidValuePattern(annotationMirror) && !this.isStringOrCollectionOfStrings(methodElement.getReturnType())) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@ManagedAttribute return type does not not support validValuePattern: " + methodElement.getReturnType().toString(), methodElement);
        }
    }

    private AnnotationMirror getAnnotationMirror(ExecutableElement methodElement, String annotationClassName) {
        for (AnnotationMirror annotationMirror : methodElement.getAnnotationMirrors()) {
            Element annotationAsElement = annotationMirror.getAnnotationType().asElement();
            if (!annotationClassName.equals(this.getFullyQualifiedName(annotationAsElement))) continue;
            return annotationMirror;
        }
        return null;
    }

    private boolean hasValidValuePattern(AnnotationMirror annotationMirror) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!"validValuePattern".equals(entry.getKey().getSimpleName().toString())) continue;
            return true;
        }
        return false;
    }

    private String getFullyQualifiedName(Element element) {
        return this.elementUtils.getPackageOf(element).getQualifiedName().toString() + "." + element.getSimpleName().toString();
    }

    private boolean isStringOrCollectionOfStrings(TypeMirror type) {
        TypeMirror stringType = this.elementUtils.getTypeElement("java.lang.String").asType();
        TypeMirror collectionType = this.elementUtils.getTypeElement("java.util.Collection").asType();
        TypeElement typeAsElement = (TypeElement)this.typeUtils.asElement(type);
        return this.typeUtils.isAssignable(type, stringType) || typeAsElement != null && typeAsElement.getTypeParameters().size() == 1 && "java.lang.String".equals(this.getFullyQualifiedName(this.getErasedParameterType((DeclaredType)type, 0))) && this.typeUtils.isAssignable(this.typeUtils.erasure(typeAsElement.asType()), collectionType);
    }

    private Element getErasedParameterType(DeclaredType returnType, int parameterIndex) {
        return this.typeUtils.asElement(this.typeUtils.erasure(returnType.getTypeArguments().get(parameterIndex)));
    }

    public void processStatistics(RoundEnvironment roundEnv, String elementName) {
        TypeElement annotationElement = this.elementUtils.getTypeElement(elementName);
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationElement)) {
            this.checkAnnotationIsOnMethodInInterface(annotationElement, element);
            ExecutableElement methodElement = (ExecutableElement)element;
            this.checkInterfaceExtendsConfiguredObject(annotationElement, methodElement);
            this.checkMethodTakesNoArgs(annotationElement, methodElement);
            this.checkMethodName(annotationElement, methodElement);
            this.checkTypeAgreesWithName(annotationElement, methodElement);
            this.checkMethodReturnTypeIsNumberOrDate(annotationElement, methodElement);
        }
    }

    private void checkMethodReturnTypeIsNumberOrDate(TypeElement annotationElement, ExecutableElement methodElement) {
        TypeMirror numberType = this.elementUtils.getTypeElement("java.lang.Number").asType();
        TypeMirror dateType = this.elementUtils.getTypeElement("java.util.Date").asType();
        if (!this.typeUtils.isAssignable(methodElement.getReturnType(), numberType) && !this.typeUtils.isSameType(methodElement.getReturnType(), dateType)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@" + String.valueOf(annotationElement.getSimpleName()) + " return type does not extend java.lang.Number and is not java.util.Date : " + methodElement.getReturnType().toString(), methodElement);
        }
    }

    public void checkTypeAgreesWithName(TypeElement annotationElement, ExecutableElement methodElement) {
        String methodName = methodElement.getSimpleName().toString();
        if ((methodName.startsWith("is") || methodName.startsWith("has")) && methodElement.getReturnType().getKind() != TypeKind.BOOLEAN && !this.typeUtils.isSameType(this.typeUtils.boxedClass(this.typeUtils.getPrimitiveType(TypeKind.BOOLEAN)).asType(), methodElement.getReturnType())) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@" + String.valueOf(annotationElement.getSimpleName()) + " return type is not boolean or Boolean: " + methodElement.getReturnType().toString(), methodElement);
        }
    }

    public void checkMethodReturnType(TypeElement annotationElement, ExecutableElement methodElement, boolean allowNamed, boolean allowAbstractManagedTypes) {
        if (!(AttributeAnnotationValidator.isValidType(this.processingEnv, methodElement.getReturnType(), allowAbstractManagedTypes) || allowNamed && this.isNamed(methodElement.getReturnType()))) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@" + String.valueOf(annotationElement.getSimpleName()) + " cannot be applied to methods with return type " + methodElement.getReturnType().toString(), methodElement);
        }
    }

    public void checkMethodName(TypeElement annotationElement, ExecutableElement methodElement) {
        String methodName = methodElement.getSimpleName().toString();
        if (methodName.length() < 3 || methodName.length() < 4 && !methodName.startsWith("is") || !methodName.startsWith("is") && !methodName.startsWith("get") && !methodName.startsWith("has")) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@" + String.valueOf(annotationElement.getSimpleName()) + " can only be applied to methods which of the form getXXX(), isXXX() or hasXXX()", methodElement);
        }
    }

    public void checkMethodTakesNoArgs(TypeElement annotationElement, ExecutableElement methodElement) {
        if (!methodElement.getParameters().isEmpty()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@" + String.valueOf(annotationElement.getSimpleName()) + " can only be applied to methods which take no parameters", methodElement);
        }
    }

    public void checkInterfaceExtendsConfiguredObject(TypeElement annotationElement, Element e) {
        TypeMirror configuredObjectType = this.getErasure("org.apache.qpid.server.model.ConfiguredObject");
        TypeElement parent = (TypeElement)e.getEnclosingElement();
        if (!this.typeUtils.isAssignable(this.typeUtils.erasure(parent.asType()), configuredObjectType)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@" + String.valueOf(annotationElement.getSimpleName()) + " can only be applied to methods within an interface which extends " + configuredObjectType.toString() + " which does not apply to " + parent.asType().toString(), e);
        }
    }

    public void checkAnnotationIsOnMethodInInterface(TypeElement annotationElement, Element e) {
        if (e.getKind() != ElementKind.METHOD || e.getEnclosingElement().getKind() != ElementKind.INTERFACE) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@" + String.valueOf(annotationElement.getSimpleName()) + " can only be applied to methods within an interface", e);
        }
    }

    static boolean isValidType(ProcessingEnvironment processingEnv, TypeMirror type, boolean allowAbstractManagedTypes) {
        Types typeUtils = processingEnv.getTypeUtils();
        Elements elementUtils = processingEnv.getElementUtils();
        Element typeElement = typeUtils.asElement(type);
        if (VALID_PRIMITIVE_TYPES.contains((Object)type.getKind())) {
            return true;
        }
        for (TypeKind primitive : VALID_PRIMITIVE_TYPES) {
            if (!typeUtils.isSameType(type, typeUtils.boxedClass(typeUtils.getPrimitiveType(primitive)).asType())) continue;
            return true;
        }
        if (typeElement != null && typeElement.getKind() == ElementKind.ENUM) {
            return true;
        }
        String className = "org.apache.qpid.server.model.ConfiguredObject";
        TypeMirror configuredObjectType = AttributeAnnotationValidator.getErasure(processingEnv, className);
        if (typeUtils.isAssignable(typeUtils.erasure(type), configuredObjectType)) {
            return true;
        }
        TypeElement managedAttributeTypeValueElement = elementUtils.getTypeElement("org.apache.qpid.server.model.ManagedAttributeValueType");
        if (typeElement != null) {
            for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().asElement().equals(managedAttributeTypeValueElement)) continue;
                if (allowAbstractManagedTypes) {
                    return true;
                }
                Map<? extends ExecutableElement, ? extends AnnotationValue> map = elementUtils.getElementValuesWithDefaults(annotationMirror);
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> element : map.entrySet()) {
                    if (!"isAbstract".contentEquals(element.getKey().getSimpleName())) continue;
                    return element.getValue().getValue().equals(Boolean.FALSE);
                }
                return false;
            }
        }
        if (typeUtils.isSameType(type, elementUtils.getTypeElement("java.lang.Object").asType())) {
            return true;
        }
        if (typeUtils.isSameType(type, elementUtils.getTypeElement("java.lang.String").asType())) {
            return true;
        }
        if (typeUtils.isSameType(type, elementUtils.getTypeElement("java.util.UUID").asType())) {
            return true;
        }
        if (typeUtils.isSameType(type, elementUtils.getTypeElement("java.util.Date").asType())) {
            return true;
        }
        if (typeUtils.isSameType(type, elementUtils.getTypeElement("java.net.URI").asType())) {
            return true;
        }
        if (typeUtils.isSameType(type, elementUtils.getTypeElement("java.security.cert.Certificate").asType())) {
            return true;
        }
        if (typeUtils.isSameType(type, elementUtils.getTypeElement("java.security.Principal").asType())) {
            return true;
        }
        TypeMirror erasedType = typeUtils.erasure(type);
        if (typeUtils.isSameType(erasedType, AttributeAnnotationValidator.getErasure(processingEnv, "java.util.List")) || typeUtils.isSameType(erasedType, AttributeAnnotationValidator.getErasure(processingEnv, "java.util.Set")) || typeUtils.isSameType(erasedType, AttributeAnnotationValidator.getErasure(processingEnv, "java.util.Collection"))) {
            for (TypeMirror typeMirror : ((DeclaredType)type).getTypeArguments()) {
                if (AttributeAnnotationValidator.isValidType(processingEnv, typeMirror, allowAbstractManagedTypes)) continue;
                return false;
            }
            return true;
        }
        if (typeUtils.isSameType(erasedType, AttributeAnnotationValidator.getErasure(processingEnv, "java.util.Map"))) {
            List<? extends TypeMirror> list = ((DeclaredType)type).getTypeArguments();
            if (list.size() != 2) {
                throw new IllegalArgumentException("Map types " + String.valueOf(type) + " must have exactly two type arguments");
            }
            return AttributeAnnotationValidator.isValidType(processingEnv, list.get(0), false) && (AttributeAnnotationValidator.isValidType(processingEnv, list.get(1), false) || typeUtils.isSameType(list.get(1), AttributeAnnotationValidator.getErasure(processingEnv, "java.lang.Object")));
        }
        return false;
    }

    private boolean isNamed(TypeMirror type) {
        return AttributeAnnotationValidator.isNamed(this.processingEnv, type);
    }

    static boolean isNamed(ProcessingEnvironment processingEnv, TypeMirror type) {
        Types typeUtils = processingEnv.getTypeUtils();
        String className = "org.apache.qpid.server.model.Named";
        TypeMirror namedType = AttributeAnnotationValidator.getErasure(processingEnv, className);
        return typeUtils.isAssignable(typeUtils.erasure(type), namedType);
    }

    private TypeMirror getErasure(String className) {
        return AttributeAnnotationValidator.getErasure(this.processingEnv, className);
    }

    private static TypeMirror getErasure(ProcessingEnvironment processingEnv, String className) {
        Types typeUtils = processingEnv.getTypeUtils();
        Elements elementUtils = processingEnv.getElementUtils();
        return typeUtils.erasure(elementUtils.getTypeElement(className).asType());
    }
}

