/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.util.concurrent.RateLimiter;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import org.HdrHistogram.EncodableHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramLogWriter;
import org.HdrHistogram.Recorder;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.client.impl.ConsumerBase;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.MultiTopicsConsumerImpl;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.testclient.PerfClientUtils;
import org.apache.pulsar.testclient.PerformanceBaseArguments;
import org.apache.pulsar.testclient.PositiveNumberParameterValidator;
import org.apache.pulsar.testclient.utils.PaddingDecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceConsumer {
    private static final LongAdder messagesReceived = new LongAdder();
    private static final LongAdder bytesReceived = new LongAdder();
    private static final DecimalFormat intFormat = new PaddingDecimalFormat("0", 7);
    private static final DecimalFormat dec = new DecimalFormat("0.000");
    private static final LongAdder totalMessagesReceived = new LongAdder();
    private static final LongAdder totalBytesReceived = new LongAdder();
    private static final LongAdder totalNumTxnOpenFail = new LongAdder();
    private static final LongAdder totalNumTxnOpenSuccess = new LongAdder();
    private static final LongAdder totalMessageAck = new LongAdder();
    private static final LongAdder totalMessageAckFailed = new LongAdder();
    private static final LongAdder messageAck = new LongAdder();
    private static final LongAdder totalEndTxnOpFailNum = new LongAdder();
    private static final LongAdder totalEndTxnOpSuccessNum = new LongAdder();
    private static final LongAdder numTxnOpSuccess = new LongAdder();
    private static final long MAX_LATENCY = TimeUnit.DAYS.toMillis(10L);
    private static final Recorder recorder = new Recorder(MAX_LATENCY, 5);
    private static final Recorder cumulativeRecorder = new Recorder(MAX_LATENCY, 5);
    private static final Logger log = LoggerFactory.getLogger(PerformanceConsumer.class);

    public static void main(String[] args) throws Exception {
        Arguments arguments = new Arguments();
        JCommander jc = new JCommander((Object)arguments);
        jc.setProgramName("pulsar-perf consume");
        try {
            jc.parse(args);
        }
        catch (ParameterException e) {
            System.out.println(e.getMessage());
            jc.usage();
            PerfClientUtils.exit(1);
        }
        if (arguments.help) {
            jc.usage();
            PerfClientUtils.exit(1);
        }
        if (StringUtils.isBlank((CharSequence)arguments.authPluginClassName) && !StringUtils.isBlank((CharSequence)arguments.deprecatedAuthPluginClassName)) {
            arguments.authPluginClassName = arguments.deprecatedAuthPluginClassName;
        }
        for (String arg : arguments.topic) {
            if (!arg.startsWith("-")) continue;
            System.out.printf("invalid option: '%s'\nTo use a topic with the name '%s', please use a fully qualified topic name\n", arg, arg);
            jc.usage();
            PerfClientUtils.exit(1);
        }
        if (arguments.topic != null && arguments.topic.size() != arguments.numTopics) {
            if (arguments.topic.size() == 1) {
                String prefixTopicName = TopicName.get((String)arguments.topic.get(0)).toString().trim();
                ArrayList<String> defaultTopics = new ArrayList<String>();
                for (int i = 0; i < arguments.numTopics; ++i) {
                    defaultTopics.add(String.format("%s-%d", prefixTopicName, i));
                }
                arguments.topic = defaultTopics;
            } else {
                System.out.println("The size of topics list should be equal to --num-topics");
                jc.usage();
                PerfClientUtils.exit(1);
            }
        }
        if (arguments.subscriptionType == SubscriptionType.Exclusive && arguments.numConsumers > 1) {
            System.out.println("Only one consumer is allowed when subscriptionType is Exclusive");
            jc.usage();
            PerfClientUtils.exit(1);
        }
        if (arguments.subscriptions != null && arguments.subscriptions.size() != arguments.numSubscriptions) {
            if (arguments.subscriptions.size() == 1) {
                if (arguments.subscriberName == null) {
                    arguments.subscriberName = arguments.subscriptions.get(0);
                }
                ArrayList<String> defaultSubscriptions = new ArrayList<String>();
                for (int i = 0; i < arguments.numSubscriptions; ++i) {
                    defaultSubscriptions.add(String.format("%s-%d", arguments.subscriberName, i));
                }
                arguments.subscriptions = defaultSubscriptions;
            } else {
                System.out.println("The size of subscriptions list should be equal to --num-subscriptions");
                jc.usage();
                PerfClientUtils.exit(1);
            }
        }
        arguments.fillArgumentsFromProperties();
        PerfClientUtils.printJVMInformation(log);
        ObjectMapper m = new ObjectMapper();
        ObjectWriter w = m.writerWithDefaultPrettyPrinter();
        log.info("Starting Pulsar performance consumer with config: {}", (Object)w.writeValueAsString((Object)arguments));
        Recorder qRecorder = arguments.autoScaledReceiverQueueSize ? new Recorder((long)arguments.receiverQueueSize, 5) : null;
        RateLimiter limiter = arguments.rate > 0.0 ? RateLimiter.create((double)arguments.rate) : null;
        long startTime = System.nanoTime();
        long testEndTime = startTime + (long)((double)arguments.testTime * 1.0E9);
        ClientBuilder clientBuilder = PerfClientUtils.createClientBuilderFromArguments(arguments).enableTransaction(arguments.isEnableTransaction);
        PulsarClient pulsarClient = clientBuilder.build();
        AtomicReference<Object> atomicReference = arguments.isEnableTransaction ? new AtomicReference<Transaction>((Transaction)pulsarClient.newTransaction().withTransactionTimeout(arguments.transactionTimeout, TimeUnit.SECONDS).build().get()) : new AtomicReference<Object>(null);
        AtomicLong messageAckedCount = new AtomicLong();
        Semaphore messageReceiveLimiter = new Semaphore(arguments.numMessagesPerTransaction);
        Thread thread = Thread.currentThread();
        MessageListener & Serializable listener = (MessageListener & Serializable)(consumer, msg) -> {
            long latencyMillis;
            if (arguments.testTime > 0L && System.nanoTime() > testEndTime) {
                log.info("------------------- DONE -----------------------");
                PerfClientUtils.exit(0);
                thread.interrupt();
            }
            if (arguments.totalNumTxn > 0L && totalEndTxnOpFailNum.sum() + totalEndTxnOpSuccessNum.sum() >= arguments.totalNumTxn) {
                log.info("------------------- DONE -----------------------");
                PerfClientUtils.exit(0);
                thread.interrupt();
            }
            if (qRecorder != null) {
                qRecorder.recordValue((long)((ConsumerBase)consumer).getTotalIncomingMessages());
            }
            messagesReceived.increment();
            bytesReceived.add(msg.size());
            totalMessagesReceived.increment();
            totalBytesReceived.add(msg.size());
            if (arguments.numMessages > 0L && totalMessagesReceived.sum() >= arguments.numMessages) {
                log.info("------------------- DONE -----------------------");
                PerfClientUtils.exit(0);
                thread.interrupt();
            }
            if (limiter != null) {
                limiter.acquire();
            }
            if ((latencyMillis = System.currentTimeMillis() - msg.getPublishTime()) >= 0L) {
                if (latencyMillis >= MAX_LATENCY) {
                    latencyMillis = MAX_LATENCY;
                }
                recorder.recordValue(latencyMillis);
                cumulativeRecorder.recordValue(latencyMillis);
            }
            if (arguments.isEnableTransaction) {
                try {
                    messageReceiveLimiter.acquire();
                }
                catch (InterruptedException e) {
                    log.error("Got error: ", (Throwable)e);
                }
                ((CompletableFuture)consumer.acknowledgeAsync(msg.getMessageId(), (Transaction)atomicReference.get()).thenRun(() -> {
                    totalMessageAck.increment();
                    messageAck.increment();
                })).exceptionally(throwable -> {
                    log.error("Ack message {} failed with exception", (Object)msg, throwable);
                    totalMessageAckFailed.increment();
                    return null;
                });
            } else {
                ((CompletableFuture)consumer.acknowledgeAsync(msg).thenRun(() -> {
                    totalMessageAck.increment();
                    messageAck.increment();
                })).exceptionally(throwable -> {
                    log.error("Ack message {} failed with exception", (Object)msg, throwable);
                    totalMessageAckFailed.increment();
                    return null;
                });
            }
            if (arguments.poolMessages) {
                msg.release();
            }
            if (arguments.isEnableTransaction && messageAckedCount.incrementAndGet() == (long)arguments.numMessagesPerTransaction) {
                Transaction transaction = (Transaction)atomicReference.get();
                if (!arguments.isAbortTransaction) {
                    ((CompletableFuture)transaction.commit().thenRun(() -> {
                        if (log.isDebugEnabled()) {
                            log.debug("Commit transaction {}", (Object)transaction.getTxnID());
                        }
                        totalEndTxnOpSuccessNum.increment();
                        numTxnOpSuccess.increment();
                    })).exceptionally(exception -> {
                        log.error("Commit transaction failed with exception : ", exception);
                        totalEndTxnOpFailNum.increment();
                        return null;
                    });
                } else {
                    ((CompletableFuture)transaction.abort().thenRun(() -> {
                        if (log.isDebugEnabled()) {
                            log.debug("Abort transaction {}", (Object)transaction.getTxnID());
                        }
                        totalEndTxnOpSuccessNum.increment();
                        numTxnOpSuccess.increment();
                    })).exceptionally(exception -> {
                        log.error("Abort transaction {} failed with exception", (Object)transaction.getTxnID().toString(), exception);
                        totalEndTxnOpFailNum.increment();
                        return null;
                    });
                }
                while (true) {
                    try {
                        Transaction newTransaction = (Transaction)pulsarClient.newTransaction().withTransactionTimeout(arguments.transactionTimeout, TimeUnit.SECONDS).build().get();
                        atomicReference.compareAndSet(transaction, newTransaction);
                        totalNumTxnOpenSuccess.increment();
                        messageAckedCount.set(0L);
                        messageReceiveLimiter.release(arguments.numMessagesPerTransaction);
                    }
                    catch (Exception e) {
                        log.error("Failed to new transaction with exception:", (Throwable)e);
                        totalNumTxnOpenFail.increment();
                        continue;
                    }
                    break;
                }
            }
        };
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        ConsumerBuilder consumerBuilder = pulsarClient.newConsumer(Schema.BYTEBUFFER).messageListener((MessageListener)listener).receiverQueueSize(arguments.receiverQueueSize).maxTotalReceiverQueueSizeAcrossPartitions(arguments.maxTotalReceiverQueueSizeAcrossPartitions).acknowledgmentGroupTime((long)arguments.acknowledgmentsGroupingDelayMillis, TimeUnit.MILLISECONDS).subscriptionType(arguments.subscriptionType).subscriptionInitialPosition(arguments.subscriptionInitialPosition).autoAckOldestChunkedMessageOnQueueFull(arguments.autoAckOldestChunkedMessageOnQueueFull).enableBatchIndexAcknowledgment(arguments.batchIndexAck).poolMessages(arguments.poolMessages).replicateSubscriptionState(arguments.replicatedSubscription).autoScaledReceiverQueueSizeEnabled(arguments.autoScaledReceiverQueueSize);
        if (arguments.maxPendingChunkedMessage > 0) {
            consumerBuilder.maxPendingChunkedMessage(arguments.maxPendingChunkedMessage);
        }
        if (arguments.expireTimeOfIncompleteChunkedMessageMs > 0L) {
            consumerBuilder.expireTimeOfIncompleteChunkedMessage(arguments.expireTimeOfIncompleteChunkedMessageMs, TimeUnit.MILLISECONDS);
        }
        if (StringUtils.isNotBlank((CharSequence)arguments.encKeyFile)) {
            consumerBuilder.defaultCryptoKeyReader(arguments.encKeyFile);
        }
        for (int i = 0; i < arguments.numTopics; ++i) {
            TopicName topicName = TopicName.get((String)arguments.topic.get(i));
            log.info("Adding {} consumers per subscription on topic {}", (Object)arguments.numConsumers, (Object)topicName);
            for (int j = 0; j < arguments.numSubscriptions; ++j) {
                String subscriberName = arguments.subscriptions.get(j);
                for (int k = 0; k < arguments.numConsumers; ++k) {
                    futures.add(consumerBuilder.clone().topic(new String[]{topicName.toString()}).subscriptionName(subscriberName).subscribeAsync());
                }
            }
        }
        for (Future future : futures) {
            future.get();
        }
        log.info("Start receiving from {} consumers per subscription on {} topics", (Object)arguments.numConsumers, (Object)arguments.numTopics);
        long start = System.nanoTime();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            PerformanceConsumer.printAggregatedThroughput(start, arguments);
            PerformanceConsumer.printAggregatedStats();
        }));
        long oldTime = System.nanoTime();
        Histogram reportHistogram = null;
        Histogram qHistogram = null;
        HistogramLogWriter histogramLogWriter = null;
        if (arguments.histogramFile != null) {
            String statsFileName = arguments.histogramFile;
            log.info("Dumping latency stats to {}", (Object)statsFileName);
            PrintStream histogramLog = new PrintStream(new FileOutputStream(statsFileName), false);
            histogramLogWriter = new HistogramLogWriter(histogramLog);
            histogramLogWriter.outputLogFormatVersion();
            histogramLogWriter.outputLegend();
        }
        while (true) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                break;
            }
            long now = System.nanoTime();
            double elapsed = (double)(now - oldTime) / 1.0E9;
            long total = totalMessagesReceived.sum();
            double rate = (double)messagesReceived.sumThenReset() / elapsed;
            double throughput = (double)bytesReceived.sumThenReset() / elapsed * 8.0 / 1024.0 / 1024.0;
            double rateAck = (double)messageAck.sumThenReset() / elapsed;
            long totalTxnOpSuccessNum = 0L;
            long totalTxnOpFailNum = 0L;
            double rateOpenTxn = 0.0;
            reportHistogram = recorder.getIntervalHistogram(reportHistogram);
            if (arguments.isEnableTransaction) {
                totalTxnOpSuccessNum = totalEndTxnOpSuccessNum.sum();
                totalTxnOpFailNum = totalEndTxnOpFailNum.sum();
                rateOpenTxn = (double)numTxnOpSuccess.sumThenReset() / elapsed;
                log.info("--- Transaction: {} transaction end successfully --- {} transaction end failed --- {}  Txn/s --- AckRate: {} msg/s", new Object[]{totalTxnOpSuccessNum, totalTxnOpFailNum, dec.format(rateOpenTxn), dec.format(rateAck)});
            }
            log.info("Throughput received: {} msg --- {}  msg/s --- {} Mbit/s  --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - Max: {}", new Object[]{intFormat.format(total), dec.format(rate), dec.format(throughput), dec.format(reportHistogram.getMean()), reportHistogram.getValueAtPercentile(50.0), reportHistogram.getValueAtPercentile(95.0), reportHistogram.getValueAtPercentile(99.0), reportHistogram.getValueAtPercentile(99.9), reportHistogram.getValueAtPercentile(99.99), reportHistogram.getMaxValue()});
            if (arguments.autoScaledReceiverQueueSize && log.isDebugEnabled() && qRecorder != null) {
                qHistogram = qRecorder.getIntervalHistogram(qHistogram);
                log.debug("ReceiverQueueUsage: cnt={},mean={}, min={},max={},25pct={},50pct={},75pct={}", new Object[]{qHistogram.getTotalCount(), dec.format(qHistogram.getMean()), qHistogram.getMinValue(), qHistogram.getMaxValue(), qHistogram.getValueAtPercentile(25.0), qHistogram.getValueAtPercentile(50.0), qHistogram.getValueAtPercentile(75.0)});
                qHistogram.reset();
                for (Future future : futures) {
                    ConsumerBase consumerBase = (ConsumerBase)future.get();
                    log.debug("[{}] CurrentReceiverQueueSize={}", (Object)consumerBase.getConsumerName(), (Object)consumerBase.getCurrentReceiverQueueSize());
                    if (!(consumerBase instanceof MultiTopicsConsumerImpl)) continue;
                    for (ConsumerImpl consumer2 : ((MultiTopicsConsumerImpl)consumerBase).getConsumers()) {
                        log.debug("[{}] SubConsumer.CurrentReceiverQueueSize={}", (Object)consumer2.getConsumerName(), (Object)consumer2.getCurrentReceiverQueueSize());
                    }
                }
            }
            if (histogramLogWriter != null) {
                histogramLogWriter.outputIntervalHistogram((EncodableHistogram)reportHistogram);
            }
            reportHistogram.reset();
            oldTime = now;
        }
        pulsarClient.close();
    }

    private static void printAggregatedThroughput(long start, Arguments arguments) {
        double elapsed = (double)(System.nanoTime() - start) / 1.0E9;
        double rate = (double)totalMessagesReceived.sum() / elapsed;
        double throughput = (double)totalBytesReceived.sum() / elapsed * 8.0 / 1024.0 / 1024.0;
        long totalEndTxnSuccess = 0L;
        long totalEndTxnFail = 0L;
        long numTransactionOpenFailed = 0L;
        long numTransactionOpenSuccess = 0L;
        long totalnumMessageAckFailed = 0L;
        double rateAck = (double)totalMessageAck.sum() / elapsed;
        double rateOpenTxn = 0.0;
        if (arguments.isEnableTransaction) {
            totalEndTxnSuccess = totalEndTxnOpSuccessNum.sum();
            totalEndTxnFail = totalEndTxnOpFailNum.sum();
            rateOpenTxn = (double)(totalEndTxnSuccess + totalEndTxnFail) / elapsed;
            totalnumMessageAckFailed = totalMessageAckFailed.sum();
            numTransactionOpenFailed = totalNumTxnOpenFail.sum();
            numTransactionOpenSuccess = totalNumTxnOpenSuccess.sum();
            log.info("-- Transaction: {}  transaction end successfully --- {} transaction end failed --- {} transaction open successfully --- {} transaction open failed --- {} Txn/s ", new Object[]{totalEndTxnSuccess, totalEndTxnFail, numTransactionOpenSuccess, numTransactionOpenFailed, dec.format(rateOpenTxn)});
        }
        log.info("Aggregated throughput stats --- {} records received --- {} msg/s --- {} Mbit/s --- AckRate: {}  msg/s --- ack failed {} msg", new Object[]{totalMessagesReceived.sum(), dec.format(rate), dec.format(throughput), rateAck, totalnumMessageAckFailed});
    }

    private static void printAggregatedStats() {
        Histogram reportHistogram = cumulativeRecorder.getIntervalHistogram();
        log.info("Aggregated latency stats --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - 99.999pct: {} - Max: {}", new Object[]{dec.format(reportHistogram.getMean()), reportHistogram.getValueAtPercentile(50.0), reportHistogram.getValueAtPercentile(95.0), reportHistogram.getValueAtPercentile(99.0), reportHistogram.getValueAtPercentile(99.9), reportHistogram.getValueAtPercentile(99.99), reportHistogram.getValueAtPercentile(99.999), reportHistogram.getMaxValue()});
    }

    @Parameters(commandDescription="Test pulsar consumer performance.")
    static class Arguments
    extends PerformanceBaseArguments {
        @Parameter(description="persistent://prop/ns/my-topic", required=true)
        public List<String> topic;
        @Parameter(names={"-t", "--num-topics"}, description="Number of topics", validateWith={PositiveNumberParameterValidator.class})
        public int numTopics = 1;
        @Parameter(names={"-n", "--num-consumers"}, description="Number of consumers (per subscription), only one consumer is allowed when subscriptionType is Exclusive", validateWith={PositiveNumberParameterValidator.class})
        public int numConsumers = 1;
        @Parameter(names={"-ns", "--num-subscriptions"}, description="Number of subscriptions (per topic)", validateWith={PositiveNumberParameterValidator.class})
        public int numSubscriptions = 1;
        @Parameter(names={"-s", "--subscriber-name"}, description="Subscriber name prefix", hidden=true)
        public String subscriberName;
        @Parameter(names={"-ss", "--subscriptions"}, description="A list of subscriptions to consume (for example, sub1,sub2)")
        public List<String> subscriptions = Collections.singletonList("sub");
        @Parameter(names={"-st", "--subscription-type"}, description="Subscription type")
        public SubscriptionType subscriptionType = SubscriptionType.Exclusive;
        @Parameter(names={"-sp", "--subscription-position"}, description="Subscription position")
        private SubscriptionInitialPosition subscriptionInitialPosition = SubscriptionInitialPosition.Latest;
        @Parameter(names={"-r", "--rate"}, description="Simulate a slow message consumer (rate in msg/s)")
        public double rate = 0.0;
        @Parameter(names={"-q", "--receiver-queue-size"}, description="Size of the receiver queue")
        public int receiverQueueSize = 1000;
        @Parameter(names={"-p", "--receiver-queue-size-across-partitions"}, description="Max total size of the receiver queue across partitions")
        public int maxTotalReceiverQueueSizeAcrossPartitions = 50000;
        @Parameter(names={"-aq", "--auto-scaled-receiver-queue-size"}, description="Enable autoScaledReceiverQueueSize")
        public boolean autoScaledReceiverQueueSize = false;
        @Parameter(names={"-rs", "--replicated"}, description="Whether the subscription status should be replicated")
        public boolean replicatedSubscription = false;
        @Parameter(names={"--acks-delay-millis"}, description="Acknowledgements grouping delay in millis")
        public int acknowledgmentsGroupingDelayMillis = 100;
        @Parameter(names={"-m", "--num-messages"}, description="Number of messages to consume in total. If <= 0, it will keep consuming")
        public long numMessages = 0L;
        @Parameter(names={"--auth_plugin"}, description="Authentication plugin class name", hidden=true)
        public String deprecatedAuthPluginClassName;
        @Parameter(names={"-mc", "--max_chunked_msg"}, description="Max pending chunk messages")
        private int maxPendingChunkedMessage = 0;
        @Parameter(names={"-ac", "--auto_ack_chunk_q_full"}, description="Auto ack for oldest message on queue is full")
        private boolean autoAckOldestChunkedMessageOnQueueFull = false;
        @Parameter(names={"-e", "--expire_time_incomplete_chunked_messages"}, description="Expire time in ms for incomplete chunk messages")
        private long expireTimeOfIncompleteChunkedMessageMs = 0L;
        @Parameter(names={"-v", "--encryption-key-value-file"}, description="The file which contains the private key to decrypt payload")
        public String encKeyFile = null;
        @Parameter(names={"-time", "--test-duration"}, description="Test duration in secs. If <= 0, it will keep consuming")
        public long testTime = 0L;
        @Parameter(names={"--batch-index-ack"}, description="Enable or disable the batch index acknowledgment")
        public boolean batchIndexAck = false;
        @Parameter(names={"-pm", "--pool-messages"}, description="Use the pooled message", arity=1)
        private boolean poolMessages = true;
        @Parameter(names={"-tto", "--txn-timeout"}, description="Set the time value of transaction timeout, and the time unit is second. (After --txn-enable setting to true, --txn-timeout takes effect)")
        public long transactionTimeout = 10L;
        @Parameter(names={"-nmt", "--numMessage-perTransaction"}, description="The number of messages acknowledged by a transaction. (After --txn-enable setting to true, -numMessage-perTransaction takes effect")
        public int numMessagesPerTransaction = 50;
        @Parameter(names={"-txn", "--txn-enable"}, description="Enable or disable the transaction")
        public boolean isEnableTransaction = false;
        @Parameter(names={"-ntxn"}, description="The number of opened transactions, 0 means keeping open.(After --txn-enable setting to true, -ntxn takes effect.)")
        public long totalNumTxn = 0L;
        @Parameter(names={"-abort"}, description="Abort the transaction. (After --txn-enable setting to true, -abort takes effect)")
        public boolean isAbortTransaction = false;
        @Parameter(names={"--histogram-file"}, description="HdrHistogram output file")
        public String histogramFile = null;

        Arguments() {
        }

        @Override
        public void fillArgumentsFromProperties(Properties prop) {
        }
    }
}

