/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.jdbc;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.pulsar.io.core.annotations.Connector;
import org.apache.pulsar.io.core.annotations.IOType;
import org.apache.pulsar.io.jdbc.BaseJdbcAutoSchemaSink;
import org.apache.pulsar.io.jdbc.JdbcSinkConfig;
import org.apache.pulsar.io.jdbc.JdbcUtils;

@Connector(name="jdbc-sqlite", type=IOType.SINK, help="A simple JDBC sink for SQLite that writes pulsar messages to a database table", configClass=JdbcSinkConfig.class)
public class SqliteJdbcAutoSchemaSink
extends BaseJdbcAutoSchemaSink {
    public String generateUpsertQueryStatement() {
        List keyColumns = this.tableDefinition.getKeyColumns();
        if (keyColumns.isEmpty()) {
            throw new IllegalStateException("UPSERT is not supported if 'key' config is not set.");
        }
        String keys = keyColumns.stream().map(JdbcUtils.ColumnId::getName).collect(Collectors.joining(","));
        return JdbcUtils.buildInsertSql((JdbcUtils.TableDefinition)this.tableDefinition) + " ON CONFLICT(" + keys + ") DO UPDATE SET " + String.valueOf(JdbcUtils.buildUpdateSqlSetPart((JdbcUtils.TableDefinition)this.tableDefinition));
    }

    public List<JdbcUtils.ColumnId> getColumnsForUpsert() {
        ArrayList<JdbcUtils.ColumnId> columns = new ArrayList<JdbcUtils.ColumnId>();
        columns.addAll(this.tableDefinition.getColumns());
        columns.addAll(this.tableDefinition.getNonKeyColumns());
        return columns;
    }
}

