/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.pulsar.functions.worker.ErrorNotifier;

public class ErrorNotifierImpl
implements ErrorNotifier {
    private static final long serialVersionUID = 1L;
    private final AtomicReference<Throwable> error = new AtomicReference();
    private volatile boolean isRunning = true;

    @Override
    public synchronized void triggerError(Throwable th) {
        this.error.set(th);
        this.notify();
    }

    @Override
    public synchronized void waitForError() throws Exception {
        while (this.isRunning && this.error.get() == null) {
            this.wait();
        }
        if (this.isRunning) {
            throw new Exception(this.error.get());
        }
    }

    @Override
    public synchronized void close() {
        this.isRunning = false;
        this.notify();
    }
}

