/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils.functions;

import java.nio.file.Path;
import org.apache.pulsar.common.functions.FunctionDefinition;
import org.apache.pulsar.functions.utils.FunctionFilePackage;
import org.apache.pulsar.functions.utils.ValidatableFunctionPackage;

public class FunctionArchive
implements AutoCloseable {
    private final Path archivePath;
    private final FunctionDefinition functionDefinition;
    private final String narExtractionDirectory;
    private final boolean enableClassloading;
    private ValidatableFunctionPackage functionPackage;
    private boolean closed;

    public FunctionArchive(Path archivePath, FunctionDefinition functionDefinition, String narExtractionDirectory, boolean enableClassloading) {
        this.archivePath = archivePath;
        this.functionDefinition = functionDefinition;
        this.narExtractionDirectory = narExtractionDirectory;
        this.enableClassloading = enableClassloading;
    }

    public Path getArchivePath() {
        return this.archivePath;
    }

    public synchronized ValidatableFunctionPackage getFunctionPackage() {
        if (this.closed) {
            throw new IllegalStateException("FunctionArchive is already closed");
        }
        if (this.functionPackage == null) {
            this.functionPackage = new FunctionFilePackage(this.archivePath.toFile(), this.narExtractionDirectory, this.enableClassloading, FunctionDefinition.class);
        }
        return this.functionPackage;
    }

    public FunctionDefinition getFunctionDefinition() {
        return this.functionDefinition;
    }

    @Override
    public synchronized void close() throws Exception {
        this.closed = true;
        if (this.functionPackage instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.functionPackage)).close();
        }
    }
}

