/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.source;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.api.EncryptionContext;
import org.apache.pulsar.functions.source.RecordWithEncryptionContext;
import org.apache.pulsar.functions.utils.FunctionCommon;

public class PulsarRecord<T>
implements RecordWithEncryptionContext<T> {
    private final String topicName;
    private final int partition;
    private final Message<T> message;
    private final Schema<T> schema;
    private final Runnable failFunction;
    private final Runnable ackFunction;
    private final Consumer<Boolean> customAckFunction;

    public Optional<String> getKey() {
        if (this.message.hasKey()) {
            return Optional.of(this.message.getKey());
        }
        return Optional.empty();
    }

    public Optional<String> getTopicName() {
        return Optional.of(this.topicName);
    }

    public Optional<Integer> getPartitionIndex() {
        return Optional.of(this.partition);
    }

    public Optional<String> getPartitionId() {
        return Optional.of(String.format("%s-%s", this.topicName, this.partition));
    }

    public Optional<Long> getRecordSequence() {
        return Optional.of(FunctionCommon.getSequenceId((MessageId)this.message.getMessageId()));
    }

    public T getValue() {
        return (T)this.message.getValue();
    }

    public Schema<T> getSchema() {
        return this.schema;
    }

    public Optional<Long> getEventTime() {
        if (this.message.getEventTime() != 0L) {
            return Optional.of(this.message.getEventTime());
        }
        return Optional.empty();
    }

    public void cumulativeAck() {
        this.customAckFunction.accept(true);
    }

    public void individualAck() {
        this.customAckFunction.accept(false);
    }

    @Override
    public Optional<EncryptionContext> getEncryptionCtx() {
        return this.message.getEncryptionCtx();
    }

    public Map<String, String> getProperties() {
        return this.message.getProperties();
    }

    public MessageId getMessageId() {
        return this.message.getMessageId();
    }

    public void ack() {
        this.ackFunction.run();
    }

    public void fail() {
        this.failFunction.run();
    }

    public Optional<Message<T>> getMessage() {
        return Optional.of(this.message);
    }

    @Generated
    PulsarRecord(String topicName, int partition, Message<T> message, Schema<T> schema, Runnable failFunction, Runnable ackFunction, Consumer<Boolean> customAckFunction) {
        this.topicName = topicName;
        this.partition = partition;
        this.message = message;
        this.schema = schema;
        this.failFunction = failFunction;
        this.ackFunction = ackFunction;
        this.customAckFunction = customAckFunction;
    }

    @Generated
    public static <T> PulsarRecordBuilder<T> builder() {
        return new PulsarRecordBuilder();
    }

    @Generated
    public int getPartition() {
        return this.partition;
    }

    @Generated
    public Runnable getFailFunction() {
        return this.failFunction;
    }

    @Generated
    public Runnable getAckFunction() {
        return this.ackFunction;
    }

    @Generated
    public Consumer<Boolean> getCustomAckFunction() {
        return this.customAckFunction;
    }

    @Generated
    public String toString() {
        return "PulsarRecord(topicName=" + String.valueOf(this.getTopicName()) + ", partition=" + this.getPartition() + ", message=" + String.valueOf(this.getMessage()) + ", schema=" + String.valueOf(this.getSchema()) + ", failFunction=" + String.valueOf(this.getFailFunction()) + ", ackFunction=" + String.valueOf(this.getAckFunction()) + ", customAckFunction=" + String.valueOf(this.getCustomAckFunction()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarRecord)) {
            return false;
        }
        PulsarRecord other = (PulsarRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPartition() != other.getPartition()) {
            return false;
        }
        Optional<String> this$topicName = this.getTopicName();
        Optional<String> other$topicName = other.getTopicName();
        if (this$topicName == null ? other$topicName != null : !((Object)this$topicName).equals(other$topicName)) {
            return false;
        }
        Optional<Message<T>> this$message = this.getMessage();
        Optional<Message<T>> other$message = other.getMessage();
        if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
            return false;
        }
        Schema<T> this$schema = this.getSchema();
        Schema<T> other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        Runnable this$failFunction = this.getFailFunction();
        Runnable other$failFunction = other.getFailFunction();
        if (this$failFunction == null ? other$failFunction != null : !this$failFunction.equals(other$failFunction)) {
            return false;
        }
        Runnable this$ackFunction = this.getAckFunction();
        Runnable other$ackFunction = other.getAckFunction();
        if (this$ackFunction == null ? other$ackFunction != null : !this$ackFunction.equals(other$ackFunction)) {
            return false;
        }
        Consumer<Boolean> this$customAckFunction = this.getCustomAckFunction();
        Consumer<Boolean> other$customAckFunction = other.getCustomAckFunction();
        return !(this$customAckFunction == null ? other$customAckFunction != null : !this$customAckFunction.equals(other$customAckFunction));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PulsarRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPartition();
        Optional<String> $topicName = this.getTopicName();
        result = result * 59 + ($topicName == null ? 43 : ((Object)$topicName).hashCode());
        Optional<Message<T>> $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        Schema<T> $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        Runnable $failFunction = this.getFailFunction();
        result = result * 59 + ($failFunction == null ? 43 : $failFunction.hashCode());
        Runnable $ackFunction = this.getAckFunction();
        result = result * 59 + ($ackFunction == null ? 43 : $ackFunction.hashCode());
        Consumer<Boolean> $customAckFunction = this.getCustomAckFunction();
        result = result * 59 + ($customAckFunction == null ? 43 : $customAckFunction.hashCode());
        return result;
    }

    @Generated
    public static class PulsarRecordBuilder<T> {
        @Generated
        private String topicName;
        @Generated
        private int partition;
        @Generated
        private Message<T> message;
        @Generated
        private Schema<T> schema;
        @Generated
        private Runnable failFunction;
        @Generated
        private Runnable ackFunction;
        @Generated
        private Consumer<Boolean> customAckFunction;

        @Generated
        PulsarRecordBuilder() {
        }

        @Generated
        public PulsarRecordBuilder<T> topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        @Generated
        public PulsarRecordBuilder<T> partition(int partition) {
            this.partition = partition;
            return this;
        }

        @Generated
        public PulsarRecordBuilder<T> message(Message<T> message) {
            this.message = message;
            return this;
        }

        @Generated
        public PulsarRecordBuilder<T> schema(Schema<T> schema) {
            this.schema = schema;
            return this;
        }

        @Generated
        public PulsarRecordBuilder<T> failFunction(Runnable failFunction) {
            this.failFunction = failFunction;
            return this;
        }

        @Generated
        public PulsarRecordBuilder<T> ackFunction(Runnable ackFunction) {
            this.ackFunction = ackFunction;
            return this;
        }

        @Generated
        public PulsarRecordBuilder<T> customAckFunction(Consumer<Boolean> customAckFunction) {
            this.customAckFunction = customAckFunction;
            return this;
        }

        @Generated
        public PulsarRecord<T> build() {
            return new PulsarRecord<T>(this.topicName, this.partition, this.message, this.schema, this.failFunction, this.ackFunction, this.customAckFunction);
        }

        @Generated
        public String toString() {
            return "PulsarRecord.PulsarRecordBuilder(topicName=" + this.topicName + ", partition=" + this.partition + ", message=" + String.valueOf(this.message) + ", schema=" + String.valueOf(this.schema) + ", failFunction=" + String.valueOf(this.failFunction) + ", ackFunction=" + String.valueOf(this.ackFunction) + ", customAckFunction=" + String.valueOf(this.customAckFunction) + ")";
        }
    }
}

