/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.protocol;

import org.apache.pulsar.common.api.proto.BaseCommand;
import org.apache.pulsar.common.api.proto.CommandAck;
import org.apache.pulsar.common.api.proto.CommandAckResponse;
import org.apache.pulsar.common.api.proto.CommandActiveConsumerChange;
import org.apache.pulsar.common.api.proto.CommandAddPartitionToTxn;
import org.apache.pulsar.common.api.proto.CommandAddPartitionToTxnResponse;
import org.apache.pulsar.common.api.proto.CommandAddSubscriptionToTxn;
import org.apache.pulsar.common.api.proto.CommandAddSubscriptionToTxnResponse;
import org.apache.pulsar.common.api.proto.CommandAuthChallenge;
import org.apache.pulsar.common.api.proto.CommandAuthResponse;
import org.apache.pulsar.common.api.proto.CommandCloseConsumer;
import org.apache.pulsar.common.api.proto.CommandCloseProducer;
import org.apache.pulsar.common.api.proto.CommandConnect;
import org.apache.pulsar.common.api.proto.CommandConnected;
import org.apache.pulsar.common.api.proto.CommandConsumerStats;
import org.apache.pulsar.common.api.proto.CommandConsumerStatsResponse;
import org.apache.pulsar.common.api.proto.CommandEndTxn;
import org.apache.pulsar.common.api.proto.CommandEndTxnOnPartition;
import org.apache.pulsar.common.api.proto.CommandEndTxnOnPartitionResponse;
import org.apache.pulsar.common.api.proto.CommandEndTxnOnSubscription;
import org.apache.pulsar.common.api.proto.CommandEndTxnOnSubscriptionResponse;
import org.apache.pulsar.common.api.proto.CommandEndTxnResponse;
import org.apache.pulsar.common.api.proto.CommandError;
import org.apache.pulsar.common.api.proto.CommandFlow;
import org.apache.pulsar.common.api.proto.CommandGetLastMessageId;
import org.apache.pulsar.common.api.proto.CommandGetLastMessageIdResponse;
import org.apache.pulsar.common.api.proto.CommandGetOrCreateSchema;
import org.apache.pulsar.common.api.proto.CommandGetOrCreateSchemaResponse;
import org.apache.pulsar.common.api.proto.CommandGetSchema;
import org.apache.pulsar.common.api.proto.CommandGetSchemaResponse;
import org.apache.pulsar.common.api.proto.CommandGetTopicsOfNamespace;
import org.apache.pulsar.common.api.proto.CommandGetTopicsOfNamespaceResponse;
import org.apache.pulsar.common.api.proto.CommandLookupTopic;
import org.apache.pulsar.common.api.proto.CommandLookupTopicResponse;
import org.apache.pulsar.common.api.proto.CommandMessage;
import org.apache.pulsar.common.api.proto.CommandNewTxn;
import org.apache.pulsar.common.api.proto.CommandNewTxnResponse;
import org.apache.pulsar.common.api.proto.CommandPartitionedTopicMetadata;
import org.apache.pulsar.common.api.proto.CommandPartitionedTopicMetadataResponse;
import org.apache.pulsar.common.api.proto.CommandPing;
import org.apache.pulsar.common.api.proto.CommandPong;
import org.apache.pulsar.common.api.proto.CommandProducer;
import org.apache.pulsar.common.api.proto.CommandProducerSuccess;
import org.apache.pulsar.common.api.proto.CommandReachedEndOfTopic;
import org.apache.pulsar.common.api.proto.CommandRedeliverUnacknowledgedMessages;
import org.apache.pulsar.common.api.proto.CommandSeek;
import org.apache.pulsar.common.api.proto.CommandSend;
import org.apache.pulsar.common.api.proto.CommandSendError;
import org.apache.pulsar.common.api.proto.CommandSendReceipt;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.api.proto.CommandSuccess;
import org.apache.pulsar.common.api.proto.CommandTcClientConnectRequest;
import org.apache.pulsar.common.api.proto.CommandTcClientConnectResponse;
import org.apache.pulsar.common.api.proto.CommandTopicMigrated;
import org.apache.pulsar.common.api.proto.CommandUnsubscribe;
import org.apache.pulsar.common.api.proto.CommandWatchTopicList;
import org.apache.pulsar.common.api.proto.CommandWatchTopicListClose;
import org.apache.pulsar.common.api.proto.CommandWatchTopicListSuccess;
import org.apache.pulsar.common.api.proto.CommandWatchTopicUpdate;
import org.apache.pulsar.common.api.proto.ServerError;
import org.apache.pulsar.common.intercept.InterceptException;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.util.netty.NettyChannelUtil;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.pulsar.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.pulsar.shade.io.netty.channel.ChannelOutboundInvoker;
import org.apache.pulsar.shade.io.netty.handler.codec.haproxy.HAProxyMessage;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslCloseCompletionEvent;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PulsarDecoder
extends ChannelInboundHandlerAdapter {
    protected HAProxyMessage proxyMessage;
    private final BaseCommand cmd = new BaseCommand();
    private static final Logger log = LoggerFactory.getLogger(PulsarDecoder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HAProxyMessage) {
            HAProxyMessage proxyMessage;
            this.proxyMessage = proxyMessage = (HAProxyMessage)msg;
            proxyMessage.release();
            return;
        }
        ByteBuf buffer = (ByteBuf)msg;
        try {
            int cmdSize = (int)buffer.readUnsignedInt();
            this.cmd.parseFrom(buffer, cmdSize);
            if (log.isDebugEnabled()) {
                log.debug("[{}] Received cmd {}", (Object)ctx.channel(), (Object)this.cmd.getType());
            }
            this.messageReceived(this.cmd);
            switch (this.cmd.getType()) {
                case PARTITIONED_METADATA: {
                    Preconditions.checkArgument(this.cmd.hasPartitionMetadata());
                    try {
                        this.interceptCommand(this.cmd);
                        this.handlePartitionMetadataRequest(this.cmd.getPartitionMetadata());
                        return;
                    }
                    catch (InterceptException e) {
                        this.writeAndFlush(ctx, Commands.newPartitionMetadataResponse(this.getServerError(e.getErrorCode()), e.getMessage(), this.cmd.getPartitionMetadata().getRequestId()));
                        return;
                    }
                }
                case PARTITIONED_METADATA_RESPONSE: {
                    Preconditions.checkArgument(this.cmd.hasPartitionMetadataResponse());
                    this.handlePartitionResponse(this.cmd.getPartitionMetadataResponse());
                    return;
                }
                case LOOKUP: {
                    Preconditions.checkArgument(this.cmd.hasLookupTopic());
                    this.handleLookup(this.cmd.getLookupTopic());
                    return;
                }
                case LOOKUP_RESPONSE: {
                    Preconditions.checkArgument(this.cmd.hasLookupTopicResponse());
                    this.handleLookupResponse(this.cmd.getLookupTopicResponse());
                    return;
                }
                case ACK: {
                    Preconditions.checkArgument(this.cmd.hasAck());
                    this.safeInterceptCommand(this.cmd);
                    this.handleAck(this.cmd.getAck());
                    return;
                }
                case ACK_RESPONSE: {
                    Preconditions.checkArgument(this.cmd.hasAckResponse());
                    this.handleAckResponse(this.cmd.getAckResponse());
                    return;
                }
                case CLOSE_CONSUMER: {
                    Preconditions.checkArgument(this.cmd.hasCloseConsumer());
                    this.safeInterceptCommand(this.cmd);
                    this.handleCloseConsumer(this.cmd.getCloseConsumer());
                    return;
                }
                case CLOSE_PRODUCER: {
                    Preconditions.checkArgument(this.cmd.hasCloseProducer());
                    this.safeInterceptCommand(this.cmd);
                    this.handleCloseProducer(this.cmd.getCloseProducer());
                    return;
                }
                case CONNECT: {
                    Preconditions.checkArgument(this.cmd.hasConnect());
                    this.handleConnect(this.cmd.getConnect());
                    return;
                }
                case CONNECTED: {
                    Preconditions.checkArgument(this.cmd.hasConnected());
                    this.handleConnected(this.cmd.getConnected());
                    return;
                }
                case ERROR: {
                    Preconditions.checkArgument(this.cmd.hasError());
                    this.handleError(this.cmd.getError());
                    return;
                }
                case FLOW: {
                    Preconditions.checkArgument(this.cmd.hasFlow());
                    this.handleFlow(this.cmd.getFlow());
                    return;
                }
                case MESSAGE: {
                    Preconditions.checkArgument(this.cmd.hasMessage());
                    this.handleMessage(this.cmd.getMessage(), buffer);
                    return;
                }
                case PRODUCER: {
                    Preconditions.checkArgument(this.cmd.hasProducer());
                    try {
                        this.interceptCommand(this.cmd);
                        this.handleProducer(this.cmd.getProducer());
                        return;
                    }
                    catch (InterceptException e) {
                        this.writeAndFlush(ctx, Commands.newError(this.cmd.getProducer().getRequestId(), this.getServerError(e.getErrorCode()), e.getMessage()));
                        return;
                    }
                }
                case SEND: {
                    Preconditions.checkArgument(this.cmd.hasSend());
                    try {
                        this.interceptCommand(this.cmd);
                        ByteBuf headersAndPayload = buffer.markReaderIndex();
                        this.handleSend(this.cmd.getSend(), headersAndPayload);
                        return;
                    }
                    catch (InterceptException e) {
                        this.writeAndFlush(ctx, Commands.newSendError(this.cmd.getSend().getProducerId(), this.cmd.getSend().getSequenceId(), this.getServerError(e.getErrorCode()), e.getMessage()));
                        return;
                    }
                }
                case SEND_ERROR: {
                    Preconditions.checkArgument(this.cmd.hasSendError());
                    this.handleSendError(this.cmd.getSendError());
                    return;
                }
                case SEND_RECEIPT: {
                    Preconditions.checkArgument(this.cmd.hasSendReceipt());
                    this.handleSendReceipt(this.cmd.getSendReceipt());
                    return;
                }
                case SUBSCRIBE: {
                    Preconditions.checkArgument(this.cmd.hasSubscribe());
                    try {
                        this.interceptCommand(this.cmd);
                        this.handleSubscribe(this.cmd.getSubscribe());
                        return;
                    }
                    catch (InterceptException e) {
                        this.writeAndFlush(ctx, Commands.newError(this.cmd.getSubscribe().getRequestId(), this.getServerError(e.getErrorCode()), e.getMessage()));
                        return;
                    }
                }
                case SUCCESS: {
                    Preconditions.checkArgument(this.cmd.hasSuccess());
                    this.handleSuccess(this.cmd.getSuccess());
                    return;
                }
                case PRODUCER_SUCCESS: {
                    Preconditions.checkArgument(this.cmd.hasProducerSuccess());
                    this.handleProducerSuccess(this.cmd.getProducerSuccess());
                    return;
                }
                case UNSUBSCRIBE: {
                    Preconditions.checkArgument(this.cmd.hasUnsubscribe());
                    this.safeInterceptCommand(this.cmd);
                    this.handleUnsubscribe(this.cmd.getUnsubscribe());
                    return;
                }
                case SEEK: {
                    Preconditions.checkArgument(this.cmd.hasSeek());
                    try {
                        this.interceptCommand(this.cmd);
                        this.handleSeek(this.cmd.getSeek());
                        return;
                    }
                    catch (InterceptException e) {
                        this.writeAndFlush(ctx, Commands.newError(this.cmd.getSeek().getRequestId(), this.getServerError(e.getErrorCode()), e.getMessage()));
                        return;
                    }
                }
                case PING: {
                    Preconditions.checkArgument(this.cmd.hasPing());
                    this.handlePing(this.cmd.getPing());
                    return;
                }
                case PONG: {
                    Preconditions.checkArgument(this.cmd.hasPong());
                    this.handlePong(this.cmd.getPong());
                    return;
                }
                case REDELIVER_UNACKNOWLEDGED_MESSAGES: {
                    Preconditions.checkArgument(this.cmd.hasRedeliverUnacknowledgedMessages());
                    this.safeInterceptCommand(this.cmd);
                    this.handleRedeliverUnacknowledged(this.cmd.getRedeliverUnacknowledgedMessages());
                    return;
                }
                case CONSUMER_STATS: {
                    Preconditions.checkArgument(this.cmd.hasConsumerStats());
                    this.handleConsumerStats(this.cmd.getConsumerStats());
                    return;
                }
                case CONSUMER_STATS_RESPONSE: {
                    Preconditions.checkArgument(this.cmd.hasConsumerStatsResponse());
                    this.handleConsumerStatsResponse(this.cmd.getConsumerStatsResponse());
                    return;
                }
                case REACHED_END_OF_TOPIC: {
                    Preconditions.checkArgument(this.cmd.hasReachedEndOfTopic());
                    this.handleReachedEndOfTopic(this.cmd.getReachedEndOfTopic());
                    return;
                }
                case TOPIC_MIGRATED: {
                    Preconditions.checkArgument(this.cmd.hasTopicMigrated());
                    this.handleTopicMigrated(this.cmd.getTopicMigrated());
                    return;
                }
                case GET_LAST_MESSAGE_ID: {
                    Preconditions.checkArgument(this.cmd.hasGetLastMessageId());
                    this.handleGetLastMessageId(this.cmd.getGetLastMessageId());
                    return;
                }
                case GET_LAST_MESSAGE_ID_RESPONSE: {
                    Preconditions.checkArgument(this.cmd.hasGetLastMessageIdResponse());
                    this.handleGetLastMessageIdSuccess(this.cmd.getGetLastMessageIdResponse());
                    return;
                }
                case ACTIVE_CONSUMER_CHANGE: {
                    this.handleActiveConsumerChange(this.cmd.getActiveConsumerChange());
                    return;
                }
                case GET_TOPICS_OF_NAMESPACE: {
                    Preconditions.checkArgument(this.cmd.hasGetTopicsOfNamespace());
                    try {
                        this.interceptCommand(this.cmd);
                        this.handleGetTopicsOfNamespace(this.cmd.getGetTopicsOfNamespace());
                        return;
                    }
                    catch (InterceptException e) {
                        this.writeAndFlush(ctx, Commands.newError(this.cmd.getGetTopicsOfNamespace().getRequestId(), this.getServerError(e.getErrorCode()), e.getMessage()));
                        return;
                    }
                }
                case GET_TOPICS_OF_NAMESPACE_RESPONSE: {
                    Preconditions.checkArgument(this.cmd.hasGetTopicsOfNamespaceResponse());
                    this.handleGetTopicsOfNamespaceSuccess(this.cmd.getGetTopicsOfNamespaceResponse());
                    return;
                }
                case GET_SCHEMA: {
                    Preconditions.checkArgument(this.cmd.hasGetSchema());
                    try {
                        this.interceptCommand(this.cmd);
                        this.handleGetSchema(this.cmd.getGetSchema());
                        return;
                    }
                    catch (InterceptException e) {
                        this.writeAndFlush(ctx, Commands.newGetSchemaResponseError(this.cmd.getGetSchema().getRequestId(), this.getServerError(e.getErrorCode()), e.getMessage()));
                        return;
                    }
                }
                case GET_SCHEMA_RESPONSE: {
                    Preconditions.checkArgument(this.cmd.hasGetSchemaResponse());
                    this.handleGetSchemaResponse(this.cmd.getGetSchemaResponse());
                    return;
                }
                case GET_OR_CREATE_SCHEMA: {
                    Preconditions.checkArgument(this.cmd.hasGetOrCreateSchema());
                    try {
                        this.interceptCommand(this.cmd);
                        this.handleGetOrCreateSchema(this.cmd.getGetOrCreateSchema());
                        return;
                    }
                    catch (InterceptException e) {
                        this.writeAndFlush(ctx, Commands.newGetOrCreateSchemaResponseError(this.cmd.getGetOrCreateSchema().getRequestId(), this.getServerError(e.getErrorCode()), e.getMessage()));
                        return;
                    }
                }
                case GET_OR_CREATE_SCHEMA_RESPONSE: {
                    Preconditions.checkArgument(this.cmd.hasGetOrCreateSchemaResponse());
                    this.handleGetOrCreateSchemaResponse(this.cmd.getGetOrCreateSchemaResponse());
                    return;
                }
                case AUTH_CHALLENGE: {
                    Preconditions.checkArgument(this.cmd.hasAuthChallenge());
                    this.handleAuthChallenge(this.cmd.getAuthChallenge());
                    return;
                }
                case AUTH_RESPONSE: {
                    Preconditions.checkArgument(this.cmd.hasAuthResponse());
                    this.handleAuthResponse(this.cmd.getAuthResponse());
                    return;
                }
                case TC_CLIENT_CONNECT_REQUEST: {
                    Preconditions.checkArgument(this.cmd.hasTcClientConnectRequest());
                    this.handleTcClientConnectRequest(this.cmd.getTcClientConnectRequest());
                    return;
                }
                case TC_CLIENT_CONNECT_RESPONSE: {
                    Preconditions.checkArgument(this.cmd.hasTcClientConnectResponse());
                    this.handleTcClientConnectResponse(this.cmd.getTcClientConnectResponse());
                    return;
                }
                case NEW_TXN: {
                    Preconditions.checkArgument(this.cmd.hasNewTxn());
                    this.handleNewTxn(this.cmd.getNewTxn());
                    return;
                }
                case NEW_TXN_RESPONSE: {
                    Preconditions.checkArgument(this.cmd.hasNewTxnResponse());
                    this.handleNewTxnResponse(this.cmd.getNewTxnResponse());
                    return;
                }
                case ADD_PARTITION_TO_TXN: {
                    Preconditions.checkArgument(this.cmd.hasAddPartitionToTxn());
                    this.handleAddPartitionToTxn(this.cmd.getAddPartitionToTxn());
                    return;
                }
                case ADD_PARTITION_TO_TXN_RESPONSE: {
                    Preconditions.checkArgument(this.cmd.hasAddPartitionToTxnResponse());
                    this.handleAddPartitionToTxnResponse(this.cmd.getAddPartitionToTxnResponse());
                    return;
                }
                case ADD_SUBSCRIPTION_TO_TXN: {
                    Preconditions.checkArgument(this.cmd.hasAddSubscriptionToTxn());
                    this.handleAddSubscriptionToTxn(this.cmd.getAddSubscriptionToTxn());
                    return;
                }
                case ADD_SUBSCRIPTION_TO_TXN_RESPONSE: {
                    Preconditions.checkArgument(this.cmd.hasAddSubscriptionToTxnResponse());
                    this.handleAddSubscriptionToTxnResponse(this.cmd.getAddSubscriptionToTxnResponse());
                    return;
                }
                case END_TXN: {
                    Preconditions.checkArgument(this.cmd.hasEndTxn());
                    this.handleEndTxn(this.cmd.getEndTxn());
                    return;
                }
                case END_TXN_RESPONSE: {
                    Preconditions.checkArgument(this.cmd.hasEndTxnResponse());
                    this.handleEndTxnResponse(this.cmd.getEndTxnResponse());
                    return;
                }
                case END_TXN_ON_PARTITION: {
                    Preconditions.checkArgument(this.cmd.hasEndTxnOnPartition());
                    this.handleEndTxnOnPartition(this.cmd.getEndTxnOnPartition());
                    return;
                }
                case END_TXN_ON_PARTITION_RESPONSE: {
                    Preconditions.checkArgument(this.cmd.hasEndTxnOnPartitionResponse());
                    this.handleEndTxnOnPartitionResponse(this.cmd.getEndTxnOnPartitionResponse());
                    return;
                }
                case END_TXN_ON_SUBSCRIPTION: {
                    Preconditions.checkArgument(this.cmd.hasEndTxnOnSubscription());
                    this.handleEndTxnOnSubscription(this.cmd.getEndTxnOnSubscription());
                    return;
                }
                case END_TXN_ON_SUBSCRIPTION_RESPONSE: {
                    Preconditions.checkArgument(this.cmd.hasEndTxnOnSubscriptionResponse());
                    this.handleEndTxnOnSubscriptionResponse(this.cmd.getEndTxnOnSubscriptionResponse());
                    return;
                }
                case WATCH_TOPIC_LIST: {
                    Preconditions.checkArgument(this.cmd.hasWatchTopicList());
                    this.handleCommandWatchTopicList(this.cmd.getWatchTopicList());
                    return;
                }
                case WATCH_TOPIC_LIST_SUCCESS: {
                    Preconditions.checkArgument(this.cmd.hasWatchTopicListSuccess());
                    this.handleCommandWatchTopicListSuccess(this.cmd.getWatchTopicListSuccess());
                    return;
                }
                case WATCH_TOPIC_UPDATE: {
                    Preconditions.checkArgument(this.cmd.hasWatchTopicUpdate());
                    this.handleCommandWatchTopicUpdate(this.cmd.getWatchTopicUpdate());
                    return;
                }
                case WATCH_TOPIC_LIST_CLOSE: {
                    Preconditions.checkArgument(this.cmd.hasWatchTopicListClose());
                    this.handleCommandWatchTopicListClose(this.cmd.getWatchTopicListClose());
                    return;
                }
            }
            return;
        }
        finally {
            buffer.release();
            this.cmd.clear();
        }
    }

    protected abstract void messageReceived(BaseCommand var1);

    private ServerError getServerError(int errorCode) {
        ServerError serverError = ServerError.valueOf(errorCode);
        return serverError == null ? ServerError.UnknownError : serverError;
    }

    private void safeInterceptCommand(BaseCommand command) {
        try {
            this.interceptCommand(command);
        }
        catch (InterceptException interceptException) {
            // empty catch block
        }
    }

    protected void interceptCommand(BaseCommand command) throws InterceptException {
    }

    protected void handlePartitionMetadataRequest(CommandPartitionedTopicMetadata response) {
        throw new UnsupportedOperationException();
    }

    protected void handlePartitionResponse(CommandPartitionedTopicMetadataResponse response) {
        throw new UnsupportedOperationException();
    }

    protected void handleLookup(CommandLookupTopic lookup) {
        throw new UnsupportedOperationException();
    }

    protected void handleLookupResponse(CommandLookupTopicResponse connection) {
        throw new UnsupportedOperationException();
    }

    protected void handleConnect(CommandConnect connect) {
        throw new UnsupportedOperationException();
    }

    protected void handleConnected(CommandConnected connected) {
        throw new UnsupportedOperationException();
    }

    protected void handleSubscribe(CommandSubscribe subscribe) {
        throw new UnsupportedOperationException();
    }

    protected void handleProducer(CommandProducer producer) {
        throw new UnsupportedOperationException();
    }

    protected void handleSend(CommandSend send, ByteBuf headersAndPayload) {
        throw new UnsupportedOperationException();
    }

    protected void handleSendReceipt(CommandSendReceipt sendReceipt) {
        throw new UnsupportedOperationException();
    }

    protected void handleSendError(CommandSendError sendError) {
        throw new UnsupportedOperationException();
    }

    protected void handleMessage(CommandMessage cmdMessage, ByteBuf headersAndPayload) {
        throw new UnsupportedOperationException();
    }

    protected void handleAck(CommandAck ack) {
        throw new UnsupportedOperationException();
    }

    protected void handleAckResponse(CommandAckResponse ackResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleFlow(CommandFlow flow) {
        throw new UnsupportedOperationException();
    }

    protected void handleRedeliverUnacknowledged(CommandRedeliverUnacknowledgedMessages redeliver) {
        throw new UnsupportedOperationException();
    }

    protected void handleUnsubscribe(CommandUnsubscribe unsubscribe) {
        throw new UnsupportedOperationException();
    }

    protected void handleSeek(CommandSeek seek) {
        throw new UnsupportedOperationException();
    }

    protected void handleActiveConsumerChange(CommandActiveConsumerChange change) {
        throw new UnsupportedOperationException();
    }

    protected void handleSuccess(CommandSuccess success) {
        throw new UnsupportedOperationException();
    }

    protected void handleProducerSuccess(CommandProducerSuccess success) {
        throw new UnsupportedOperationException();
    }

    protected void handleError(CommandError error) {
        throw new UnsupportedOperationException();
    }

    protected void handleCloseProducer(CommandCloseProducer closeProducer) {
        throw new UnsupportedOperationException();
    }

    protected void handleCloseConsumer(CommandCloseConsumer closeConsumer) {
        throw new UnsupportedOperationException();
    }

    protected void handlePing(CommandPing ping) {
        throw new UnsupportedOperationException();
    }

    protected void handlePong(CommandPong pong) {
        throw new UnsupportedOperationException();
    }

    protected void handleConsumerStats(CommandConsumerStats commandConsumerStats) {
        throw new UnsupportedOperationException();
    }

    protected void handleConsumerStatsResponse(CommandConsumerStatsResponse commandConsumerStatsResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleReachedEndOfTopic(CommandReachedEndOfTopic commandReachedEndOfTopic) {
        throw new UnsupportedOperationException();
    }

    protected void handleTopicMigrated(CommandTopicMigrated commandMigratedTopic) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetLastMessageId(CommandGetLastMessageId getLastMessageId) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetLastMessageIdSuccess(CommandGetLastMessageIdResponse success) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetTopicsOfNamespace(CommandGetTopicsOfNamespace commandGetTopicsOfNamespace) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetTopicsOfNamespaceSuccess(CommandGetTopicsOfNamespaceResponse response) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetSchema(CommandGetSchema commandGetSchema) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetSchemaResponse(CommandGetSchemaResponse commandGetSchemaResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetOrCreateSchema(CommandGetOrCreateSchema commandGetOrCreateSchema) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetOrCreateSchemaResponse(CommandGetOrCreateSchemaResponse commandGetOrCreateSchemaResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleAuthResponse(CommandAuthResponse commandAuthResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleAuthChallenge(CommandAuthChallenge commandAuthChallenge) {
        throw new UnsupportedOperationException();
    }

    protected void handleTcClientConnectRequest(CommandTcClientConnectRequest tcClientConnectRequest) {
        throw new UnsupportedOperationException();
    }

    protected void handleTcClientConnectResponse(CommandTcClientConnectResponse tcClientConnectResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleNewTxn(CommandNewTxn commandNewTxn) {
        throw new UnsupportedOperationException();
    }

    protected void handleNewTxnResponse(CommandNewTxnResponse commandNewTxnResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleAddPartitionToTxn(CommandAddPartitionToTxn commandAddPartitionToTxn) {
        throw new UnsupportedOperationException();
    }

    protected void handleAddPartitionToTxnResponse(CommandAddPartitionToTxnResponse commandAddPartitionToTxnResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleAddSubscriptionToTxn(CommandAddSubscriptionToTxn commandAddSubscriptionToTxn) {
        throw new UnsupportedOperationException();
    }

    protected void handleAddSubscriptionToTxnResponse(CommandAddSubscriptionToTxnResponse commandAddSubscriptionToTxnResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleEndTxn(CommandEndTxn commandEndTxn) {
        throw new UnsupportedOperationException();
    }

    protected void handleEndTxnResponse(CommandEndTxnResponse commandEndTxnResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleEndTxnOnPartition(CommandEndTxnOnPartition commandEndTxnOnPartition) {
        throw new UnsupportedOperationException();
    }

    protected void handleEndTxnOnPartitionResponse(CommandEndTxnOnPartitionResponse commandEndTxnOnPartitionResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleEndTxnOnSubscription(CommandEndTxnOnSubscription commandEndTxnOnSubscription) {
        throw new UnsupportedOperationException();
    }

    protected void handleEndTxnOnSubscriptionResponse(CommandEndTxnOnSubscriptionResponse commandEndTxnOnSubscriptionResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleCommandWatchTopicList(CommandWatchTopicList commandWatchTopicList) {
        throw new UnsupportedOperationException();
    }

    protected void handleCommandWatchTopicListSuccess(CommandWatchTopicListSuccess commandWatchTopicListSuccess) {
        throw new UnsupportedOperationException();
    }

    protected void handleCommandWatchTopicUpdate(CommandWatchTopicUpdate commandWatchTopicUpdate) {
        throw new UnsupportedOperationException();
    }

    protected void handleCommandWatchTopicListClose(CommandWatchTopicListClose commandWatchTopicListClose) {
        throw new UnsupportedOperationException();
    }

    private void writeAndFlush(ChannelOutboundInvoker ctx, ByteBuf cmd) {
        NettyChannelUtil.writeAndFlushWithVoidPromise(ctx, cmd);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        SslCloseCompletionEvent sslCloseCompletionEvent;
        if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent sslHandshakeCompletionEvent = (SslHandshakeCompletionEvent)evt;
            if (!sslHandshakeCompletionEvent.isSuccess()) {
                log.warn("[{}] TLS handshake failed. {}", (Object)ctx.channel(), (Object)sslHandshakeCompletionEvent);
            }
        } else if (evt instanceof SslCloseCompletionEvent && (sslCloseCompletionEvent = (SslCloseCompletionEvent)evt).isSuccess() && ctx.channel().isActive()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Received a TLS close_notify, closing the channel.", (Object)ctx.channel());
            }
            ctx.close();
        }
        ctx.fireUserEventTriggered(evt);
    }
}

