/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.util.Optional;
import lombok.Generated;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.KeyValueSchema;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class AutoProduceBytesSchema<T>
implements Schema<byte[]> {
    private volatile boolean requireSchemaValidation = true;
    private volatile Schema<T> schema;
    private final boolean userProvidedSchema;

    public AutoProduceBytesSchema() {
        this.userProvidedSchema = false;
    }

    public AutoProduceBytesSchema(Schema<T> schema) {
        this.schema = schema;
        this.userProvidedSchema = true;
        SchemaInfo schemaInfo = schema.getSchemaInfo();
        this.requireSchemaValidation = schemaInfo != null && schemaInfo.getType() != SchemaType.BYTES && schemaInfo.getType() != SchemaType.NONE;
    }

    private AutoProduceBytesSchema(AutoProduceBytesSchema<T> other) {
        this.schema = other.schema != null ? other.schema.clone() : null;
        this.userProvidedSchema = other.userProvidedSchema;
        this.requireSchemaValidation = other.requireSchemaValidation;
    }

    public void setSchema(Schema<T> schema) {
        this.schema = schema;
        this.requireSchemaValidation = schema.getSchemaInfo() != null && SchemaType.BYTES != schema.getSchemaInfo().getType() && SchemaType.NONE != schema.getSchemaInfo().getType();
    }

    private void ensureSchemaInitialized() {
        Preconditions.checkState(this.schemaInitialized(), "Schema is not initialized before used");
    }

    public boolean schemaInitialized() {
        return this.schema != null;
    }

    public boolean hasUserProvidedSchema() {
        return this.userProvidedSchema;
    }

    public void validate(byte[] message) {
        this.ensureSchemaInitialized();
        this.schema.validate(message);
    }

    public byte[] encode(byte[] message) {
        this.ensureSchemaInitialized();
        if (this.requireSchemaValidation) {
            Schema<T> localSchema = this.schema;
            if (localSchema instanceof KeyValueSchema && ((KeyValueSchema)localSchema).getKeyValueEncodingType().equals((Object)KeyValueEncodingType.SEPARATED)) {
                ((KeyValueSchema)localSchema).getValueSchema().validate(message);
            } else {
                localSchema.validate(message);
            }
        }
        return message;
    }

    public byte[] decode(byte[] bytes, byte[] schemaVersion) {
        this.ensureSchemaInitialized();
        if (this.requireSchemaValidation) {
            this.schema.decode(bytes, schemaVersion);
        }
        return bytes;
    }

    public SchemaInfo getSchemaInfo() {
        this.ensureSchemaInitialized();
        return this.schema.getSchemaInfo();
    }

    public Optional<Object> getNativeSchema() {
        return Optional.ofNullable(this.schema).map(s -> s.getNativeSchema()).orElse(Optional.empty());
    }

    public Schema<byte[]> clone() {
        return new AutoProduceBytesSchema<T>(this);
    }

    @Generated
    public void setRequireSchemaValidation(boolean requireSchemaValidation) {
        this.requireSchemaValidation = requireSchemaValidation;
    }
}

