/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.netty.handler.ssl;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.pulsar.shade.io.netty.util.internal.SuppressJava6Requirement;

@SuppressJava6Requirement(reason="Usage guarded by java version check")
final class EnhancingX509ExtendedTrustManager
extends X509ExtendedTrustManager {
    static final int ALTNAME_DNS = 2;
    static final int ALTNAME_URI = 6;
    static final int ALTNAME_IP = 7;
    private static final String SEPARATOR = ", ";
    private final X509ExtendedTrustManager wrapped;

    EnhancingX509ExtendedTrustManager(X509TrustManager wrapped) {
        this.wrapped = (X509ExtendedTrustManager)wrapped;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.wrapped.checkClientTrusted(chain, authType, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        try {
            this.wrapped.checkServerTrusted(chain, authType, socket);
        }
        catch (CertificateException e) {
            EnhancingX509ExtendedTrustManager.throwEnhancedCertificateException(e, chain, socket instanceof SSLSocket ? ((SSLSocket)socket).getHandshakeSession() : null);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.wrapped.checkClientTrusted(chain, authType, engine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        try {
            this.wrapped.checkServerTrusted(chain, authType, engine);
        }
        catch (CertificateException e) {
            EnhancingX509ExtendedTrustManager.throwEnhancedCertificateException(e, chain, engine != null ? engine.getHandshakeSession() : null);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.wrapped.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.wrapped.checkServerTrusted(chain, authType);
        }
        catch (CertificateException e) {
            EnhancingX509ExtendedTrustManager.throwEnhancedCertificateException(e, chain, null);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.wrapped.getAcceptedIssuers();
    }

    private static void throwEnhancedCertificateException(CertificateException e, X509Certificate[] chain, SSLSession session) throws CertificateException {
        String message = e.getMessage();
        if (message != null && (message.startsWith("No subject alternative") || message.startsWith("No name matching"))) {
            StringBuilder sb = new StringBuilder(128);
            sb.append(message);
            if (message.charAt(message.length() - 1) == '.') {
                sb.setLength(sb.length() - 1);
            }
            if (session != null) {
                sb.append(" for SNIHostName=").append(EnhancingX509ExtendedTrustManager.getSNIHostName(session)).append(" and peerHost=").append(session.getPeerHost());
            }
            sb.append(" in the chain of ").append(chain.length).append(" certificate(s):");
            for (int i = 0; i < chain.length; ++i) {
                X509Certificate cert = chain[i];
                Collection<List<?>> collection = cert.getSubjectAlternativeNames();
                sb.append(' ').append(i + 1).append(". subjectAlternativeNames=[");
                if (collection != null) {
                    boolean hasNames = false;
                    for (List<?> altNames : collection) {
                        if (altNames.size() < 2) continue;
                        int nameType = (Integer)altNames.get(0);
                        if (nameType == 2) {
                            sb.append("DNS");
                        } else if (nameType == 7) {
                            sb.append("IP");
                        } else {
                            if (nameType != 6) continue;
                            sb.append("URI");
                        }
                        sb.append(':').append((String)altNames.get(1)).append(SEPARATOR);
                        hasNames = true;
                    }
                    if (hasNames) {
                        sb.setLength(sb.length() - SEPARATOR.length());
                    }
                }
                sb.append("], CN=").append(EnhancingX509ExtendedTrustManager.getCommonName(cert)).append('.');
            }
            throw new CertificateException(sb.toString(), e);
        }
        throw e;
    }

    private static String getSNIHostName(SSLSession session) {
        if (!(session instanceof ExtendedSSLSession)) {
            return null;
        }
        List<SNIServerName> names = ((ExtendedSSLSession)session).getRequestedServerNames();
        for (SNIServerName sni : names) {
            if (!(sni instanceof SNIHostName)) continue;
            SNIHostName hostName = (SNIHostName)sni;
            return hostName.getAsciiName();
        }
        return null;
    }

    private static String getCommonName(X509Certificate cert) {
        try {
            X500Principal principal = cert.getSubjectX500Principal();
            LdapName ldapName = new LdapName(principal.getName());
            for (Rdn rdn : ldapName.getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                return rdn.getValue().toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "null";
    }
}

