/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.netty.handler.codec.dns;

import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.handler.codec.CorruptedFrameException;
import org.apache.pulsar.shade.io.netty.handler.codec.dns.DefaultDnsPtrRecord;
import org.apache.pulsar.shade.io.netty.handler.codec.dns.DefaultDnsQuestion;
import org.apache.pulsar.shade.io.netty.handler.codec.dns.DefaultDnsRawRecord;
import org.apache.pulsar.shade.io.netty.handler.codec.dns.DnsCodecUtil;
import org.apache.pulsar.shade.io.netty.handler.codec.dns.DnsQuestion;
import org.apache.pulsar.shade.io.netty.handler.codec.dns.DnsRecord;
import org.apache.pulsar.shade.io.netty.handler.codec.dns.DnsRecordDecoder;
import org.apache.pulsar.shade.io.netty.handler.codec.dns.DnsRecordType;
import org.apache.pulsar.shade.io.netty.util.ReferenceCounted;

public class DefaultDnsRecordDecoder
implements DnsRecordDecoder {
    static final String ROOT = ".";

    protected DefaultDnsRecordDecoder() {
    }

    @Override
    public final DnsQuestion decodeQuestion(ByteBuf in) throws Exception {
        String name = DefaultDnsRecordDecoder.decodeName(in);
        DnsRecordType type = DnsRecordType.valueOf(in.readUnsignedShort());
        int qClass = in.readUnsignedShort();
        return new DefaultDnsQuestion(name, type, qClass);
    }

    @Override
    public final <T extends DnsRecord> T decodeRecord(ByteBuf in) throws Exception {
        int startOffset = in.readerIndex();
        String name = DefaultDnsRecordDecoder.decodeName(in);
        int endOffset = in.writerIndex();
        if (endOffset - in.readerIndex() < 10) {
            in.readerIndex(startOffset);
            return null;
        }
        DnsRecordType type = DnsRecordType.valueOf(in.readUnsignedShort());
        int aClass = in.readUnsignedShort();
        long ttl = in.readUnsignedInt();
        int length = in.readUnsignedShort();
        int offset = in.readerIndex();
        if (endOffset - offset < length) {
            in.readerIndex(startOffset);
            return null;
        }
        DnsRecord record = this.decodeRecord(name, type, aClass, ttl, in, offset, length);
        in.readerIndex(offset + length);
        return (T)record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DnsRecord decodeRecord(String name, DnsRecordType type, int dnsClass, long timeToLive, ByteBuf in, int offset, int length) throws Exception {
        if (type == DnsRecordType.PTR) {
            return new DefaultDnsPtrRecord(name, dnsClass, timeToLive, this.decodeName0(in.duplicate().setIndex(offset, offset + length)));
        }
        if (type == DnsRecordType.CNAME || type == DnsRecordType.NS) {
            return new DefaultDnsRawRecord(name, type, dnsClass, timeToLive, DnsCodecUtil.decompressDomainName(in.duplicate().setIndex(offset, offset + length)));
        }
        if (type == DnsRecordType.MX) {
            if (length < 3) {
                throw new CorruptedFrameException("MX record RDATA is too short: " + length);
            }
            int pref = in.getUnsignedShort(offset);
            ReferenceCounted exchange = null;
            try {
                exchange = DnsCodecUtil.decompressDomainName(in.duplicate().setIndex(offset + 2, offset + length));
                ByteBuf out = in.alloc().buffer(2 + ((ByteBuf)exchange).readableBytes());
                out.writeShort(pref);
                out.writeBytes((ByteBuf)exchange);
                DefaultDnsRawRecord defaultDnsRawRecord = new DefaultDnsRawRecord(name, type, dnsClass, timeToLive, out);
                return defaultDnsRawRecord;
            }
            finally {
                if (exchange != null) {
                    exchange.release();
                }
            }
        }
        return new DefaultDnsRawRecord(name, type, dnsClass, timeToLive, in.retainedDuplicate().setIndex(offset, offset + length));
    }

    protected String decodeName0(ByteBuf in) {
        return DefaultDnsRecordDecoder.decodeName(in);
    }

    public static String decodeName(ByteBuf in) {
        return DnsCodecUtil.decodeDomainName(in);
    }
}

