/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.google.re2j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.pulsar.shade.com.google.re2j.Matcher;
import org.apache.pulsar.shade.com.google.re2j.MatcherInput;
import org.apache.pulsar.shade.com.google.re2j.RE2;

public final class Pattern
implements Serializable {
    public static final int CASE_INSENSITIVE = 1;
    public static final int DOTALL = 2;
    public static final int MULTILINE = 4;
    public static final int DISABLE_UNICODE_GROUPS = 8;
    public static final int LONGEST_MATCH = 16;
    private final String pattern;
    private final int flags;
    private final transient RE2 re2;
    private static final long serialVersionUID = 0L;

    Pattern(String pattern, int flags, RE2 re2) {
        if (pattern == null) {
            throw new NullPointerException("pattern is null");
        }
        if (re2 == null) {
            throw new NullPointerException("re2 is null");
        }
        this.pattern = pattern;
        this.flags = flags;
        this.re2 = re2;
    }

    public void reset() {
        this.re2.reset();
    }

    public int flags() {
        return this.flags;
    }

    public String pattern() {
        return this.pattern;
    }

    RE2 re2() {
        return this.re2;
    }

    public static Pattern compile(String regex) {
        return Pattern.compile(regex, regex, 0);
    }

    public static Pattern compile(String regex, int flags) {
        String flregex = regex;
        if ((flags & 1) != 0) {
            flregex = "(?i)" + flregex;
        }
        if ((flags & 2) != 0) {
            flregex = "(?s)" + flregex;
        }
        if ((flags & 4) != 0) {
            flregex = "(?m)" + flregex;
        }
        if ((flags & 0xFFFFFFE0) != 0) {
            throw new IllegalArgumentException("Flags should only be a combination of MULTILINE, DOTALL, CASE_INSENSITIVE, DISABLE_UNICODE_GROUPS, LONGEST_MATCH");
        }
        return Pattern.compile(flregex, regex, flags);
    }

    private static Pattern compile(String flregex, String regex, int flags) {
        int re2Flags = 212;
        if ((flags & 8) != 0) {
            re2Flags &= 0xFFFFFF7F;
        }
        return new Pattern(regex, flags, RE2.compileImpl(flregex, re2Flags, (flags & 0x10) != 0));
    }

    public static boolean matches(String regex, CharSequence input) {
        return Pattern.compile(regex).matcher(input).matches();
    }

    public static boolean matches(String regex, byte[] input) {
        return Pattern.compile(regex).matcher(input).matches();
    }

    public boolean matches(String input) {
        return this.matcher(input).matches();
    }

    public boolean matches(byte[] input) {
        return this.matcher(input).matches();
    }

    public Matcher matcher(CharSequence input) {
        return new Matcher(this, input);
    }

    public Matcher matcher(byte[] input) {
        return new Matcher(this, MatcherInput.utf8(input));
    }

    Matcher matcher(MatcherInput input) {
        return new Matcher(this, input);
    }

    public String[] split(String input) {
        return this.split(input, 0);
    }

    public String[] split(String input, int limit) {
        return this.split(new Matcher(this, input), limit);
    }

    private String[] split(Matcher m4, int limit) {
        ArrayList<String> result = new ArrayList<String>();
        int emptiesSkipped = 0;
        int last = 0;
        while (m4.find()) {
            if (last == 0 && m4.end() == 0) {
                last = m4.end();
                continue;
            }
            if (limit > 0 && result.size() == limit - 1) break;
            if (last == m4.start()) {
                if (limit == 0) {
                    ++emptiesSkipped;
                    last = m4.end();
                    continue;
                }
            } else {
                while (emptiesSkipped > 0) {
                    result.add("");
                    --emptiesSkipped;
                }
            }
            result.add(m4.substring(last, m4.start()));
            last = m4.end();
        }
        if (limit == 0 && last != m4.inputLength()) {
            while (emptiesSkipped > 0) {
                result.add("");
                --emptiesSkipped;
            }
            result.add(m4.substring(last, m4.inputLength()));
        }
        if (limit != 0 || result.isEmpty()) {
            result.add(m4.substring(last, m4.inputLength()));
        }
        return result.toArray(new String[0]);
    }

    public static String quote(String s2) {
        return RE2.quoteMeta(s2);
    }

    public String toString() {
        return this.pattern;
    }

    public int programSize() {
        return this.re2.numberOfInstructions();
    }

    public int groupCount() {
        return this.re2.numberOfCapturingGroups();
    }

    public Map<String, Integer> namedGroups() {
        return Collections.unmodifiableMap(this.re2.namedGroups);
    }

    Object readResolve() {
        return Pattern.compile(this.pattern, this.flags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pattern other = (Pattern)o;
        return this.flags == other.flags && this.pattern.equals(other.pattern);
    }

    public int hashCode() {
        int result = this.pattern.hashCode();
        result = 31 * result + this.flags;
        return result;
    }
}

