/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo;
import org.apache.pulsar.client.impl.schema.SchemaUtils;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;
import org.apache.pulsar.common.protocol.schema.SchemaHash;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SchemaInfoImpl
implements SchemaInfo {
    private String name;
    private byte[] schema;
    private SchemaType type;
    private long timestamp;
    private Map<String, String> properties = Collections.emptyMap();
    @JsonIgnore
    private transient SchemaHash schemaHash;

    public SchemaInfoImpl(String name, byte[] schema, SchemaType type, long timestamp, Map<String, String> properties) {
        this.name = name;
        this.schema = schema;
        this.type = type;
        this.timestamp = timestamp;
        this.properties = properties == null ? Collections.emptyMap() : properties;
        this.schemaHash = SchemaHash.of(this.schema, this.type);
    }

    public String getSchemaDefinition() {
        if (null == this.schema) {
            return "";
        }
        switch (this.type) {
            case AVRO: 
            case JSON: 
            case PROTOBUF: 
            case PROTOBUF_NATIVE: {
                return new String(this.schema, StandardCharsets.UTF_8);
            }
            case KEY_VALUE: {
                KeyValue<SchemaInfo, SchemaInfo> schemaInfoKeyValue = KeyValueSchemaInfo.decodeKeyValueSchemaInfo(this);
                return SchemaUtils.jsonifyKeyValueSchemaInfo(schemaInfoKeyValue);
            }
        }
        return Base64.getEncoder().encodeToString(this.schema);
    }

    public SchemaHash getSchemaHash() {
        if (this.schemaHash == null) {
            this.schemaHash = SchemaHash.of(this.schema, this.type);
        }
        return this.schemaHash;
    }

    public String toString() {
        return SchemaUtils.jsonifySchemaInfo(this);
    }

    @Generated
    public static SchemaInfoImplBuilder builder() {
        return new SchemaInfoImplBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public byte[] getSchema() {
        return this.schema;
    }

    @Generated
    public SchemaType getType() {
        return this.type;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Generated
    public SchemaInfoImpl setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public SchemaInfoImpl setSchema(byte[] schema) {
        this.schema = schema;
        return this;
    }

    @Generated
    public SchemaInfoImpl setType(SchemaType type) {
        this.type = type;
        return this;
    }

    @Generated
    public SchemaInfoImpl setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Generated
    public SchemaInfoImpl setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    @JsonIgnore
    @Generated
    public SchemaInfoImpl setSchemaHash(SchemaHash schemaHash) {
        this.schemaHash = schemaHash;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaInfoImpl)) {
            return false;
        }
        SchemaInfoImpl other = (SchemaInfoImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (!Arrays.equals(this.getSchema(), other.getSchema())) {
            return false;
        }
        SchemaType this$type = this.getType();
        SchemaType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SchemaInfoImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        result = result * 59 + Arrays.hashCode(this.getSchema());
        SchemaType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    @Generated
    public SchemaInfoImpl() {
    }

    @Generated
    public static class SchemaInfoImplBuilder {
        @Generated
        private String name;
        @Generated
        private byte[] schema;
        @Generated
        private SchemaType type;
        @Generated
        private long timestamp;
        @Generated
        private Map<String, String> properties;

        @Generated
        SchemaInfoImplBuilder() {
        }

        @Generated
        public SchemaInfoImplBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public SchemaInfoImplBuilder schema(byte[] schema) {
            this.schema = schema;
            return this;
        }

        @Generated
        public SchemaInfoImplBuilder type(SchemaType type) {
            this.type = type;
            return this;
        }

        @Generated
        public SchemaInfoImplBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public SchemaInfoImplBuilder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @Generated
        public SchemaInfoImpl build() {
            return new SchemaInfoImpl(this.name, this.schema, this.type, this.timestamp, this.properties);
        }

        @Generated
        public String toString() {
            return "SchemaInfoImpl.SchemaInfoImplBuilder(name=" + this.name + ", schema=" + Arrays.toString(this.schema) + ", type=" + this.type + ", timestamp=" + this.timestamp + ", properties=" + this.properties + ")";
        }
    }
}

