/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.GenericSchema;
import org.apache.pulsar.client.impl.schema.AvroBaseStructSchema;
import org.apache.pulsar.client.impl.schema.generic.GenericAvroSchema;
import org.apache.pulsar.client.impl.schema.generic.GenericJsonSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.org.apache.avro.AvroRuntimeException;

public abstract class GenericSchemaImpl
extends AvroBaseStructSchema<GenericRecord>
implements GenericSchema<GenericRecord> {
    protected final List<Field> fields;

    protected GenericSchemaImpl(SchemaInfo schemaInfo) {
        super(schemaInfo);
        try {
            this.fields = this.schema.getFields().stream().map(f -> new Field(f.name(), f.pos())).collect(Collectors.toList());
        }
        catch (AvroRuntimeException avroRuntimeException) {
            throw new AvroRuntimeException("Schema typed [" + this.schema.getClass().getName() + "], simple-type:[" + (Object)((Object)this.schema.getType()) + "] is not supported. schema-content: " + this.schema);
        }
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public static GenericSchemaImpl of(SchemaInfo schemaInfo) {
        return GenericSchemaImpl.of(schemaInfo, true);
    }

    public static GenericSchemaImpl of(SchemaInfo schemaInfo, boolean useProvidedSchemaAsReaderSchema) {
        switch (schemaInfo.getType()) {
            case AVRO: {
                return new GenericAvroSchema(schemaInfo, useProvidedSchemaAsReaderSchema);
            }
            case JSON: {
                return new GenericJsonSchema(schemaInfo, useProvidedSchemaAsReaderSchema);
            }
        }
        throw new UnsupportedOperationException("Generic schema is not supported on schema type " + schemaInfo.getType() + "'");
    }
}

