/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.common.util.FileModifiedTimeUpdater;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.common.util.SslContextAutoRefreshBuilder;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClientSslContextRefresher
extends SslContextAutoRefreshBuilder<SslContext> {
    private static final Logger log = LoggerFactory.getLogger(NettyClientSslContextRefresher.class);
    private volatile SslContext sslNettyContext;
    private boolean tlsAllowInsecureConnection;
    protected final FileModifiedTimeUpdater tlsTrustCertsFilePath;
    private AuthenticationDataProvider authData;

    public NettyClientSslContextRefresher(boolean allowInsecure, String trustCertsFilePath, AuthenticationDataProvider authData, long delayInSeconds) {
        super(delayInSeconds);
        this.tlsAllowInsecureConnection = allowInsecure;
        this.tlsTrustCertsFilePath = new FileModifiedTimeUpdater(trustCertsFilePath);
        this.authData = authData;
    }

    @Override
    public synchronized SslContext update() throws SSLException, FileNotFoundException, GeneralSecurityException, IOException {
        this.sslNettyContext = this.authData != null && this.authData.hasDataForTls() ? (this.authData.getTlsTrustStoreStream() == null ? SecurityUtility.createNettySslContextForClient(this.tlsAllowInsecureConnection, this.tlsTrustCertsFilePath.getFileName(), (Certificate[])((X509Certificate[])this.authData.getTlsCertificates()), this.authData.getTlsPrivateKey()) : SecurityUtility.createNettySslContextForClient(this.tlsAllowInsecureConnection, this.authData.getTlsTrustStoreStream(), (Certificate[])((X509Certificate[])this.authData.getTlsCertificates()), this.authData.getTlsPrivateKey())) : SecurityUtility.createNettySslContextForClient(this.tlsAllowInsecureConnection, this.tlsTrustCertsFilePath.getFileName());
        return this.sslNettyContext;
    }

    @Override
    public SslContext getSslContext() {
        return this.sslNettyContext;
    }

    @Override
    public boolean needUpdate() {
        return this.tlsTrustCertsFilePath.checkAndRefresh();
    }
}

