/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.api;

import java.util.ArrayList;
import java.util.List;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.reactive.client.api.ReactiveMessageReaderSpec;

public class MutableReactiveMessageReaderSpec
implements ReactiveMessageReaderSpec {
    private List<String> topicNames = new ArrayList<String>();
    private String readerName;
    private String subscriptionName;
    private String generatedSubscriptionNamePrefix;
    private Integer receiverQueueSize;
    private Boolean readCompacted;
    private List<Range> keyHashRanges;
    private CryptoKeyReader cryptoKeyReader;
    private ConsumerCryptoFailureAction cryptoFailureAction;

    public MutableReactiveMessageReaderSpec() {
    }

    public MutableReactiveMessageReaderSpec(ReactiveMessageReaderSpec readerSpec) {
        this.topicNames = readerSpec.getTopicNames() != null && !readerSpec.getTopicNames().isEmpty() ? new ArrayList<String>(readerSpec.getTopicNames()) : new ArrayList<String>();
        this.readerName = readerSpec.getReaderName();
        this.subscriptionName = readerSpec.getSubscriptionName();
        this.generatedSubscriptionNamePrefix = readerSpec.getGeneratedSubscriptionNamePrefix();
        this.receiverQueueSize = readerSpec.getReceiverQueueSize();
        this.readCompacted = readerSpec.getReadCompacted();
        this.keyHashRanges = readerSpec.getKeyHashRanges();
        this.cryptoKeyReader = readerSpec.getCryptoKeyReader();
        this.cryptoFailureAction = readerSpec.getCryptoFailureAction();
    }

    @Override
    public List<String> getTopicNames() {
        return this.topicNames;
    }

    public void setTopicNames(List<String> topicNames) {
        this.topicNames = topicNames;
    }

    @Override
    public String getReaderName() {
        return this.readerName;
    }

    public void setReaderName(String readerName) {
        this.readerName = readerName;
    }

    @Override
    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    @Override
    public String getGeneratedSubscriptionNamePrefix() {
        return this.generatedSubscriptionNamePrefix;
    }

    public void setGeneratedSubscriptionNamePrefix(String generatedSubscriptionNamePrefix) {
        this.generatedSubscriptionNamePrefix = generatedSubscriptionNamePrefix;
    }

    @Override
    public Integer getReceiverQueueSize() {
        return this.receiverQueueSize;
    }

    public void setReceiverQueueSize(Integer receiverQueueSize) {
        this.receiverQueueSize = receiverQueueSize;
    }

    @Override
    public Boolean getReadCompacted() {
        return this.readCompacted;
    }

    public void setReadCompacted(Boolean readCompacted) {
        this.readCompacted = readCompacted;
    }

    @Override
    public List<Range> getKeyHashRanges() {
        return this.keyHashRanges;
    }

    public void setKeyHashRanges(List<Range> keyHashRanges) {
        this.keyHashRanges = keyHashRanges;
    }

    @Override
    public CryptoKeyReader getCryptoKeyReader() {
        return this.cryptoKeyReader;
    }

    public void setCryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        this.cryptoKeyReader = cryptoKeyReader;
    }

    @Override
    public ConsumerCryptoFailureAction getCryptoFailureAction() {
        return this.cryptoFailureAction;
    }

    public void setCryptoFailureAction(ConsumerCryptoFailureAction cryptoFailureAction) {
        this.cryptoFailureAction = cryptoFailureAction;
    }

    public void applySpec(ReactiveMessageReaderSpec readerSpec) {
        if (readerSpec.getTopicNames() != null && !readerSpec.getTopicNames().isEmpty()) {
            this.setTopicNames(new ArrayList<String>(readerSpec.getTopicNames()));
        }
        if (readerSpec.getReaderName() != null) {
            this.setReaderName(readerSpec.getReaderName());
        }
        if (readerSpec.getSubscriptionName() != null) {
            this.setSubscriptionName(readerSpec.getSubscriptionName());
        }
        if (readerSpec.getGeneratedSubscriptionNamePrefix() != null) {
            this.setGeneratedSubscriptionNamePrefix(readerSpec.getGeneratedSubscriptionNamePrefix());
        }
        if (readerSpec.getReceiverQueueSize() != null) {
            this.setReceiverQueueSize(readerSpec.getReceiverQueueSize());
        }
        if (readerSpec.getReadCompacted() != null) {
            this.setReadCompacted(readerSpec.getReadCompacted());
        }
        if (readerSpec.getKeyHashRanges() != null && !readerSpec.getKeyHashRanges().isEmpty()) {
            this.setKeyHashRanges(new ArrayList<Range>(readerSpec.getKeyHashRanges()));
        }
        if (readerSpec.getCryptoKeyReader() != null) {
            this.setCryptoKeyReader(readerSpec.getCryptoKeyReader());
        }
        if (readerSpec.getCryptoFailureAction() != null) {
            this.setCryptoFailureAction(readerSpec.getCryptoFailureAction());
        }
    }
}

