/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.AbstractBatchMessageContainer;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.ProducerImpl;
import org.apache.pulsar.client.impl.SendCallback;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.api.proto.CompressionType;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.compression.CompressionCodec;
import org.apache.pulsar.common.protocol.ByteBufPair;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.shade.com.google.common.collect.ComparisonChain;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchMessageKeyBasedContainer
extends AbstractBatchMessageContainer {
    private Map<String, KeyedBatch> batches = new HashMap<String, KeyedBatch>();
    private static final Logger log = LoggerFactory.getLogger(BatchMessageKeyBasedContainer.class);

    BatchMessageKeyBasedContainer() {
    }

    @Override
    public boolean add(MessageImpl<?> msg, SendCallback callback) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] add message to batch, num messages in batch so far is {}", new Object[]{this.topicName, this.producer.getProducerName(), this.numMessagesInBatch});
        }
        ++this.numMessagesInBatch;
        this.currentBatchSizeBytes += (long)msg.getDataBuffer().readableBytes();
        String key = this.getKey(msg);
        KeyedBatch part = this.batches.get(key);
        if (part == null) {
            part = new KeyedBatch();
            part.addMsg(msg, callback);
            part.compressionType = this.compressionType;
            part.compressor = this.compressor;
            part.maxBatchSize = this.maxBatchSize;
            part.topicName = this.topicName;
            part.producerName = this.producer.getProducerName();
            this.batches.putIfAbsent(key, part);
            if (msg.getMessageBuilder().hasTxnidMostBits() && this.currentTxnidMostBits == -1L) {
                this.currentTxnidMostBits = msg.getMessageBuilder().getTxnidMostBits();
            }
            if (msg.getMessageBuilder().hasTxnidLeastBits() && this.currentTxnidLeastBits == -1L) {
                this.currentTxnidLeastBits = msg.getMessageBuilder().getTxnidLeastBits();
            }
        } else {
            part.addMsg(msg, callback);
        }
        return this.isBatchFull();
    }

    public void clear() {
        this.numMessagesInBatch = 0;
        this.currentBatchSizeBytes = 0L;
        this.batches = new HashMap<String, KeyedBatch>();
        this.currentTxnidMostBits = -1L;
        this.currentTxnidLeastBits = -1L;
    }

    public boolean isEmpty() {
        return this.batches.isEmpty();
    }

    public void discard(Exception ex) {
        try {
            this.batches.forEach((k, v) -> ((KeyedBatch)v).firstCallback.sendComplete(ex));
        }
        catch (Throwable t) {
            log.warn("[{}] [{}] Got exception while completing the callback", new Object[]{this.topicName, this.producer.getProducerName(), t});
        }
        this.batches.forEach((k, v) -> ReferenceCountUtil.safeRelease(((KeyedBatch)v).batchedMessageMetadataAndPayload));
        this.clear();
    }

    public boolean isMultiBatches() {
        return true;
    }

    private ProducerImpl.OpSendMsg createOpSendMsg(KeyedBatch keyedBatch) throws IOException {
        ByteBuf encryptedPayload = this.producer.encryptMessage(keyedBatch.messageMetadata, keyedBatch.getCompressedBatchMetadataAndPayload());
        if (encryptedPayload.readableBytes() > ClientCnx.getMaxMessageSize()) {
            keyedBatch.discard((Exception)new PulsarClientException.InvalidMessageException("Message size is bigger than " + ClientCnx.getMaxMessageSize() + " bytes"));
            return null;
        }
        int numMessagesInBatch = keyedBatch.messages.size();
        long currentBatchSizeBytes = 0L;
        for (MessageImpl message : keyedBatch.messages) {
            currentBatchSizeBytes += (long)message.getDataBuffer().readableBytes();
        }
        keyedBatch.messageMetadata.setNumMessagesInBatch(numMessagesInBatch);
        if (this.currentTxnidMostBits != -1L) {
            keyedBatch.messageMetadata.setTxnidMostBits(this.currentTxnidMostBits);
        }
        if (this.currentTxnidLeastBits != -1L) {
            keyedBatch.messageMetadata.setTxnidLeastBits(this.currentTxnidLeastBits);
        }
        ByteBufPair cmd = this.producer.sendMessage(this.producer.producerId, keyedBatch.sequenceId, numMessagesInBatch, keyedBatch.messageMetadata, encryptedPayload);
        ProducerImpl.OpSendMsg op = ProducerImpl.OpSendMsg.create(keyedBatch.messages, cmd, keyedBatch.sequenceId, keyedBatch.firstCallback);
        op.setNumMessagesInBatch(numMessagesInBatch);
        op.setBatchSizeByte(currentBatchSizeBytes);
        return op;
    }

    @Override
    public List<ProducerImpl.OpSendMsg> createOpSendMsgs() throws IOException {
        ArrayList<ProducerImpl.OpSendMsg> result = new ArrayList<ProducerImpl.OpSendMsg>();
        ArrayList<KeyedBatch> list = new ArrayList<KeyedBatch>(this.batches.values());
        list.sort((o1, o2) -> ComparisonChain.start().compare(((KeyedBatch)o1).sequenceId, ((KeyedBatch)o2).sequenceId).result());
        for (KeyedBatch keyedBatch : list) {
            ProducerImpl.OpSendMsg op = this.createOpSendMsg(keyedBatch);
            if (op == null) continue;
            result.add(op);
        }
        return result;
    }

    @Override
    public boolean hasSameSchema(MessageImpl<?> msg) {
        String key = this.getKey(msg);
        KeyedBatch part = this.batches.get(key);
        if (part == null || part.messages.isEmpty()) {
            return true;
        }
        if (!part.messageMetadata.hasSchemaVersion()) {
            return msg.getSchemaVersion() == null;
        }
        return Arrays.equals(msg.getSchemaVersion(), part.messageMetadata.getSchemaVersion());
    }

    private String getKey(MessageImpl<?> msg) {
        if (msg.hasOrderingKey()) {
            return Base64.getEncoder().encodeToString(msg.getOrderingKey());
        }
        return msg.getKey();
    }

    private static class KeyedBatch {
        private final MessageMetadata messageMetadata = new MessageMetadata();
        private long sequenceId = -1L;
        private ByteBuf batchedMessageMetadataAndPayload;
        private List<MessageImpl<?>> messages = new ArrayList();
        private SendCallback previousCallback = null;
        private CompressionType compressionType;
        private CompressionCodec compressor;
        private int maxBatchSize;
        private String topicName;
        private String producerName;
        private SendCallback firstCallback;

        private KeyedBatch() {
        }

        private ByteBuf getCompressedBatchMetadataAndPayload() {
            for (MessageImpl<?> msg : this.messages) {
                this.batchedMessageMetadataAndPayload = Commands.serializeSingleMessageInBatchWithPayload(msg.getMessageBuilder(), msg.getDataBuffer(), this.batchedMessageMetadataAndPayload);
            }
            int uncompressedSize = this.batchedMessageMetadataAndPayload.readableBytes();
            ByteBuf compressedPayload = this.compressor.encode(this.batchedMessageMetadataAndPayload);
            this.batchedMessageMetadataAndPayload.release();
            if (this.compressionType != CompressionType.NONE) {
                this.messageMetadata.setCompression(this.compressionType);
                this.messageMetadata.setUncompressedSize(uncompressedSize);
            }
            this.maxBatchSize = Math.max(this.maxBatchSize, uncompressedSize);
            return compressedPayload;
        }

        private void addMsg(MessageImpl<?> msg, SendCallback callback) {
            if (this.messages.size() == 0) {
                this.sequenceId = Commands.initBatchMessageMetadata(this.messageMetadata, msg.getMessageBuilder());
                this.batchedMessageMetadataAndPayload = PulsarByteBufAllocator.DEFAULT.buffer(Math.min(this.maxBatchSize, ClientCnx.getMaxMessageSize()));
                this.firstCallback = callback;
            }
            if (this.previousCallback != null) {
                this.previousCallback.addCallback(msg, callback);
            }
            this.previousCallback = callback;
            this.messages.add(msg);
        }

        public void discard(Exception ex) {
            try {
                if (this.firstCallback != null) {
                    this.firstCallback.sendComplete(ex);
                }
            }
            catch (Throwable t) {
                log.warn("[{}] [{}] Got exception while completing the callback for msg {}:", new Object[]{this.topicName, this.producerName, this.sequenceId, t});
            }
            this.clear();
        }

        public void clear() {
            this.messages = new ArrayList();
            this.firstCallback = null;
            this.previousCallback = null;
            this.messageMetadata.clear();
            this.sequenceId = -1L;
            this.batchedMessageMetadataAndPayload = null;
        }
    }
}

