/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests;

import java.util.List;
import org.apache.pulsar.tests.BetweenTestClassesListenerAdapter;
import org.apache.pulsar.tests.MockitoThreadLocalStateCleaner;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestClass;

public class MockitoCleanupListener
extends BetweenTestClassesListenerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(MockitoCleanupListener.class);
    private static final boolean MOCKITO_CLEANUP_ENABLED = Boolean.parseBoolean(System.getProperty("testMockitoCleanup", "true"));
    private static final String MOCKITO_CLEANUP_INFO = "Cleaning up Mockito's ThreadSafeMockingProgress.MOCKING_PROGRESS_PROVIDER thread local state.";

    @Override
    protected void onBetweenTestClasses(List<ITestClass> testClasses) {
        if (MOCKITO_CLEANUP_ENABLED) {
            try {
                if (MockitoThreadLocalStateCleaner.INSTANCE.isEnabled()) {
                    LOG.info(MOCKITO_CLEANUP_INFO);
                    MockitoThreadLocalStateCleaner.INSTANCE.cleanup();
                }
            }
            finally {
                this.cleanupMockitoInline();
            }
        }
    }

    private void cleanupMockitoInline() {
        Mockito.framework().clearInlineMocks();
    }
}

