/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.pluto.test.utilities;

import com.gargoylesoftware.css.parser.CSSErrorHandler;
import com.gargoylesoftware.htmlunit.SilentCssErrorHandler;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebClientOptions;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.safari.SafariDriver;

public class SimpleTestDriver {
    protected static String baseUrl;
    protected static String loginUrl;
    protected static String host;
    protected static String port;
    protected static String testFile;
    protected static String browser;
    protected static String username;
    protected static String usernameId;
    protected static String password;
    protected static String passwordId;
    protected static String testContextBase;
    protected static String module;
    protected static int timeout;
    protected static boolean useGeneratedUrl;
    protected static boolean debug;
    protected static boolean dryrun;
    protected static boolean scroll;
    protected static WebDriver driver;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        if (driver == null) {
            loginUrl = System.getProperty("test.server.login.url");
            host = System.getProperty("test.server.host");
            port = System.getProperty("test.server.port");
            username = System.getProperty("test.server.username");
            usernameId = System.getProperty("test.server.username.id");
            password = System.getProperty("test.server.password");
            passwordId = System.getProperty("test.server.password.id");
            browser = System.getProperty("test.browser");
            testContextBase = System.getProperty("test.context.base");
            StringBuilder sb = new StringBuilder();
            sb.append("http://");
            sb.append(host);
            if (port != null && !port.isEmpty()) {
                sb.append(":");
                sb.append(port);
            }
            sb.append("/");
            sb.append(testContextBase);
            baseUrl = sb.toString();
            String str = System.getProperty("test.url.strategy");
            useGeneratedUrl = str.equalsIgnoreCase("generateURLs");
            str = System.getProperty("test.debug");
            debug = str.equalsIgnoreCase("true");
            str = System.getProperty("test.timeout");
            dryrun = Boolean.valueOf(System.getProperty("test.dryrun"));
            timeout = str != null && str.matches("\\d+") ? Integer.parseInt(str) : 3;
            String wd = System.getProperty("test.browser.webDriver");
            String binary = System.getProperty("test.browser.binary");
            String headlessProperty = System.getProperty("test.browser.headless");
            boolean headless = headlessProperty == null || headlessProperty.length() == 0 || Boolean.valueOf(headlessProperty) != false;
            String maximizedProperty = System.getProperty("test.browser.maximized");
            boolean maximized = Boolean.valueOf(maximizedProperty);
            System.out.println("before class.");
            System.out.println("   Debug        =" + debug);
            System.out.println("   Dryrun       =" + dryrun);
            System.out.println("   Timeout      =" + timeout);
            System.out.println("   Login URL    =" + loginUrl);
            System.out.println("   Host         =" + host);
            System.out.println("   Port         =" + port);
            System.out.println("   Context      =" + testContextBase);
            System.out.println("   Generate URL =" + useGeneratedUrl);
            System.out.println("   Username     =" + username);
            System.out.println("   UsernameId   =" + usernameId);
            System.out.println("   Password     =" + password);
            System.out.println("   PasswordId   =" + passwordId);
            System.out.println("   Browser      =" + browser);
            System.out.println("   Driver       =" + wd);
            System.out.println("   binary       =" + binary);
            System.out.println("   headless     =" + headless);
            System.out.println("   maximized    =" + maximized);
            if (browser.equalsIgnoreCase("firefox")) {
                System.setProperty("webdriver.gecko.driver", wd);
                FirefoxOptions options = new FirefoxOptions();
                options.setLegacy(true);
                options.setAcceptInsecureCerts(true);
                if (binary != null && binary.length() != 0) {
                    options.setBinary(binary);
                }
                if (headless) {
                    options.setHeadless(true);
                }
                driver = new FirefoxDriver(options);
            } else if (browser.equalsIgnoreCase("internetExplorer")) {
                System.setProperty("webdriver.ie.driver", wd);
                driver = new InternetExplorerDriver();
            } else if (browser.equalsIgnoreCase("chrome")) {
                System.setProperty("webdriver.chrome.driver", wd);
                ChromeOptions options = new ChromeOptions();
                if (binary != null && binary.length() > 0) {
                    options.setBinary(binary);
                }
                if (headless) {
                    options.addArguments(new String[]{"--headless"});
                }
                options.addArguments(new String[]{"--disable-infobars"});
                options.setAcceptInsecureCerts(true);
                if (maximized) {
                    options.addArguments(new String[]{"--window-size=1920,1200"});
                }
                driver = new ChromeDriver(options);
            } else if (browser.equalsIgnoreCase("phantomjs")) {
                DesiredCapabilities capabilities = DesiredCapabilities.phantomjs();
                capabilities.setJavascriptEnabled(true);
                capabilities.setCapability("phantomjs.binary.path", binary);
                driver = new PhantomJSDriver((Capabilities)capabilities);
            } else if (browser.equalsIgnoreCase("htmlUnit")) {
                LogFactory.getFactory().setAttribute("org.apache.commons.logging.Log", (Object)"org.apache.commons.logging.impl.NoOpLog");
                Logger.getLogger("com.gargoylesoftware").setLevel(Level.SEVERE);
                Logger.getLogger("org.apache.commons.httpclient").setLevel(Level.SEVERE);
                driver = new HtmlUnitDriver(){

                    protected WebClient getWebClient() {
                        WebClient webClient = super.getWebClient();
                        WebClientOptions options = webClient.getOptions();
                        options.setThrowExceptionOnFailingStatusCode(false);
                        options.setThrowExceptionOnScriptError(false);
                        options.setPrintContentOnFailingStatusCode(false);
                        webClient.setCssErrorHandler((CSSErrorHandler)new SilentCssErrorHandler());
                        return webClient;
                    }
                };
            } else if (browser.equalsIgnoreCase("safari")) {
                driver = new SafariDriver();
            } else {
                throw new Exception("Unsupported browser: " + browser);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    driver.quit();
                }
            }));
            if (maximized) {
                driver.manage().window().maximize();
            }
            if (!dryrun) {
                SimpleTestDriver.login();
            }
        }
    }

    protected static void login() {
        driver.get(loginUrl);
        List uels = driver.findElements(By.id((String)usernameId));
        List pwels = driver.findElements(By.id((String)passwordId));
        if (!uels.isEmpty() && !pwels.isEmpty()) {
            System.out.println("login: found userid and password fields");
            WebElement userEl = (WebElement)uels.get(0);
            WebElement pwEl = (WebElement)pwels.get(0);
            userEl.clear();
            userEl.sendKeys(new CharSequence[]{username});
            pwEl.clear();
            pwEl.sendKeys(new CharSequence[]{password});
            pwEl.submit();
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        System.out.println("   after class.");
    }

    static {
        timeout = 3;
        useGeneratedUrl = true;
        debug = false;
        dryrun = false;
    }
}

