/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.portlet.PortletConfig;
import org.apache.pluto.container.bean.mvc.MvcExtension;
import org.apache.pluto.container.bean.processor.AnnotatedConfigBean;
import org.apache.pluto.container.bean.processor.AnnotatedMethodStore;
import org.apache.pluto.container.bean.processor.ConfigSummary;
import org.apache.pluto.container.bean.processor.InvalidAnnotationException;
import org.apache.pluto.container.bean.processor.PortletAnnotationRecognizer;
import org.apache.pluto.container.bean.processor.PortletRequestScopedContext;
import org.apache.pluto.container.bean.processor.PortletSessionScopedContext;
import org.apache.pluto.container.bean.processor.PortletStateScopedContext;
import org.apache.pluto.container.bean.processor.RedirectScopedContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletCDIExtension
implements Extension {
    private static final Logger LOG = LoggerFactory.getLogger(PortletCDIExtension.class);
    private final ConfigSummary summary = new ConfigSummary();
    private final AnnotatedMethodStore ams = new AnnotatedMethodStore(this.summary);
    private final PortletAnnotationRecognizer par = new PortletAnnotationRecognizer(this.ams, this.summary);
    private AnnotatedConfigBean acb = null;

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd) {
        LOG.debug("PortletCDIExtension - scanning.");
    }

    void processType(@Observes ProcessAnnotatedType<?> pat) throws InvalidAnnotationException {
        this.par.checkAnnotatedType(pat);
        MvcExtension.processAnnotatedType(pat);
    }

    <X extends PortletConfig> void processPortletConfig(@Observes ProcessAnnotatedType<X> pat) {
        final AnnotatedType pcfg = pat.getAnnotatedType();
        final HashSet types = new HashSet(pcfg.getTypeClosure());
        if (types.contains(PortletConfig.class)) {
            if (LOG.isTraceEnabled()) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("Found a PortletConfig.");
                txt.append(" Class: ").append(pcfg.getJavaClass().getCanonicalName());
                txt.append(", Base type: ").append(((Class)pcfg.getBaseType()).getCanonicalName());
                LOG.debug(txt.toString());
            }
            types.remove(PortletConfig.class);
            AnnotatedType wrapped = new AnnotatedType<X>(){

                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return (T)pcfg.getAnnotation(arg0);
                }

                public Set<Annotation> getAnnotations() {
                    return pcfg.getAnnotations();
                }

                public Type getBaseType() {
                    return pcfg.getBaseType();
                }

                public Set<Type> getTypeClosure() {
                    return types;
                }

                public boolean isAnnotationPresent(Class<? extends Annotation> arg0) {
                    return pcfg.isAnnotationPresent(arg0);
                }

                public Set<AnnotatedConstructor<X>> getConstructors() {
                    return pcfg.getConstructors();
                }

                public Set<AnnotatedField<? super X>> getFields() {
                    return pcfg.getFields();
                }

                public Class<X> getJavaClass() {
                    return pcfg.getJavaClass();
                }

                public Set<AnnotatedMethod<? super X>> getMethods() {
                    return pcfg.getMethods();
                }
            };
            pat.setAnnotatedType(wrapped);
        }
    }

    void addPortletCustomScopeContexts(@Observes AfterBeanDiscovery abd) {
        RedirectScopedContext rsc = new RedirectScopedContext();
        abd.addContext((Context)rsc);
        PortletSessionScopedContext pssc = new PortletSessionScopedContext();
        abd.addContext((Context)pssc);
        PortletStateScopedContext pstsc = new PortletStateScopedContext();
        abd.addContext((Context)pstsc);
        PortletRequestScopedContext prsc = new PortletRequestScopedContext();
        abd.addContext((Context)prsc);
    }

    void afterDeploymentValidation(@Observes AfterDeploymentValidation adv, BeanManager bm) throws InvalidAnnotationException {
        LOG.trace("Now attempting to get the AnnotatedConfigBean ...");
        Set beans = bm.getBeans(AnnotatedConfigBean.class, new Annotation[0]);
        Bean bean = bm.resolve(beans);
        if (bean != null) {
            LOG.trace("Got AnnotatedConfigBean bean: " + bean.getBeanClass().getCanonicalName());
            try {
                CreationalContext cc = bm.createCreationalContext((Contextual)bean);
                this.acb = (AnnotatedConfigBean)bm.getReference(bean, AnnotatedConfigBean.class, cc);
                LOG.trace("Got AnnotatedConfigBean instance.");
                this.acb.setMethodStore(this.ams);
                this.acb.setSummary(this.summary);
                this.acb.setRedirectScopedConfig(this.par.getRedirectScopedConfig());
                this.acb.setStateScopedConfig(this.par.getStateScopedConfig());
                this.acb.setSessionScopedConfig(this.par.getSessionScopedConfig());
            }
            catch (Exception e) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("Exception getting AnnotatedConfigBean bean instance: ");
                txt.append(e.toString());
                LOG.warn(txt.toString());
            }
        } else {
            LOG.warn("AnnotatedConfigBean bean was null.");
        }
        LOG.info("Portlet CDI Extension complete. Config bean: " + this.acb);
    }
}

