/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.processor;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.portlet.annotations.PortletSessionScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletSessionScopedConfig
implements Serializable {
    private static final long serialVersionUID = -5333145344722804837L;
    private final Logger LOG = LoggerFactory.getLogger(PortletSessionScopedConfig.class);
    private final boolean isTrace = this.LOG.isTraceEnabled();
    private final Map<Contextual<?>, PortletSessionScoped> context2Anno = new HashMap();
    private final Map<Class<?>, PortletSessionScoped> class2Anno = new HashMap();

    public void addAnnotation(Class<?> beanClass, PortletSessionScoped anno) {
        this.class2Anno.put(beanClass, anno);
    }

    public void activate(BeanManager bm) {
        for (Class<?> cls : this.class2Anno.keySet()) {
            Set beans = bm.getBeans(cls, new Annotation[0]);
            Bean bean = bm.resolve(beans);
            assert (bean != null);
            this.context2Anno.put((Contextual<?>)bean, this.class2Anno.get(cls));
        }
        if (this.isTrace) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("PortletSessionScopedBeanHolder configuration. ");
            txt.append(" AnnotatedBeans: ");
            txt.append(this.getConfigAsString());
            this.LOG.debug(txt.toString());
        }
    }

    public Set<Class<?>> getBeanClasses() {
        return this.class2Anno.keySet();
    }

    public String getConfigAsString() {
        StringBuilder txt = new StringBuilder(128);
        for (Class<?> c : this.class2Anno.keySet()) {
            txt.append("\n\tClass: ").append(c.getCanonicalName());
            boolean ps = this.class2Anno.get(c).value() == 2;
            txt.append(", Portlet scoped: ").append(ps);
        }
        return txt.toString();
    }

    public Boolean isPortletScoped(Class<?> beanClass) {
        Boolean ps = null;
        for (Contextual<?> b : this.context2Anno.keySet()) {
            Bean bean;
            if (!(b instanceof Bean) || !beanClass.isAssignableFrom((bean = (Bean)b).getBeanClass())) continue;
            ps = this.context2Anno.get(b).value() == 2;
            break;
        }
        return ps;
    }

    public Boolean isPortletScoped(Contextual<?> bean) {
        boolean isPS;
        PortletSessionScoped anno = this.context2Anno.get(bean);
        assert (anno != null);
        boolean bl = isPS = anno.value() == 2;
        if (this.isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Bean: ");
            if (bean instanceof Bean) {
                Bean b = (Bean)bean;
                txt.append(b.getBeanClass().getSimpleName());
            } else {
                txt.append("Contextual");
            }
            txt.append(", isPortletScoped: ").append(isPS);
            this.LOG.debug(txt.toString());
        }
        return isPS;
    }
}

