/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.portlet.Portlet;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.PreferencesValidator;
import javax.portlet.filter.PortletFilter;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.pluto.container.om.portlet.ContainerRuntimeOption;
import org.apache.pluto.container.om.portlet.Description;
import org.apache.pluto.container.om.portlet.DisplayName;
import org.apache.pluto.container.om.portlet.EventDefinition;
import org.apache.pluto.container.om.portlet.EventDefinitionReference;
import org.apache.pluto.container.om.portlet.Filter;
import org.apache.pluto.container.om.portlet.FilterMapping;
import org.apache.pluto.container.om.portlet.InitParam;
import org.apache.pluto.container.om.portlet.Listener;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.Preference;
import org.apache.pluto.container.om.portlet.Preferences;
import org.apache.pluto.container.om.portlet.PublicRenderParameter;
import org.apache.pluto.container.om.portlet.SecurityRoleRef;
import org.apache.pluto.container.om.portlet.Supports;
import org.apache.pluto.container.om.portlet.impl.ContainerRuntimeOptionImpl;
import org.apache.pluto.container.om.portlet.impl.CustomPortletModeImpl;
import org.apache.pluto.container.om.portlet.impl.CustomWindowStateImpl;
import org.apache.pluto.container.om.portlet.impl.DescriptionImpl;
import org.apache.pluto.container.om.portlet.impl.DisplayNameImpl;
import org.apache.pluto.container.om.portlet.impl.EventDefinitionImpl;
import org.apache.pluto.container.om.portlet.impl.EventDefinitionReferenceImpl;
import org.apache.pluto.container.om.portlet.impl.FilterImpl;
import org.apache.pluto.container.om.portlet.impl.FilterMappingImpl;
import org.apache.pluto.container.om.portlet.impl.InitParamImpl;
import org.apache.pluto.container.om.portlet.impl.JSR168ConfigurationProcessor;
import org.apache.pluto.container.om.portlet.impl.ListenerImpl;
import org.apache.pluto.container.om.portlet.impl.PortletDefinitionImpl;
import org.apache.pluto.container.om.portlet.impl.PortletInfoImpl;
import org.apache.pluto.container.om.portlet.impl.PreferenceImpl;
import org.apache.pluto.container.om.portlet.impl.PreferencesImpl;
import org.apache.pluto.container.om.portlet.impl.PublicRenderParameterImpl;
import org.apache.pluto.container.om.portlet.impl.SecurityConstraintImpl;
import org.apache.pluto.container.om.portlet.impl.SecurityRoleRefImpl;
import org.apache.pluto.container.om.portlet.impl.SupportsImpl;
import org.apache.pluto.container.om.portlet.impl.UserAttributeImpl;
import org.apache.pluto.container.om.portlet.impl.UserDataConstraintImpl;
import org.apache.pluto.container.om.portlet20.impl.ContainerRuntimeOptionType;
import org.apache.pluto.container.om.portlet20.impl.CustomPortletModeType;
import org.apache.pluto.container.om.portlet20.impl.CustomWindowStateType;
import org.apache.pluto.container.om.portlet20.impl.DescriptionType;
import org.apache.pluto.container.om.portlet20.impl.DisplayNameType;
import org.apache.pluto.container.om.portlet20.impl.EventDefinitionReferenceType;
import org.apache.pluto.container.om.portlet20.impl.EventDefinitionType;
import org.apache.pluto.container.om.portlet20.impl.FilterMappingType;
import org.apache.pluto.container.om.portlet20.impl.FilterType;
import org.apache.pluto.container.om.portlet20.impl.InitParamType;
import org.apache.pluto.container.om.portlet20.impl.ListenerType;
import org.apache.pluto.container.om.portlet20.impl.MimeTypeType;
import org.apache.pluto.container.om.portlet20.impl.PortletAppType;
import org.apache.pluto.container.om.portlet20.impl.PortletCollectionType;
import org.apache.pluto.container.om.portlet20.impl.PortletInfoType;
import org.apache.pluto.container.om.portlet20.impl.PortletModeType;
import org.apache.pluto.container.om.portlet20.impl.PortletNameType;
import org.apache.pluto.container.om.portlet20.impl.PortletPreferencesType;
import org.apache.pluto.container.om.portlet20.impl.PortletType;
import org.apache.pluto.container.om.portlet20.impl.PreferenceType;
import org.apache.pluto.container.om.portlet20.impl.PublicRenderParameterType;
import org.apache.pluto.container.om.portlet20.impl.RoleLinkType;
import org.apache.pluto.container.om.portlet20.impl.SecurityConstraintType;
import org.apache.pluto.container.om.portlet20.impl.SecurityRoleRefType;
import org.apache.pluto.container.om.portlet20.impl.SupportedLocaleType;
import org.apache.pluto.container.om.portlet20.impl.SupportsType;
import org.apache.pluto.container.om.portlet20.impl.UserAttributeType;
import org.apache.pluto.container.om.portlet20.impl.UserDataConstraintType;
import org.apache.pluto.container.om.portlet20.impl.ValueType;
import org.apache.pluto.container.om.portlet20.impl.WindowStateType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR286ConfigurationProcessor
extends JSR168ConfigurationProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(JSR286ConfigurationProcessor.class);
    private static final boolean isTrace = LOG.isTraceEnabled();

    public JSR286ConfigurationProcessor(PortletApplicationDefinition pad) {
        super(pad);
    }

    @Override
    public void process(JAXBElement<?> rootElement) throws IllegalArgumentException {
        assert (rootElement != null);
        assert (rootElement.getValue() instanceof PortletAppType);
        PortletAppType app = (PortletAppType)rootElement.getValue();
        this.pad.setId(app.getId());
        if (app.getVersion() == null || !app.getVersion().equals("2.0")) {
            String warning = "Bad version. Expected 2.0, was: " + app.getVersion();
            LOG.warn(warning);
            throw new IllegalArgumentException(warning);
        }
        this.pad.setVersion(app.getVersion());
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Reading portlet DD. ");
            txt.append("Version: ");
            txt.append(app.getVersion());
            txt.append(", ID: ");
            txt.append(app.getId());
            LOG.trace(txt.toString());
        }
        if (app.getDefaultNamespace() != null && !app.getDefaultNamespace().equals("")) {
            this.pad.setDefaultNamespace(app.getDefaultNamespace());
        } else {
            this.pad.setDefaultNamespace("");
        }
        if (app.getResourceBundle() != null && app.getResourceBundle().getValue() != null && !app.getResourceBundle().getValue().equals("")) {
            this.pad.setResourceBundle(app.getResourceBundle().getValue());
        }
        for (EventDefinition ed : this.handleEventDefs(app.getEventDefinition())) {
            this.pad.addEventDefinition(ed);
        }
        for (PublicRenderParameter prp : this.handlePRPs(app.getPublicRenderParameter())) {
            this.pad.addPublicRenderParameter(prp);
        }
        for (ContainerRuntimeOption cro : this.handleRTOptions(app.getContainerRuntimeOption())) {
            this.pad.addContainerRuntimeOption(cro);
        }
        this.handleCPM(app.getCustomPortletMode());
        this.handleCWS(app.getCustomWindowState());
        this.handleSC(app.getSecurityConstraint());
        this.handleUA(app.getUserAttribute());
        this.handleListeners(app.getListener());
        this.handleFilters(app.getFilter());
        this.handlePortlets(app.getPortlet());
        this.handleFilterMappings(app.getFilterMapping());
    }

    private List<DisplayName> handleDisplayNames(List<DisplayNameType> dispNames) {
        ArrayList<DisplayName> list = new ArrayList<DisplayName>();
        for (DisplayNameType dispName : dispNames) {
            if (dispName.getValue() == null) {
                String warning = "Bad display name - no display name value; will be ignored. continuing ...";
                LOG.warn(warning);
                continue;
            }
            Locale loc = this.deriveLocale(dispName.getLang());
            DisplayNameImpl d = new DisplayNameImpl(loc, dispName.getValue());
            list.add(d);
        }
        return list;
    }

    private List<Description> handleDescriptions(List<DescriptionType> descs) {
        ArrayList<Description> list = new ArrayList<Description>();
        for (DescriptionType desc : descs) {
            if (desc.getValue() == null) {
                String warning = "Bad description - no description value; will be ignored. continuing ...";
                LOG.warn(warning);
                continue;
            }
            Locale loc = this.deriveLocale(desc.getLang());
            DescriptionImpl d = new DescriptionImpl(loc, desc.getValue());
            list.add(d);
        }
        return list;
    }

    private void handleUA(List<UserAttributeType> uats) {
        for (UserAttributeType uat : uats) {
            if (uat.getName() == null || uat.getName().getValue() == null) {
                String warning = "Bad user attribute will be ignored. Name was null. Continuing ...";
                LOG.warn(warning);
                continue;
            }
            UserAttributeImpl attr = new UserAttributeImpl(uat.getName().getValue());
            for (Description desc : this.handleDescriptions(uat.getDescription())) {
                attr.addDescription(desc);
            }
            this.pad.addUserAttribute(attr);
        }
    }

    private void handleFilters(List<FilterType> args) {
        for (FilterType item : args) {
            if (item.getFilterName() == null || item.getFilterName().length() == 0 || item.getFilterClass() == null || item.getFilterClass().length() == 0) {
                String warning = "Bad Filter definition. name or class was null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            FilterImpl newitem = new FilterImpl(item.getFilterName());
            newitem.setFilterClass(item.getFilterClass());
            for (InitParam ip : this.handleInitParam(item.getInitParam())) {
                newitem.addInitParam(ip);
            }
            for (String lc : item.getLifecycle()) {
                newitem.addLifecycle(lc);
            }
            for (Description desc : this.handleDescriptions(item.getDescription())) {
                newitem.addDescription(desc);
            }
            for (DisplayName dispName : this.handleDisplayNames(item.getDisplayName())) {
                newitem.addDisplayName(dispName);
            }
            this.pad.addFilter(newitem);
        }
    }

    private void handleFilterMappings(List<FilterMappingType> args) {
        for (FilterMappingType item : args) {
            String fname = item.getFilterName();
            if (fname == null || item.getPortletName().size() == 0) {
                String warning = "Bad FilterMapping definition. Filter name or portlet name is null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            FilterMappingImpl newitem = new FilterMappingImpl(fname);
            for (PortletNameType pnt : item.getPortletName()) {
                newitem.addPortletName(pnt.getValue());
            }
            this.pad.addFilterMapping(newitem);
        }
    }

    private void handleListeners(List<ListenerType> args) {
        for (ListenerType item : args) {
            if (item.getListenerClass() == null || item.getListenerClass().length() == 0) {
                String warning = "Bad Listener definition. Class was null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            ListenerImpl newitem = new ListenerImpl(item.getListenerClass());
            for (Description desc : this.handleDescriptions(item.getDescription())) {
                newitem.addDescription(desc);
            }
            for (DisplayName dispName : this.handleDisplayNames(item.getDisplayName())) {
                newitem.addDisplayName(dispName);
            }
            this.pad.addListener(newitem);
        }
    }

    private void handleCPM(List<CustomPortletModeType> cpms) {
        for (CustomPortletModeType cpm : cpms) {
            if (cpm.getPortletMode() == null || cpm.getPortletMode().getValue() == null) {
                String warning = "Custom portlet mode cannot be null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String val = cpm.getPortletMode().getValue();
            if (val.equalsIgnoreCase("view") || val.equalsIgnoreCase("edit") || val.equalsIgnoreCase("help")) {
                String warning = "Bad custom portlet mode: " + val;
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            CustomPortletModeImpl pm = new CustomPortletModeImpl(cpm.getPortletMode().getValue());
            for (Description desc : this.handleDescriptions(cpm.getDescription())) {
                pm.addDescription(desc);
            }
            boolean isPortalManaged = true;
            if (cpm.getPortalManaged() != null && cpm.getPortalManaged().value() != null) {
                isPortalManaged = cpm.getPortalManaged().value().equalsIgnoreCase("true");
            }
            pm.setPortalManaged(isPortalManaged);
            this.pad.addCustomPortletMode(pm);
        }
    }

    private void handleCWS(List<CustomWindowStateType> cwss) {
        for (CustomWindowStateType cws : cwss) {
            if (cws.getWindowState() == null || cws.getWindowState().getValue() == null) {
                String warning = "Custom window state cannot be null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String val = cws.getWindowState().getValue();
            if (val.equalsIgnoreCase("normal") || val.equalsIgnoreCase("maximized") || val.equalsIgnoreCase("minimized")) {
                String warning = "Bad custom window state: " + val;
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            CustomWindowStateImpl ws = new CustomWindowStateImpl(cws.getWindowState().getValue());
            for (Description desc : this.handleDescriptions(cws.getDescription())) {
                ws.addDescription(desc);
            }
            this.pad.addCustomWindowState(ws);
        }
    }

    private void handleSC(List<SecurityConstraintType> scs) {
        for (SecurityConstraintType sc : scs) {
            PortletCollectionType pct = sc.getPortletCollection();
            if (pct == null || pct.getPortletName() == null || pct.getPortletName().size() == 0) {
                String warning = "Portlet collection is empty.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            for (PortletNameType pnt : pct.getPortletName()) {
                if (pnt.getValue().length() != 0) continue;
                String warning = "Portlet name may not be null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            UserDataConstraintType udc = sc.getUserDataConstraint();
            if (udc == null || udc.getTransportGuarantee() == null || udc.getTransportGuarantee().value() == null) {
                String warning = "User data constraint contains null value.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            UserDataConstraintImpl newudc = new UserDataConstraintImpl(udc.getTransportGuarantee().value());
            for (Description desc : this.handleDescriptions(udc.getDescription())) {
                newudc.addDescription(desc);
            }
            SecurityConstraintImpl newsc = new SecurityConstraintImpl(newudc);
            for (DisplayName dispName : this.handleDisplayNames(sc.getDisplayName())) {
                newsc.addDisplayName(dispName);
            }
            for (PortletNameType portletName : pct.getPortletName()) {
                newsc.addPortletName(portletName.getValue());
            }
            this.pad.addSecurityConstraint(newsc);
        }
    }

    private List<Supports> handleSupports(List<SupportsType> sts) {
        ArrayList<Supports> newSupps = new ArrayList<Supports>();
        for (SupportsType st : sts) {
            List<WindowStateType> wslist;
            MimeTypeType mtt = st.getMimeType();
            if (mtt == null || mtt.getValue() == null) {
                String warning = "Null Mime type, ignoring Supports block.";
                LOG.warn(warning);
                continue;
            }
            List<PortletModeType> pmlist = st.getPortletMode();
            if (pmlist.size() == 0) {
                String info = "No portlet modes found in Supports block.";
                LOG.trace(info);
            }
            if ((wslist = st.getWindowState()).size() == 0) {
                String info = "No window states found in Supports block.";
                LOG.trace(info);
            }
            String mimetype = mtt.getValue().replaceAll("([^;]*).*", "$1").replaceAll(" ", "");
            SupportsImpl sup = new SupportsImpl(mimetype);
            for (PortletModeType portletModeType : pmlist) {
                sup.addPortletMode(portletModeType.getValue());
            }
            for (WindowStateType windowStateType : wslist) {
                sup.addWindowState(windowStateType.getValue());
            }
            newSupps.add(sup);
        }
        return newSupps;
    }

    private List<InitParam> handleInitParam(List<InitParamType> parms) {
        ArrayList<InitParam> newParms = new ArrayList<InitParam>();
        for (InitParamType parm : parms) {
            if (parm.getName() == null || parm.getName().getValue() == null || parm.getName().getValue().length() == 0) {
                String warning = "Bad init parameter. Parameter name was null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String name = parm.getName().getValue();
            String value = parm.getValue().getValue();
            InitParamImpl newp = new InitParamImpl(name, value);
            for (Description desc : this.handleDescriptions(parm.getDescription())) {
                newp.addDescription(desc);
            }
            newParms.add(newp);
        }
        return newParms;
    }

    private List<Preference> handlePreferences(List<PreferenceType> args) {
        ArrayList<Preference> list = new ArrayList<Preference>();
        for (PreferenceType item : args) {
            if (item.getName() == null || item.getName().getValue() == null || item.getName().getValue().length() == 0) {
                String warning = "Bad portlet preference. Preference name was null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String name = item.getName().getValue();
            List<ValueType> vals = item.getValue();
            ArrayList<String> lines = new ArrayList<String>(16);
            for (ValueType vt : vals) {
                lines.add(vt.getValue());
            }
            boolean isRO = false;
            if (item.getReadOnly() != null && item.getReadOnly().value() != null) {
                isRO = item.getReadOnly().value().equalsIgnoreCase("true");
            }
            PreferenceImpl pref = new PreferenceImpl(name, isRO, lines);
            list.add(pref);
        }
        return list;
    }

    private List<ContainerRuntimeOption> handleRTOptions(List<ContainerRuntimeOptionType> args) {
        ArrayList<ContainerRuntimeOption> list = new ArrayList<ContainerRuntimeOption>();
        for (ContainerRuntimeOptionType arg : args) {
            if (arg.getName() == null || arg.getName().getValue() == null || arg.getName().getValue().equals("")) {
                String warning = "Bad container runtime option. Name was null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String name = arg.getName().getValue();
            List<ValueType> vals = arg.getValue();
            ArrayList<String> lines = new ArrayList<String>(16);
            for (ValueType vt : vals) {
                lines.add(vt.getValue());
            }
            ContainerRuntimeOptionImpl item = new ContainerRuntimeOptionImpl(name, lines);
            list.add(item);
        }
        return list;
    }

    private List<SecurityRoleRef> handleSecRoleRef(List<SecurityRoleRefType> args) {
        ArrayList<SecurityRoleRef> list = new ArrayList<SecurityRoleRef>();
        for (SecurityRoleRefType item : args) {
            String roleLinkValue;
            if (item.getRoleName() == null || item.getRoleName().length() == 0) {
                String warning = "Bad security role reference. Name was null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String name = item.getRoleName();
            SecurityRoleRefImpl srr = new SecurityRoleRefImpl(name);
            RoleLinkType roleLink = item.getRoleLink();
            if (roleLink != null && (roleLinkValue = roleLink.getValue()) != null && roleLinkValue.length() > 0) {
                srr.setRoleLink(roleLinkValue);
            }
            for (Description desc : this.handleDescriptions(item.getDescription())) {
                srr.addDescription(desc);
            }
            list.add(srr);
        }
        return list;
    }

    private List<EventDefinitionReference> handleEventDefRefs(List<EventDefinitionReferenceType> args) {
        ArrayList<EventDefinitionReference> list = new ArrayList<EventDefinitionReference>();
        for (EventDefinitionReferenceType item : args) {
            if (item.getName() == null && item.getQname() == null) {
                String warning = "Bad Even definition reference. Name and QName are null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String name = item.getName();
            QName qname = item.getQname();
            if (qname == null) {
                qname = new QName(this.pad.getDefaultNamespace(), name);
            }
            EventDefinitionReferenceImpl newedr = new EventDefinitionReferenceImpl(qname);
            list.add(newedr);
        }
        return list;
    }

    private List<EventDefinition> handleEventDefs(List<EventDefinitionType> args) {
        ArrayList<EventDefinition> list = new ArrayList<EventDefinition>();
        for (EventDefinitionType item : args) {
            if (item.getName() == null && item.getQname() == null) {
                String warning = "Bad Event definition. Name and QName are null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String name = item.getName();
            QName qname = item.getQname();
            if (qname == null) {
                qname = new QName(this.pad.getDefaultNamespace(), name);
            }
            EventDefinitionImpl newed = new EventDefinitionImpl(qname);
            String clsName = item.getValueType();
            if (clsName != null && clsName.length() > 0) {
                newed.setValueType(clsName);
            }
            for (Description desc : this.handleDescriptions(item.getDescription())) {
                newed.addDescription(desc);
            }
            for (QName qn : item.getAlias()) {
                newed.addAlias(qn);
            }
            list.add(newed);
        }
        return list;
    }

    private List<PublicRenderParameter> handlePRPs(List<PublicRenderParameterType> args) {
        ArrayList<PublicRenderParameter> list = new ArrayList<PublicRenderParameter>();
        for (PublicRenderParameterType item : args) {
            if (item.getName() == null && item.getQname() == null) {
                String warning = "Bad public render parameter definition. Name and QName are null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String id = item.getIdentifier();
            if (id == null || id.length() == 0) {
                String warning = "Bad public render parameter definition. Identifier is null.";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String name = item.getName();
            QName qname = item.getQname();
            if (qname == null) {
                qname = new QName(this.pad.getDefaultNamespace(), name);
            }
            PublicRenderParameterImpl newprp = new PublicRenderParameterImpl(qname, id);
            for (Description desc : this.handleDescriptions(item.getDescription())) {
                newprp.addDescription(desc);
            }
            for (QName qn : item.getAlias()) {
                newprp.addAlias(qn);
            }
            list.add(newprp);
        }
        return list;
    }

    private void handlePortlets(List<PortletType> portlets) {
        for (PortletType portlet : portlets) {
            if (portlet.getPortletName() == null || portlet.getPortletName().getValue() == null || portlet.getPortletName().getValue().length() == 0) {
                String warning = "Portlet name may not be null";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            String pn = portlet.getPortletName().getValue();
            String clsName = portlet.getPortletClass();
            if (clsName == null || clsName.length() == 0) {
                String warning = "Portlet class may not be null";
                LOG.warn(warning);
                throw new IllegalArgumentException(warning);
            }
            PortletDefinitionImpl pd = new PortletDefinitionImpl(pn, this.pad);
            pd.setPortletClass(portlet.getPortletClass());
            if (portlet.getResourceBundle() != null) {
                pd.setResourceBundle(portlet.getResourceBundle().getValue());
            }
            if (portlet.getExpirationCache() != null) {
                pd.setExpirationCache(portlet.getExpirationCache().getValue());
            }
            if (portlet.getCacheScope() != null) {
                pd.setCacheScope(portlet.getCacheScope().getValue());
            }
            for (DisplayName dispName : this.handleDisplayNames(portlet.getDisplayName())) {
                pd.addDisplayName(dispName);
            }
            for (Description desc : this.handleDescriptions(portlet.getDescription())) {
                pd.addDescription(desc);
            }
            for (Supports s : this.handleSupports(portlet.getSupports())) {
                pd.addSupports(s);
            }
            PortletInfoType pit = portlet.getPortletInfo();
            if (pit != null) {
                Iterator<InitParam> title = null;
                String st = null;
                Object kw = null;
                if (pit.getTitle() != null) {
                    title = pit.getTitle().getValue();
                }
                if (pit.getShortTitle() != null) {
                    st = pit.getShortTitle().getValue();
                }
                if (pit.getKeywords() != null) {
                    kw = pit.getKeywords().getValue();
                }
                PortletInfoImpl info = new PortletInfoImpl((String)((Object)title), (String)kw, st);
                pd.setPortletInfo(info);
            }
            for (SupportedLocaleType slt : portlet.getSupportedLocale()) {
                pd.addSupportedLocale(slt.getValue());
            }
            for (InitParam ip : this.handleInitParam(portlet.getInitParam())) {
                pd.addInitParam(ip);
            }
            PortletPreferencesType prefs = portlet.getPortletPreferences();
            if (prefs != null) {
                PreferencesImpl newprefs = new PreferencesImpl();
                clsName = prefs.getPreferencesValidator();
                newprefs.setPreferencesValidator(clsName);
                for (Preference p : this.handlePreferences(prefs.getPreference())) {
                    newprefs.addPreference(p);
                }
                pd.setPortletPreferences(newprefs);
            }
            for (SecurityRoleRef srr : this.handleSecRoleRef(portlet.getSecurityRoleRef())) {
                pd.addSecurityRoleRef(srr);
            }
            for (ContainerRuntimeOption cro : this.handleRTOptions(portlet.getContainerRuntimeOption())) {
                pd.addContainerRuntimeOption(cro);
            }
            for (String prp : portlet.getSupportedPublicRenderParameter()) {
                if (prp == null || prp.length() == 0) {
                    String warning = "Supported public render parameter definition may not be null.";
                    LOG.warn(warning);
                    throw new IllegalArgumentException(warning);
                }
                pd.addSupportedPublicRenderParameter(prp);
            }
            for (EventDefinitionReference edr : this.handleEventDefRefs(portlet.getSupportedProcessingEvent())) {
                pd.addSupportedProcessingEvent(edr);
            }
            for (EventDefinitionReference edr : this.handleEventDefRefs(portlet.getSupportedPublishingEvent())) {
                pd.addSupportedPublishingEvent(edr);
            }
            this.pad.addPortlet(pd);
        }
    }

    @Override
    public void validate() {
        super.validate();
        StringBuilder txt = new StringBuilder(128);
        if (this.pad.getResourceBundle() != null && this.pad.getResourceBundle().length() > 0) {
            try {
                this.checkValidBundle(this.pad.getResourceBundle());
            }
            catch (Exception e) {
                this.pad.setResourceBundle("");
            }
        }
        for (EventDefinition ed : this.pad.getEventDefinitions()) {
            String clsName = ed.getValueType();
            if (clsName == null || clsName.equals("")) continue;
            try {
                this.checkValidClass(clsName, null, "Bad Event definition. Payload type is invalid: ");
            }
            catch (Exception e) {
                this.pad.removeEventDefinition(ed);
            }
        }
        for (Listener l : this.pad.getListeners()) {
            try {
                this.checkValidClass(l.getListenerClass(), PortletURLGenerationListener.class, "Bad listener definition. Listener class is invalid: ");
            }
            catch (Exception e) {
                this.pad.removeListener(l);
            }
        }
        for (Filter f : this.pad.getFilters()) {
            try {
                txt.setLength(0);
                txt.append("Bad filter definition. Filter name: ").append(f.getFilterName());
                txt.append(". Filter class is invalid: ");
                this.checkValidClass(f.getFilterClass(), PortletFilter.class, txt.toString());
            }
            catch (Exception e) {
                this.pad.removeFilter(f);
            }
        }
        for (FilterMapping fm : this.pad.getFilterMappings()) {
            String fname = fm.getFilterName();
            if (this.pad.getFilter(fname) == null) {
                txt.setLength(0);
                txt.append("Bad filter mapping definition. Filter name: ").append(fm.getFilterName());
                txt.append(", Portlet names: ").append(fm.getPortletNames().toString());
                txt.append(", Filter definition not found: ").append(fname);
                LOG.warn(txt.toString());
                this.pad.removeFilterMapping(fm);
            }
            if (!this.pad.getVersion().equals("2.0")) continue;
            for (String pn : fm.getPortletNames()) {
                if (!this.pad.getMatchingPortlets(pn).isEmpty()) continue;
                txt.setLength(0);
                txt.append("Bad filter mapping definition. Filter name: ").append(fm.getFilterName());
                txt.append(", Portlet names: ").append(fm.getPortletNames().toString());
                txt.append(", Portlet definition not found: ").append(pn);
                LOG.warn(txt.toString());
                this.pad.removeFilterMapping(fm);
            }
        }
        for (PortletDefinition portlet : this.pad.getPortlets()) {
            String sep;
            if (this.pad.getVersion().equals("2.0") || this.pad.getVersion().equals("1.0")) {
                try {
                    this.checkValidClass(portlet.getPortletClass(), Portlet.class, "Bad portlet class: ");
                }
                catch (Exception e) {
                    this.pad.removePortlet(portlet);
                    continue;
                }
            }
            if (portlet.getResourceBundle() != null && portlet.getResourceBundle().length() > 0) {
                try {
                    this.checkValidBundle(portlet.getResourceBundle());
                }
                catch (Exception e) {
                    this.pad.setResourceBundle("");
                }
            }
            Preferences prefs = portlet.getPortletPreferences();
            String clsName = prefs.getPreferencesValidator();
            if (prefs != null && clsName != null) {
                try {
                    this.checkValidClass(clsName, PreferencesValidator.class, "Bad portlet preferences validator class: ");
                }
                catch (Exception e) {
                    prefs.setPreferencesValidator(null);
                    portlet.setPortletPreferences(prefs);
                }
            }
            for (String prp : portlet.getSupportedPublicRenderParameters()) {
                boolean ok = false;
                txt.setLength(0);
                txt.append("Valid PRP identifiers: ");
                sep = "";
                for (PublicRenderParameter prpdef : this.pad.getPublicRenderParameters()) {
                    txt.append(sep).append(prpdef.getIdentifier());
                    sep = ", ";
                    if (!prpdef.getIdentifier().equals(prp)) continue;
                    ok = true;
                }
                if (ok) continue;
                txt.append(". Public render parameter definition not found for: ").append(prp);
                LOG.warn(txt.toString());
                portlet.removeSupportedPublicRenderParameter(prp);
            }
            for (EventDefinitionReference edr : portlet.getSupportedPublishingEvents()) {
                QName qname = edr.getQualifiedName();
                if (this.pad.getEventDefinition(qname) != null) continue;
                txt.setLength(0);
                txt.append("Bad publishing event definition reference. No event definition found for qname: ");
                txt.append(qname);
                txt.append(". Valid QNames: ");
                sep = "";
                for (EventDefinition def : this.pad.getEventDefinitions()) {
                    txt.append(sep).append(def.getQName());
                    sep = ", ";
                }
                LOG.warn(txt.toString());
                portlet.removeSupportedPublishingEvent(edr);
            }
            for (EventDefinitionReference edr : portlet.getSupportedProcessingEvents()) {
                QName qname = edr.getQualifiedName();
                if (this.pad.getEventDefinition(qname) != null) continue;
                txt.setLength(0);
                txt.append("Bad processing event definition reference. No event definition found for qname: ");
                txt.append(qname);
                txt.append(". Valid QNames: ");
                sep = "";
                for (EventDefinition def : this.pad.getEventDefinitions()) {
                    txt.append(sep).append(def.getQName());
                    sep = ", ";
                }
                LOG.warn(txt.toString());
                portlet.removeSupportedProcessingEvent(edr);
            }
        }
    }
}

