/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.driver;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.HeaderRequest;
import javax.portlet.HeaderResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.StateAwareResponse;
import javax.portlet.UnavailableException;
import javax.servlet.DispatcherType;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.container.FilterManager;
import org.apache.pluto.container.PortletAsyncManager;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletInvokerService;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletResourceRequestContext;
import org.apache.pluto.container.PortletResponseContext;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.bean.processor.AnnotatedConfigBean;
import org.apache.pluto.container.bean.processor.PortletArtifactProducer;
import org.apache.pluto.container.bean.processor.PortletInvoker;
import org.apache.pluto.container.bean.processor.PortletRequestScopedBeanHolder;
import org.apache.pluto.container.bean.processor.PortletSessionBeanHolder;
import org.apache.pluto.container.bean.processor.PortletStateScopedBeanHolder;
import org.apache.pluto.container.driver.AdministrativeRequestListener;
import org.apache.pluto.container.driver.DriverPortletConfig;
import org.apache.pluto.container.driver.DriverPortletContext;
import org.apache.pluto.container.driver.PlutoServices;
import org.apache.pluto.container.driver.PortalAdministrationService;
import org.apache.pluto.container.driver.PortletContextService;
import org.apache.pluto.container.driver.PortletInvocationEvent;
import org.apache.pluto.container.driver.PortletInvocationListener;
import org.apache.pluto.container.impl.HttpServletPortletRequestWrapper;
import org.apache.pluto.container.om.portlet.impl.ConfigurationHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletServlet3
extends HttpServlet {
    private static final long serialVersionUID = -5096339022539360365L;
    private static final Logger LOG = LoggerFactory.getLogger(PortletServlet3.class);
    public static final String PORTLET_NAME = "portlet-name";
    private AnnotatedConfigBean acb = null;
    @Inject
    private BeanManager injectedBeanmgr;
    private BeanManager beanmgr = null;
    ConfigurationHolder holder;
    private String portletName;
    private PortletInvoker invoker = null;
    private DriverPortletContext portletContext;
    private DriverPortletConfig portletConfig;
    private boolean isOutOfService = false;
    private PortletContextService contextService;
    private boolean started = false;
    Timer startTimer;

    public String getServletInfo() {
        return "Pluto PortletServlet3 [" + this.portletName + "]";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.portletName = this.getInitParameter(PORTLET_NAME);
        BeanManager ibm = null;
        try {
            InitialContext context = new InitialContext();
            try {
                ibm = (BeanManager)context.lookup("java:comp/BeanManager");
            }
            catch (NameNotFoundException e) {
                try {
                    ibm = (BeanManager)context.lookup("java:comp/env/BeanManager");
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable context) {
            // empty catch block
        }
        if (ibm != null) {
            LOG.debug("BeanManager by JNDI lookup, portlet name: " + this.portletName);
            this.beanmgr = ibm;
        } else {
            LOG.debug("BeanManager by injection, portlet name: " + this.portletName);
            this.beanmgr = this.injectedBeanmgr;
        }
        if (this.beanmgr != null) {
            try {
                Set beans = this.beanmgr.getBeans(AnnotatedConfigBean.class, new Annotation[0]);
                Bean bean = this.beanmgr.resolve(beans);
                this.acb = (AnnotatedConfigBean)this.beanmgr.getReference(bean, (Type)bean.getBeanClass(), this.beanmgr.createCreationalContext((Contextual)bean));
                LOG.debug("ACB instance: " + this.acb + ", RS config: " + (this.acb == null ? "null" : this.acb.getSessionScopedConfig()));
                this.acb.getSessionScopedConfig().activate(this.beanmgr);
                this.acb.getStateScopedConfig().activate(this.beanmgr);
            }
            catch (Throwable t) {
                LOG.debug("Could not retrieve annotated config bean.");
            }
        }
        this.holder = (ConfigurationHolder)config.getServletContext().getAttribute("PortletAppConfig");
        try {
            if (this.holder == null || this.holder.getMethodStore() == null) {
                LOG.error("Could not obtain configuration bean for portlet " + this.portletName + ". Exiting.");
                return;
            }
            this.holder.instantiatePortlets(this.beanmgr);
            this.invoker = new PortletInvoker(this.holder.getMethodStore(), this.portletName);
            LOG.debug("Created the portlet invoker for portlet: " + this.portletName);
        }
        catch (Exception e) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Exception obtaining configuration bean for portlet ");
            txt.append(this.portletName).append(". Exiting. Exception: ");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            txt.append(sw.toString());
            LOG.error(txt.toString());
            this.invoker = null;
            this.portletConfig = null;
            this.isOutOfService = true;
            return;
        }
        this.started = false;
        this.startTimer = new Timer(true);
        final ServletContext servletContext = this.getServletContext();
        final ClassLoader paClassLoader = Thread.currentThread().getContextClassLoader();
        this.startTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ServletContext servletContext2 = servletContext;
                synchronized (servletContext2) {
                    if (PortletServlet3.this.startTimer != null && PortletServlet3.this.attemptRegistration(servletContext, paClassLoader)) {
                        PortletServlet3.this.startTimer.cancel();
                        PortletServlet3.this.startTimer = null;
                    }
                }
            }
        }, 1L, 10000L);
    }

    protected boolean attemptRegistration(ServletContext context, ClassLoader paClassLoader) {
        if (PlutoServices.getServices() != null) {
            this.contextService = PlutoServices.getServices().getPortletContextService();
            try {
                ServletConfig sConfig = this.getServletConfig();
                if (sConfig == null) {
                    String msg = "Problem obtaining servlet configuration(getServletConfig() returns null).";
                    context.log(msg);
                    this.invoker = null;
                    this.portletConfig = null;
                    this.isOutOfService = true;
                    return true;
                }
                String applicationName = this.contextService.register(sConfig);
                this.started = true;
                this.portletContext = this.contextService.getPortletContext(applicationName);
                this.portletConfig = this.contextService.getPortletConfig(applicationName, this.portletName);
            }
            catch (PortletContainerException ex) {
                context.log(ex.getMessage(), (Throwable)ex);
                this.invoker = null;
                this.portletConfig = null;
                this.isOutOfService = true;
                return true;
            }
            try {
                this.invoker.init(this.portletConfig);
                return true;
            }
            catch (Throwable ex) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("Portlet threw exception during initialization and will be taken out of service. Portlet name: ");
                txt.append(this.portletName).append(". Exiting. Exception: ");
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.flush();
                txt.append(sw.toString());
                LOG.error(txt.toString());
                this.invoker = null;
                this.portletConfig = null;
                this.isOutOfService = true;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ServletContext servletContext = this.getServletContext();
        synchronized (servletContext) {
            if (this.startTimer != null) {
                this.startTimer.cancel();
                this.startTimer = null;
            } else if (this.started && this.portletContext != null) {
                this.started = false;
                this.contextService.unregister(this.portletContext);
                if (this.invoker != null) {
                    try {
                        this.invoker.destroy();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.invoker = null;
                }
            }
            super.destroy();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.dispatch(request, response);
    }

    private void dispatch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (LOG.isDebugEnabled()) {
            StringBuilder txt = new StringBuilder();
            txt.append("Processing request.");
            txt.append(" Dispatcher type: ").append(request.getDispatcherType());
            txt.append(", request URI: ").append(request.getRequestURI());
            LOG.debug(txt.toString());
        }
        Integer methodId = (Integer)request.getAttribute("org.apache.pluto.core.method");
        if (this.isOutOfService) {
            LOG.warn("Portlet is out of service. Portlet name: " + this.portletName);
            if (methodId == PortletInvokerService.METHOD_RENDER) {
                PrintWriter writer = response.getWriter();
                writer.write("<p>Out of service.</p>");
            }
            return;
        }
        PortletRequest portletRequest = (PortletRequest)request.getAttribute("javax.portlet.request");
        PortletResponse portletResponse = (PortletResponse)request.getAttribute("javax.portlet.response");
        PortletRequestContext requestContext = (PortletRequestContext)portletRequest.getAttribute(PortletInvokerService.REQUEST_CONTEXT);
        PortletResponseContext responseContext = (PortletResponseContext)portletRequest.getAttribute(PortletInvokerService.RESPONSE_CONTEXT);
        FilterManager filterManager = (FilterManager)request.getAttribute("FilterManager");
        filterManager.setBeanManager(this.beanmgr);
        if (LOG.isTraceEnabled()) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("\nRequest wrapper stack: ");
            HttpServletRequest wreq = request;
            HttpServletRequest tstreq = requestContext.getServletRequest();
            int n = 1;
            while (wreq instanceof ServletRequestWrapper) {
                txt.append("\nLevel ").append(n++).append(": ").append(wreq.getClass().getCanonicalName());
                txt.append(", dispatch type: ").append(wreq.getDispatcherType());
                txt.append(", equal to req context req: ").append(wreq == tstreq);
                wreq = ((ServletRequestWrapper)wreq).getRequest();
            }
            txt.append("\nLevel ").append(n++).append(": ").append(wreq.getClass().getCanonicalName());
            txt.append(", dispatch type: ").append(wreq.getDispatcherType());
            txt.append(", equal to req context req: ").append(wreq == tstreq);
            txt.append("\n\nResponse wrapper stack: ");
            HttpServletResponse wresp = response;
            HttpServletResponse tstresp = requestContext.getServletResponse();
            n = 1;
            while (wresp instanceof ServletResponseWrapper) {
                txt.append("\nLevel ").append(n++).append(": ").append(wresp.getClass().getCanonicalName());
                txt.append(", equal to req context resp: ").append(wresp == tstresp);
                wresp = ((ServletResponseWrapper)wresp).getResponse();
            }
            txt.append("\nLevel ").append(n++).append(": ").append(wresp.getClass().getCanonicalName());
            txt.append(", equal to req context resp: ").append(wresp == tstresp);
            LOG.debug(txt.toString());
        }
        if (request.getDispatcherType() == DispatcherType.ASYNC) {
            HttpServletRequest wreq = request;
            while (wreq instanceof ServletRequestWrapper && !(wreq instanceof HttpServletPortletRequestWrapper)) {
                wreq = ((ServletRequestWrapper)wreq).getRequest();
            }
            if (wreq instanceof HttpServletPortletRequestWrapper) {
                HttpServletRequest hreq = (HttpServletRequest)((HttpServletPortletRequestWrapper)wreq).getRequest();
                HttpServletResponse hresp = requestContext.getServletResponse();
                LOG.debug("Extracted wrapped request. Dispatch type: " + hreq.getDispatcherType());
                requestContext.init(this.portletConfig, this.getServletContext(), hreq, hresp, responseContext);
                requestContext.setAsyncServletRequest(request);
                responseContext.init(hreq, hresp);
            } else {
                LOG.debug("Couldn't find the portlet async wrapper.");
            }
            ((PortletResourceRequestContext)requestContext).getPortletAsyncContext().registerContext(false);
        } else {
            requestContext.init(this.portletConfig, this.getServletContext(), request, response, responseContext);
            requestContext.setExecutingRequestBody(true);
            responseContext.init(request, response);
            this.beforeInvoke(portletRequest, portletResponse, this.portletConfig);
        }
        PortletWindow window = requestContext.getPortletWindow();
        PortletInvocationEvent event = new PortletInvocationEvent(portletRequest, window, methodId);
        this.notify(event, true, null);
        try {
            if (methodId == PortletInvokerService.METHOD_RENDER) {
                RenderRequest renderRequest = (RenderRequest)portletRequest;
                String rh = requestContext.getRenderHeaders();
                if (rh != null) {
                    renderRequest.setAttribute("javax.portlet.render_part", (Object)rh);
                }
                RenderResponse renderResponse = (RenderResponse)portletResponse;
                filterManager.processFilter(renderRequest, renderResponse, (Portlet)this.invoker, (PortletContext)this.portletContext);
            } else if (methodId == PortletInvokerService.METHOD_HEADER) {
                HeaderRequest headerRequest = (HeaderRequest)portletRequest;
                HeaderResponse headerResponse = (HeaderResponse)portletResponse;
                filterManager.processFilter(headerRequest, headerResponse, this.invoker, (PortletContext)this.portletContext);
            } else if (methodId == PortletInvokerService.METHOD_RESOURCE) {
                ResourceRequest resourceRequest = (ResourceRequest)portletRequest;
                PortletResourceRequestContext rc = (PortletResourceRequestContext)requestContext;
                rc.setBeanManager(this.beanmgr);
                ResourceResponse resourceResponse = (ResourceResponse)portletResponse;
                filterManager.processFilter(resourceRequest, resourceResponse, this.invoker, (PortletContext)this.portletContext);
            } else if (methodId == PortletInvokerService.METHOD_ACTION) {
                ActionRequest actionRequest = (ActionRequest)portletRequest;
                ActionResponse actionResponse = (ActionResponse)portletResponse;
                filterManager.processFilter(actionRequest, actionResponse, (Portlet)this.invoker, (PortletContext)this.portletContext);
            } else if (methodId == PortletInvokerService.METHOD_EVENT) {
                EventRequest eventRequest = (EventRequest)portletRequest;
                EventResponse eventResponse = (EventResponse)portletResponse;
                filterManager.processFilter(eventRequest, eventResponse, this.invoker, (PortletContext)this.portletContext);
            } else if (methodId == PortletInvokerService.METHOD_ADMIN) {
                PortalAdministrationService pas = PlutoServices.getServices().getPortalAdministrationService();
                for (AdministrativeRequestListener l : pas.getAdministrativeRequestListeners()) {
                    l.administer(portletRequest, portletResponse);
                }
            } else if (methodId == PortletInvokerService.METHOD_LOAD) {
                // empty if block
            }
            this.notify(event, false, null);
        }
        catch (UnavailableException ex) {
            try {
                this.invoker.destroy();
            }
            catch (Throwable th) {
                this.getServletContext().log("Error during portlet destroy.", th);
            }
            this.isOutOfService = true;
            throw new javax.servlet.UnavailableException(ex.getMessage());
        }
        catch (PortletException ex) {
            this.notify(event, false, ex);
            throw new ServletException((Throwable)ex);
        }
        finally {
            requestContext.setExecutingRequestBody(false);
            if (!request.isAsyncStarted() && request.getDispatcherType() != DispatcherType.ASYNC) {
                LOG.debug("Async not being processed, releasing resources. executing req body: " + requestContext.isExecutingRequestBody());
                request.removeAttribute("org.apache.pluto.core.method");
                request.removeAttribute("javax.portlet.request");
                request.removeAttribute("javax.portlet.response");
                request.removeAttribute("FilterManager");
                this.afterInvoke(portletResponse);
            } else {
                LOG.debug("Async started, not releasing resources. executing req body: " + requestContext.isExecutingRequestBody());
                if (requestContext instanceof PortletResourceRequestContext) {
                    PortletResourceRequestContext resctx = (PortletResourceRequestContext)requestContext;
                    PortletAsyncManager pac = resctx.getPortletAsyncContext();
                    if (pac != null) {
                        pac.deregisterContext(false);
                        pac.launchRunner();
                    } else {
                        LOG.warn("Couldn't get portlet async context.");
                    }
                } else {
                    LOG.warn("Wrong kind of request context: " + requestContext.getClass().getCanonicalName());
                }
            }
        }
    }

    protected void notify(PortletInvocationEvent event, boolean pre, Throwable e) {
        PortalAdministrationService pas = PlutoServices.getServices().getPortalAdministrationService();
        for (PortletInvocationListener listener : pas.getPortletInvocationListeners()) {
            if (pre) {
                listener.onBegin(event);
                continue;
            }
            if (e == null) {
                listener.onEnd(event);
                continue;
            }
            listener.onError(event, e);
        }
    }

    private void beforeInvoke(PortletRequest req, PortletResponse resp, PortletConfig config) {
        if (this.acb != null) {
            PortletRequestScopedBeanHolder.setBeanHolder();
            PortletSessionBeanHolder.setBeanHolder(req, this.acb.getSessionScopedConfig());
            PortletStateScopedBeanHolder.setBeanHolder(req, this.acb.getStateScopedConfig());
            PortletArtifactProducer.setPrecursors(req, resp, config);
            if (LOG.isTraceEnabled()) {
                LOG.trace("CDI context is now set up.");
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("CDI contextual support not available");
        }
    }

    private void afterInvoke(PortletResponse resp) {
        if (this.acb != null) {
            PortletRequestScopedBeanHolder.removeBeanHolder();
            PortletSessionBeanHolder.removeBeanHolder();
            StateAwareResponse sar = null;
            if (resp instanceof StateAwareResponse) {
                sar = (StateAwareResponse)resp;
            }
            PortletStateScopedBeanHolder.removeBeanHolder(sar);
            PortletArtifactProducer.remove();
            if (LOG.isTraceEnabled()) {
                LOG.trace("CDI context is now deactivated.");
            }
        }
    }
}

