/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.ant;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.pluto.util.UtilityException;
import org.apache.pluto.util.assemble.Assembler;
import org.apache.pluto.util.assemble.AssemblerConfig;
import org.apache.pluto.util.assemble.AssemblerFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class AssembleTask
extends Task {
    private File portletxml;
    private File webxml;
    private File destfile;
    private File webapp;
    private File archive;
    private File destdir;
    private final Collection archiveFileSets = new LinkedList();

    public File getPortletxml() {
        if (this.webapp != null) {
            return new File(this.webapp, "WEB-INF/portlet.xml");
        }
        return this.portletxml;
    }

    public void setPortletxml(File portletxml) {
        this.portletxml = portletxml;
    }

    public File getWebxml() {
        if (this.webapp != null) {
            return new File(this.webapp, "WEB-INF/web.xml");
        }
        return this.webxml;
    }

    public void setWebxml(File webxml) {
        this.webxml = webxml;
    }

    public File getDestfile() {
        if (this.destfile != null) {
            return this.destfile;
        }
        return this.getWebxml();
    }

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public File getWebapp() {
        return this.webapp;
    }

    public void setWebapp(File webapp) {
        this.webapp = webapp;
    }

    public File getWar() {
        return this.archive;
    }

    public void setWar(File war) {
        this.archive = war;
    }

    public File getArchive() {
        return this.archive;
    }

    public void setArchive(File archive) {
        this.archive = archive;
    }

    public File getDestdir() {
        if (this.destdir == null) {
            return this.archive != null ? this.archive.getParentFile() : null;
        }
        return this.destdir;
    }

    public void setDestdir(File destDir) {
        this.destdir = destDir;
    }

    public void addWars(FileSet fileSet) {
        this.archiveFileSets.add(fileSet);
    }

    public void addArchives(FileSet fileSet) {
        this.archiveFileSets.add(fileSet);
    }

    public void execute() throws BuildException {
        this.validateArgs();
        try {
            if (this.archiveFileSets.size() > 0) {
                for (FileSet fileSet : this.archiveFileSets) {
                    DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
                    File basedir = directoryScanner.getBasedir();
                    String[] includedFiles = directoryScanner.getIncludedFiles();
                    for (int index = 0; index < includedFiles.length; ++index) {
                        AssemblerConfig config = new AssemblerConfig();
                        File archiveSource = new File(basedir, includedFiles[index]);
                        config.setSource(archiveSource);
                        config.setDestination(this.getDestdir());
                        this.log("Assembling '" + archiveSource + "' to '" + this.getDestdir() + "'");
                        Assembler assembler = AssemblerFactory.getFactory().createAssembler(config);
                        assembler.assemble(config);
                    }
                }
            } else {
                AssemblerConfig config = new AssemblerConfig();
                File archiveSource = this.getArchive();
                if (archiveSource != null) {
                    config.setSource(archiveSource);
                    config.setDestination(this.getDestdir());
                    this.log("Assembling '" + archiveSource + "' to '" + this.getDestdir() + "'");
                } else {
                    config.setPortletDescriptor(this.getPortletxml());
                    config.setWebappDescriptor(this.getWebxml());
                    config.setDestination(this.getDestfile());
                    this.log("Assembling '" + this.getWebxml() + "' to '" + this.getDestfile() + "'");
                }
                Assembler assembler = AssemblerFactory.getFactory().createAssembler(config);
                assembler.assemble(config);
            }
        }
        catch (UtilityException ue) {
            throw new BuildException((Throwable)ue);
        }
    }

    private void validateArgs() throws BuildException {
        if (this.webapp != null) {
            if (!this.webapp.exists()) {
                throw new BuildException("webapp " + this.webapp.getAbsolutePath() + " does not exist");
            }
            if (this.archive != null) {
                throw new BuildException("archive (or war) should not be specified if webapp is specified");
            }
            if (this.archiveFileSets.size() > 0) {
                throw new BuildException("archive (or wars) should not be specified if webapp is specified");
            }
            if (this.destdir != null) {
                throw new BuildException("destfile should not be specified if webapp is specified");
            }
            return;
        }
        if (this.archive != null) {
            if (!this.archive.exists()) {
                throw new BuildException("Archive file " + this.archive.getAbsolutePath() + " does not exist");
            }
            if (this.archiveFileSets.size() > 0) {
                throw new BuildException("archives (or wars) should not be specified if archive (or war) is specified");
            }
            if (this.webapp != null) {
                throw new BuildException("webapp should not be specified if archive (or war) is specified");
            }
            if (this.destfile != null) {
                throw new BuildException("destfile should not be specified if archive (or war) is specified");
            }
            if (this.portletxml != null) {
                throw new BuildException("portletxml should not be specified if archive (or war) is specified");
            }
            if (this.webxml != null) {
                throw new BuildException("webxml should not be specified if archive (or war) is specified");
            }
            return;
        }
        if (this.archiveFileSets.size() > 0) {
            if (this.archive != null) {
                throw new BuildException("archives (or wars) should not be specified if archive (or war) is specified");
            }
            if (this.webapp != null) {
                throw new BuildException("webapp should not be specified if archives (or wars) is specified");
            }
            if (this.destfile != null) {
                throw new BuildException("destfile should not be specified if archives (or wars) is specified");
            }
            if (this.portletxml != null) {
                throw new BuildException("portletxml should not be specified if archive (or wars) is specified");
            }
            if (this.webxml != null) {
                throw new BuildException("webxml should not be specified if archives (or wars) is specified");
            }
            return;
        }
        if (this.portletxml == null || !this.portletxml.exists()) {
            throw new BuildException("portletxml " + this.portletxml + " does not exist");
        }
        if (this.webxml == null || !this.webxml.exists()) {
            throw new BuildException("webxml " + this.webxml + " does not exist");
        }
        if (this.archive != null) {
            throw new BuildException("archive (or war) should not be specified if portletxml and webxml are specified");
        }
        if (this.archiveFileSets.size() > 0) {
            throw new BuildException("archives (or wars) should not be specified if portletxml and webxml are specified");
        }
        if (this.destdir != null) {
            throw new BuildException("destfile should not be specified if portletxml and webxml are aspecified");
        }
    }
}

