/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.webapp.logging;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.webapp.logging.IsolatedLog4JLogger;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RootCategory;

public class Log4JConfigurator
implements ServletContextListener {
    public static final String LOG4J_CONFIG_FILE = "log4j.config.file";
    public static final String LOG4J_CONFIG_FILE_DEFAULT = "/WEB-INF/log4j.properties";
    public static final String LOG4J_CONFIG_WEB_APPLICATION_ROOT_KEY = "log4j.config.webApplicationRoot.key";
    public static final String LOG4J_CONFIG_WEB_APPLICATION_ROOT_KEY_DEFAULT = "webApplicationRoot";
    private Hierarchy isolatedHierarchy;
    private static Log log;

    public void contextInitialized(ServletContextEvent event) {
        String log4JConfigFile = event.getServletContext().getInitParameter(LOG4J_CONFIG_FILE);
        if (log4JConfigFile == null || log4JConfigFile.length() == 0) {
            log4JConfigFile = LOG4J_CONFIG_FILE_DEFAULT;
        }
        String rootPath = event.getServletContext().getRealPath("");
        InputStream input = event.getServletContext().getResourceAsStream(log4JConfigFile);
        if (input != null) {
            try {
                Properties p = new Properties();
                p.load(input);
                String waRootKey = event.getServletContext().getInitParameter(LOG4J_CONFIG_WEB_APPLICATION_ROOT_KEY);
                if (waRootKey == null || waRootKey.length() == 0) {
                    waRootKey = LOG4J_CONFIG_WEB_APPLICATION_ROOT_KEY_DEFAULT;
                }
                p.setProperty(waRootKey, rootPath);
                this.isolatedHierarchy = new Hierarchy((Logger)new RootCategory(Level.INFO));
                new PropertyConfigurator().doConfigure(p, (LoggerRepository)this.isolatedHierarchy);
                IsolatedLog4JLogger.setHierarchy(this.isolatedHierarchy);
                log = LogFactory.getLog(this.getClass());
                log.info((Object)"IsolatedLog4JLogger configured");
            }
            catch (IOException ioe) {
                event.getServletContext().log("Failed to configure Log4J from " + event.getServletContext().getServletContextName(), (Throwable)ioe);
            }
        } else {
            event.getServletContext().log(event.getServletContext().getServletContextName() + " Log4JConfigurator: " + rootPath + log4JConfigFile + " not found.");
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (log != null) {
            log.info((Object)"Shutting down IsolatedLog4JLogger");
            log = null;
        }
        LogFactory.release((ClassLoader)Thread.currentThread().getContextClassLoader());
        if (this.isolatedHierarchy != null) {
            this.isolatedHierarchy.shutdown();
        }
    }
}

