/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.scheduler;

import java.util.List;
import org.apache.jetspeed.scheduler.JobEntry;
import org.apache.jetspeed.scheduler.JobQueue;
import org.apache.jetspeed.scheduler.MemoryBasedScheduler;
import org.apache.jetspeed.scheduler.Scheduler;
import org.apache.jetspeed.scheduler.WorkerThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScheduler
implements Scheduler {
    private static final Logger log = LoggerFactory.getLogger(MemoryBasedScheduler.class);
    protected JobQueue scheduleQueue = null;
    protected MainLoop mainLoop = null;
    protected Thread thread = null;

    public void start() {
    }

    public void stop() {
        if (this.getThread() != null) {
            this.getThread().interrupt();
        }
    }

    public abstract JobEntry getJob(int var1) throws Exception;

    public abstract void addJob(JobEntry var1) throws Exception;

    public abstract void removeJob(JobEntry var1) throws Exception;

    public abstract void updateJob(JobEntry var1) throws Exception;

    public List listJobs() {
        return this.scheduleQueue.list();
    }

    public synchronized Thread getThread() {
        return this.thread;
    }

    private synchronized void clearThread() {
        this.thread = null;
    }

    public synchronized void restart() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this.mainLoop, "scheduler");
            this.thread.setDaemon(true);
            this.thread.start();
        } else {
            this.notify();
        }
    }

    private synchronized JobEntry nextJob() throws Exception {
        try {
            while (!Thread.interrupted()) {
                JobEntry je = this.scheduleQueue.getNext();
                if (je == null) {
                    this.wait();
                    continue;
                }
                long now = System.currentTimeMillis();
                long when = je.getNextRuntime();
                if (when > now) {
                    this.wait(when - now);
                    continue;
                }
                this.scheduleQueue.updateQueue(je);
                return je;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    protected class MainLoop
    implements Runnable {
        protected MainLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                JobEntry je;
                while ((je = AbstractScheduler.this.nextJob()) != null) {
                    WorkerThread wt = new WorkerThread(je);
                    Thread helper = new Thread(wt);
                    helper.start();
                }
            }
            catch (Exception e) {
                log.error("Error running a Scheduled Job: " + e);
            }
            finally {
                AbstractScheduler.this.clearThread();
            }
        }
    }
}

