/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer.objects;

import java.util.HashMap;
import java.util.Map;
import javolution.xml.XMLFormat;
import javolution.xml.sax.Attributes;
import javolution.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringEscapeUtils;

public class JSNameValuePairs {
    private Map<String, String> myMap = new HashMap<String, String>();
    private static final XMLFormat XML = new XMLFormat(JSNameValuePairs.class){

        public void write(Object o, XMLFormat.OutputElement xml) throws XMLStreamException {
            try {
                JSNameValuePairs g = (JSNameValuePairs)o;
                for (String _key : g.myMap.keySet()) {
                    xml.setAttribute(_key, (String)g.myMap.get(_key));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void read(XMLFormat.InputElement xml, Object o) {
            try {
                JSNameValuePairs g = (JSNameValuePairs)o;
                Attributes attribs = xml.getAttributes();
                int len = attribs.getLength();
                for (int i = 0; i < len; ++i) {
                    try {
                        String _key = StringEscapeUtils.unescapeHtml((String)attribs.getLocalName(i).toString());
                        String _value = StringEscapeUtils.unescapeHtml((String)attribs.getValue(i).toString());
                        g.myMap.put(_key, _value);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public int size() {
        return this.myMap.size();
    }

    public Map<String, String> getMyMap() {
        return this.myMap;
    }

    public void add(String key, String value) {
        this.myMap.put(key, value);
    }
}

