/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer.objects;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.jetspeed.serializer.objects.JSNVPElement;

public class JSNVPElements {
    private static final Comparator elementComparator = new Comparator<JSNVPElement>(){

        @Override
        public int compare(JSNVPElement o1, JSNVPElement o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    };
    private Set<JSNVPElement> values;
    private String itemElementName;
    private static final XMLFormat XML = new XMLFormat(JSNVPElements.class){

        public void write(Object o, XMLFormat.OutputElement xml) throws XMLStreamException {
            try {
                JSNVPElements g = (JSNVPElements)o;
                for (JSNVPElement element : g.values) {
                    xml.add((Object)element, g.getItemElementName(), JSNVPElement.class);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void read(XMLFormat.InputElement xml, Object o) {
            try {
                JSNVPElements g = (JSNVPElements)o;
                while (xml.hasNext()) {
                    JSNVPElement elem = (JSNVPElement)xml.getNext();
                    if (elem.getKey() == null) continue;
                    g.add(elem);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public int size() {
        return this.values.size();
    }

    public JSNVPElements() {
        this("preference");
    }

    public JSNVPElements(String itemElementName) {
        this(itemElementName, elementComparator);
    }

    public JSNVPElements(String itemElementName, Comparator<JSNVPElement> comparator) {
        this.values = new TreeSet<JSNVPElement>(comparator);
        this.itemElementName = itemElementName;
    }

    public Set<JSNVPElement> getValues() {
        return this.values;
    }

    public void add(JSNVPElement element) {
        this.values.add(element);
    }

    public String getItemElementName() {
        return this.itemElementName;
    }
}

