/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import org.apache.jetspeed.serializer.JetspeedComponentSerializer;
import org.apache.jetspeed.serializer.JetspeedSerializedData;
import org.apache.jetspeed.serializer.JetspeedSerializer;
import org.apache.jetspeed.serializer.SerializerException;
import org.apache.jetspeed.serializer.objects.JSApplication;
import org.apache.jetspeed.serializer.objects.JSApplications;
import org.apache.jetspeed.serializer.objects.JSCapabilities;
import org.apache.jetspeed.serializer.objects.JSCapability;
import org.apache.jetspeed.serializer.objects.JSClient;
import org.apache.jetspeed.serializer.objects.JSClientCapabilities;
import org.apache.jetspeed.serializer.objects.JSClientMimeTypes;
import org.apache.jetspeed.serializer.objects.JSClients;
import org.apache.jetspeed.serializer.objects.JSEntities;
import org.apache.jetspeed.serializer.objects.JSEntity;
import org.apache.jetspeed.serializer.objects.JSEntityPreference;
import org.apache.jetspeed.serializer.objects.JSEntityPreferenceCompat;
import org.apache.jetspeed.serializer.objects.JSEntityPreferences;
import org.apache.jetspeed.serializer.objects.JSGroup;
import org.apache.jetspeed.serializer.objects.JSGroups;
import org.apache.jetspeed.serializer.objects.JSMediaType;
import org.apache.jetspeed.serializer.objects.JSMediaTypes;
import org.apache.jetspeed.serializer.objects.JSMimeType;
import org.apache.jetspeed.serializer.objects.JSMimeTypes;
import org.apache.jetspeed.serializer.objects.JSNVPElement;
import org.apache.jetspeed.serializer.objects.JSNVPElements;
import org.apache.jetspeed.serializer.objects.JSPWAttributes;
import org.apache.jetspeed.serializer.objects.JSPermission;
import org.apache.jetspeed.serializer.objects.JSPermissions;
import org.apache.jetspeed.serializer.objects.JSPortlet;
import org.apache.jetspeed.serializer.objects.JSPortlets;
import org.apache.jetspeed.serializer.objects.JSPrincipalAssociation;
import org.apache.jetspeed.serializer.objects.JSPrincipalAssociations;
import org.apache.jetspeed.serializer.objects.JSPrincipalRule;
import org.apache.jetspeed.serializer.objects.JSPrincipalRules;
import org.apache.jetspeed.serializer.objects.JSPrincipals;
import org.apache.jetspeed.serializer.objects.JSProfilingRule;
import org.apache.jetspeed.serializer.objects.JSProfilingRules;
import org.apache.jetspeed.serializer.objects.JSRole;
import org.apache.jetspeed.serializer.objects.JSRoles;
import org.apache.jetspeed.serializer.objects.JSRuleCriterion;
import org.apache.jetspeed.serializer.objects.JSRuleCriterions;
import org.apache.jetspeed.serializer.objects.JSSSOSite;
import org.apache.jetspeed.serializer.objects.JSSSOSiteRemoteUser;
import org.apache.jetspeed.serializer.objects.JSSSOSiteRemoteUsers;
import org.apache.jetspeed.serializer.objects.JSSSOSites;
import org.apache.jetspeed.serializer.objects.JSSecurityAttributes;
import org.apache.jetspeed.serializer.objects.JSSecurityDomain;
import org.apache.jetspeed.serializer.objects.JSSecurityDomains;
import org.apache.jetspeed.serializer.objects.JSSnapshot;
import org.apache.jetspeed.serializer.objects.JSUser;
import org.apache.jetspeed.serializer.objects.JSUserAttributes;
import org.apache.jetspeed.serializer.objects.JSUserGroups;
import org.apache.jetspeed.serializer.objects.JSUserRoles;
import org.apache.jetspeed.serializer.objects.JSUserUsers;
import org.apache.jetspeed.serializer.objects.JSUsers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JetspeedSerializerImpl
implements JetspeedSerializer {
    private static final Logger log = LoggerFactory.getLogger(JetspeedSerializerImpl.class);
    private List<JetspeedComponentSerializer> serializers;
    private XMLBinding binding;
    private Map<String, Object> defaultSettings;

    public JetspeedSerializerImpl(List<JetspeedComponentSerializer> serializers, Map<String, Object> defaultSettings) {
        this.serializers = Collections.unmodifiableList(serializers);
        this.defaultSettings = defaultSettings != null ? Collections.unmodifiableMap(defaultSettings) : Collections.EMPTY_MAP;
        this.binding = new XMLBinding();
        this.setupAliases(this.binding);
    }

    public List<JetspeedComponentSerializer> getSerializers() {
        return this.serializers;
    }

    public Map<String, Object> getDefaultSettings() {
        return this.defaultSettings;
    }

    public void importData(String filename) throws SerializerException {
        this.importData(filename, null);
    }

    public void importData(String filename, Map<String, Object> settings) throws SerializerException {
        int i;
        Map<String, Object> processSettings = this.getProcessSettings(settings);
        JSSnapshot snapshot = null;
        SerializerException snapshotException = null;
        for (i = 0; i < TAG_SNAPSHOT_NAMES.length && snapshot == null; ++i) {
            String snapshotTagName = TAG_SNAPSHOT_NAMES[i];
            try {
                snapshot = this.readSnapshot(filename, snapshotTagName);
                continue;
            }
            catch (SerializerException se) {
                if (snapshotException != null) continue;
                snapshotException = se;
            }
        }
        if (snapshotException != null) {
            throw snapshotException;
        }
        if (snapshot == null) {
            throw new SerializerException(SerializerException.FILE_PROCESSING_ERROR.create((Object[])new String[]{filename, "Snapshot is NULL"}));
        }
        if (!snapshot.checkVersion()) {
            throw new SerializerException(SerializerException.INCOMPETIBLE_VERSION.create((Object[])new String[]{filename, String.valueOf(snapshot.getSoftwareVersion()), String.valueOf(snapshot.getSavedSubversion())}));
        }
        int size = this.serializers.size();
        for (i = 0; i < size; ++i) {
            this.serializers.get(i).processImport((JetspeedSerializedData)snapshot, processSettings);
        }
    }

    public void exportData(String name, String filename) throws SerializerException {
        this.exportData(name, filename, null);
    }

    public void exportData(String name, String filename, Map<String, Object> settings) throws SerializerException {
        Map<String, Object> processSettings = this.getProcessSettings(settings);
        JSSnapshot snapshot = new JSSnapshot(name);
        snapshot.setDateCreated(new Date(new java.util.Date().getTime()).toString());
        snapshot.setSavedVersion(snapshot.getSoftwareVersion());
        snapshot.setSavedSubversion(snapshot.getSoftwareSubVersion());
        int size = this.serializers.size();
        for (int i = 0; i < size; ++i) {
            this.serializers.get(i).processExport((JetspeedSerializedData)snapshot, processSettings);
        }
        this.writeSnapshot(snapshot, filename, this.binding, processSettings);
    }

    public void deleteData() throws SerializerException {
        this.deleteData(null);
    }

    public void deleteData(Map<String, Object> settings) throws SerializerException {
        Map<String, Object> processSettings = this.getProcessSettings(settings);
        int size = this.serializers.size();
        for (int i = 0; i < size; ++i) {
            this.serializers.get(i).deleteData(processSettings);
        }
    }

    protected Map<String, Object> getProcessSettings(Map<String, Object> settings) {
        HashMap<String, Object> processSettings = new HashMap<String, Object>(this.defaultSettings);
        processSettings.put("logger", log);
        if (settings != null) {
            processSettings.putAll(settings);
        }
        return processSettings;
    }

    protected void setupAliases(XMLBinding binding) {
        binding.setAlias(JSPrincipals.class, "Principals");
        binding.setAlias(JSPrincipalAssociations.class, "PrincipalAssociations");
        binding.setAlias(JSPrincipalAssociation.class, "PrincipalAssociation");
        binding.setAlias(JSRole.class, "Role");
        binding.setAlias(JSRoles.class, "Roles");
        binding.setAlias(JSGroup.class, "Group");
        binding.setAlias(JSGroups.class, "Groups");
        binding.setAlias(JSUser.class, "User");
        binding.setAlias(JSUsers.class, "Users");
        binding.setAlias(JSSecurityAttributes.class, "SecurityAttributes");
        binding.setAlias(JSUserAttributes.class, "userinfo");
        binding.setAlias(JSNVPElements.class, "preferences");
        binding.setAlias(JSNVPElement.class, "SecurityAttribute");
        binding.setAlias(JSNVPElement.class, "preference");
        binding.setAlias(JSSnapshot.class, "snapshot");
        binding.setAlias(JSUserRoles.class, "roles");
        binding.setAlias(JSUserGroups.class, "groups");
        binding.setAlias(JSClient.class, "Client");
        binding.setAlias(JSClients.class, "Clients");
        binding.setAlias(JSClientCapabilities.class, "capabilities");
        binding.setAlias(JSClientMimeTypes.class, "mimeTypes");
        binding.setAlias(JSMimeTypes.class, "MimeTypes");
        binding.setAlias(JSMimeType.class, "MimeType");
        binding.setAlias(JSCapabilities.class, "Capabilities");
        binding.setAlias(JSCapability.class, "Capability");
        binding.setAlias(JSMediaTypes.class, "MediaTypes");
        binding.setAlias(JSMediaType.class, "MediaType");
        binding.setAlias(JSUserUsers.class, "users");
        binding.setAlias(JSPermissions.class, "Permissions");
        binding.setAlias(JSPermission.class, "Permission");
        binding.setAlias(JSProfilingRules.class, "ProfilingRules");
        binding.setAlias(JSProfilingRule.class, "ProfilingRule");
        binding.setAlias(JSRuleCriterions.class, "Criteria");
        binding.setAlias(JSRuleCriterion.class, "Criterion");
        binding.setAlias(JSPrincipalRule.class, "Rule");
        binding.setAlias(JSPrincipalRules.class, "Rules");
        binding.setAlias(JSPWAttributes.class, "credentials");
        binding.setAlias(JSApplication.class, "PortletApplication");
        binding.setAlias(JSApplications.class, "PortletApplications");
        binding.setAlias(JSPortlet.class, "Portlet");
        binding.setAlias(JSPortlets.class, "Portlets");
        binding.setAlias(JSEntity.class, "Entity");
        binding.setAlias(JSEntities.class, "Entities");
        binding.setAlias(JSEntityPreferenceCompat.class, "Principal");
        binding.setAlias(JSEntityPreference.class, "EntityPreference");
        binding.setAlias(JSEntityPreferences.class, "EntityPreferences");
        binding.setAlias(JSEntityPreferences.class, "Settings");
        binding.setAlias(JSSecurityDomains.class, "SecurityDomains");
        binding.setAlias(JSSecurityDomain.class, "SecurityDomain");
        binding.setAlias(JSSSOSite.class, "Site");
        binding.setAlias(JSSSOSiteRemoteUser.class, "RemoteUser");
        binding.setAlias(JSSSOSiteRemoteUsers.class, "RemoteUsers");
        binding.setAlias(JSSSOSites.class, "SSOSites");
        binding.setAlias(String.class, "String");
        binding.setAlias(Integer.class, "int");
        binding.setClassAttribute(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSSnapshot readSnapshot(String importFileName, String snapshotTagName) throws SerializerException {
        XMLObjectReader reader = null;
        JSSnapshot snap = null;
        try {
            File exists = new File(importFileName);
            reader = exists.exists() ? XMLObjectReader.newInstance((InputStream)new FileInputStream(importFileName)) : XMLObjectReader.newInstance((InputStream)this.getClass().getClassLoader().getResourceAsStream(importFileName));
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.FILE_READER_ERROR.create((Object[])new String[]{importFileName, e.getMessage()}));
        }
        try {
            if (this.binding != null) {
                reader.setBinding(this.binding);
            }
            snap = (JSSnapshot)reader.read(snapshotTagName, JSSnapshot.class);
        }
        catch (Exception e) {
            new SerializerException(SerializerException.FILE_PROCESSING_ERROR.create((Object[])new String[]{importFileName, e.getMessage()}));
        }
        finally {
            try {
                log.debug("*********closing up reader ********");
                reader.close();
            }
            catch (Exception e1) {
                log.debug("Error in closing reader " + e1.getMessage());
                return null;
            }
        }
        return snap;
    }

    protected void writeSnapshot(JSSnapshot snapshot, String filename, XMLBinding binding, Map<String, Object> settings) throws SerializerException {
        Object o;
        XMLObjectWriter writer = this.openWriter(filename, settings);
        writer.setBinding(binding);
        if (settings != null && (o = settings.get("export_indentation")) != null && o instanceof String) {
            writer.setIndentation((String)o);
        }
        try {
            log.debug("*********Writing data*********");
            writer.write((Object)snapshot, "Snapshot", JSSnapshot.class);
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.FILE_PROCESSING_ERROR.create((Object[])new String[]{filename, e.getMessage()}));
        }
        finally {
            try {
                log.debug("*********closing up********");
                writer.close();
            }
            catch (Exception e) {
                log.error("Error in closing writer " + e.getMessage());
            }
        }
    }

    protected XMLObjectWriter openWriter(String filename, Map<String, Object> settings) throws SerializerException {
        File f;
        try {
            f = new File(filename);
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.FILE_PROCESSING_ERROR.create((Object[])new String[]{filename, e.getMessage()}));
        }
        boolean exists = f.exists();
        if (exists) {
            if (!JetspeedSerializerImpl.isSettingSet(settings, "overwrite_existing")) {
                throw new SerializerException(SerializerException.FILE_ALREADY_EXISTS.create((Object)filename));
            }
            if (JetspeedSerializerImpl.isSettingSet(settings, "backup_before_process")) {
                String backName = JetspeedSerializerImpl.createUniqueBackupFilename(f.getParentFile(), f.getName());
                if (backName == null) {
                    throw new SerializerException(SerializerException.FILE_BACKUP_FAILED.create((Object)filename));
                }
                File ftemp = new File(backName);
                f.renameTo(ftemp);
            }
        }
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance((OutputStream)new FileOutputStream(filename));
            return writer;
        }
        catch (Exception e) {
            throw new SerializerException(SerializerException.FILE_WRITER_ERROR.create((Object[])new String[]{filename, e.getMessage()}));
        }
    }

    protected static boolean isSettingSet(Map<String, Object> settings, String key) {
        Object o;
        if (settings != null && (o = settings.get(key)) != null && o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    protected static String createUniqueBackupFilename(File folder, String name) {
        File f = new File(folder, name + ".bak");
        if (!f.exists()) {
            return f.getAbsolutePath();
        }
        for (int counter = 0; counter < 100; ++counter) {
            f = new File(folder, name + ".bak" + counter);
            if (f.exists()) continue;
            return f.getAbsolutePath();
        }
        return null;
    }
}

