/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.ddlutils.DatabaseOperationException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.PlatformFactory;
import org.apache.ddlutils.PlatformUtils;
import org.apache.ddlutils.io.DataReader;
import org.apache.ddlutils.io.DataSink;
import org.apache.ddlutils.io.DataToDatabaseSink;
import org.apache.ddlutils.io.DatabaseIO;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.JdbcTypeCategoryEnum;
import org.apache.ddlutils.model.Table;
import org.apache.jetspeed.serializer.SerializerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JetspeedDDLUtil {
    public static final String DATASOURCE_DATABASENAME = "DATABASENAME".intern();
    public static final String DATASOURCE_CLASS = "DATASOURCE_CLASS".intern();
    public static final String DATASOURCE_DRIVER = "driverClassName".intern();
    public static final String DATASOURCE_URL = "url".intern();
    public static final String DATASOURCE_USERNAME = "username".intern();
    public static final String DATASOURCE_PASSWORD = "password".intern();
    private static final Logger log = LoggerFactory.getLogger(JetspeedDDLUtil.class);
    JdbcTypeCategoryEnum temEnum = null;
    Map parameters;
    PlatformUtils utils;
    StringWriter writer;
    private Platform platform;
    private DataSource dataSource;
    private String _databaseName;
    private Database model;
    private boolean connected = false;

    public void startUp() {
    }

    public void tearDown() {
        if (this.connected) {
            this.platform = null;
        }
    }

    public boolean isDatabaseSupported(String driverName, String jdbcConnectionUrl) {
        return this.utils.determineDatabaseType(driverName, jdbcConnectionUrl) != null;
    }

    public void writeDatabaseSchematoFile(String fileName) {
        new DatabaseIO().write(this.model, fileName);
    }

    protected Database createDatabaseSchemaFromXML(String fileName) {
        DatabaseIO io = new DatabaseIO();
        io.setValidateXml(false);
        return io.read(fileName);
    }

    protected Database createDatabaseSchemaFromString(String dbDef) {
        DatabaseIO dbIO = new DatabaseIO();
        dbIO.setUseInternalDtd(true);
        dbIO.setValidateXml(false);
        return dbIO.read((Reader)new StringReader(dbDef));
    }

    protected Platform connectToDatabase(DataSource dataSource) {
        return PlatformFactory.createNewPlatformInstance((DataSource)dataSource);
    }

    protected Platform connectToDatabase(String databaseType) {
        return PlatformFactory.createNewPlatformInstance((String)databaseType);
    }

    protected void updateDatabaseSchema(Database targetModel, boolean alterDb) throws SerializerException {
        block13: {
            try {
                this.platform.setSqlCommentsOn(false);
                try {
                    targetModel.resetDynaClassCache();
                }
                catch (Exception internalEx) {
                    internalEx.printStackTrace();
                }
                if (alterDb) {
                    this.model.mergeWith(targetModel);
                    try {
                        this.platform.alterTables(this.model, true);
                    }
                    catch (Exception aEX) {
                        System.out.println("Error in ALTER DATABASE");
                        aEX.printStackTrace();
                        log.error("Error in ALTER DATABASE", (Throwable)aEX);
                    }
                    break block13;
                }
                try {
                    if (this.model == null) {
                        this.model = targetModel;
                    }
                    this.platform.dropTables(this.model, true);
                }
                catch (Exception aEX) {
                    log.error("Error in DROP TABLES", (Throwable)aEX);
                }
                try {
                    this.platform.createTables(this.model, false, true);
                    if (this._databaseName.startsWith("oracle")) {
                        this.model = this.readModelFromDatabase(null);
                        this.modifyVarBinaryColumn(this.model, "PA_METADATA_FIELDS", "COLUMN_VALUE");
                        this.modifyVarBinaryColumn(this.model, "PD_METADATA_FIELDS", "COLUMN_VALUE");
                        this.modifyVarBinaryColumn(this.model, "LANGUAGE", "KEYWORDS");
                        this.modifyVarBinaryColumn(this.model, "PORTLET_CONTENT_TYPE", "MODES");
                        this.modifyVarBinaryColumn(this.model, "PARAMETER", "PARAMETER_VALUE");
                        this.modifyVarBinaryColumn(this.model, "LOCALIZED_DESCRIPTION", "DESCRIPTION");
                        this.modifyVarBinaryColumn(this.model, "LOCALIZED_DISPLAY_NAME", "DISPLAY_NAME");
                        this.modifyVarBinaryColumn(this.model, "CUSTOM_PORTLET_MODE", "DESCRIPTION");
                        this.modifyVarBinaryColumn(this.model, "CUSTOM_WINDOW_STATE", "DESCRIPTION");
                        this.modifyVarBinaryColumn(this.model, "MEDIA_TYPE", "DESCRIPTION");
                        this.platform.alterTables(this.model, true);
                    }
                }
                catch (Exception aEX) {
                    aEX.printStackTrace();
                    log.error("Error in CREATE TABLES", (Throwable)aEX);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SerializerException(SerializerException.CREATE_OBJECT_FAILED.create((Object)ex.getLocalizedMessage()));
            }
        }
    }

    private void modifyVarBinaryColumn(Database targetModel, String tableName, String columnName) {
        Table table = targetModel.findTable(tableName);
        Column c = table.findColumn(columnName);
        c.setType("VARCHAR");
        c.setSize("2000");
        System.out.println("updating column " + c.getName() + " for table " + table.getName());
    }

    public void alterDatabase(Database model) throws SerializerException {
        this.updateDatabaseSchema(model, true);
    }

    public void createDatabase(Database model) throws SerializerException {
        this.updateDatabaseSchema(model, false);
    }

    protected Database insertData(Database model, String dataXml) throws DatabaseOperationException {
        try {
            DataReader dataReader = new DataReader();
            dataReader.setModel(model);
            dataReader.setSink((DataSink)new DataToDatabaseSink(this.platform, model));
            dataReader.parse((Reader)new StringReader(dataXml));
            return model;
        }
        catch (Exception ex) {
            throw new DatabaseOperationException((Throwable)ex);
        }
    }

    protected void dropDatabaseTables(Database model) throws DatabaseOperationException {
        this.platform.dropTables(model, true);
    }

    public Database readModelFromDatabase(String databaseName) {
        return this.platform.readModelFromDatabase(databaseName);
    }

    public void init(Map parameters) {
        if (this.connected) {
            this.tearDown();
        }
        try {
            String dataSourceClass = (String)parameters.get(DATASOURCE_CLASS);
            if (dataSourceClass == null) {
                dataSourceClass = BasicDataSource.class.getName();
            }
            this.dataSource = (DataSource)Class.forName(dataSourceClass).newInstance();
            for (Map.Entry entry : parameters.entrySet()) {
                String propName = (String)entry.getKey();
                if (propName.equals(DATASOURCE_CLASS)) continue;
                BeanUtils.setProperty((Object)this.dataSource, (String)propName, entry.getValue());
            }
        }
        catch (Exception ex) {
            throw new DatabaseOperationException((Throwable)ex);
        }
        String databaseName = null;
        this._databaseName = null;
        try {
            databaseName = (String)parameters.get(DATASOURCE_DATABASENAME);
            if (databaseName != null) {
                this.platform = PlatformFactory.createNewPlatformInstance((String)databaseName);
                if (this.platform != null) {
                    this._databaseName = databaseName;
                }
            }
        }
        catch (Exception ex) {
            log.warn("Exception in trying to establish connection to " + databaseName + " : " + ex.getLocalizedMessage(), (Throwable)ex);
        }
        if (this._databaseName == null) {
            this._databaseName = new PlatformUtils().determineDatabaseType(this.dataSource);
            if (this._databaseName == null) {
                throw new DatabaseOperationException("Could not determine platform from datasource, please specify it in the jdbc.properties via the ddlutils.platform property");
            }
            try {
                this.platform = PlatformFactory.createNewPlatformInstance((String)this._databaseName);
            }
            catch (Exception ex) {
                throw new DatabaseOperationException("Could not establish connection to " + this._databaseName + " : " + ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        this.writer = new StringWriter();
        this.platform.getSqlBuilder().setWriter((Writer)this.writer);
        this.platform.setDataSource(this.dataSource);
        System.out.println("reading model...");
        this.model = this.readModelFromDatabase(null);
        System.out.println("done reading model...");
        this.connected = true;
    }

    protected Database getModel() {
        return this.model;
    }

    protected Database insertData(String dataXml) throws DatabaseOperationException {
        try {
            DataReader dataReader = new DataReader();
            dataReader.setModel(this.model);
            dataReader.setSink((DataSink)new DataToDatabaseSink(this.platform, this.model));
            dataReader.parse((Reader)new StringReader(dataXml));
            return this.model;
        }
        catch (Exception ex) {
            throw new DatabaseOperationException((Throwable)ex);
        }
    }

    protected void dropDatabase() throws DatabaseOperationException {
        this.platform.dropTables(this.model, true);
    }

    protected Object getPropertyValue(DynaBean bean, String propName) {
        if (this.platform.isDelimitedIdentifierModeOn()) {
            return bean.get(propName);
        }
        DynaProperty[] props = bean.getDynaClass().getDynaProperties();
        for (int idx = 0; idx < props.length; ++idx) {
            if (!propName.equalsIgnoreCase(props[idx].getName())) continue;
            return bean.get(props[idx].getName());
        }
        throw new IllegalArgumentException("The bean has no property with the name " + propName);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public List getRows(String tableName) {
        Table table = this.getModel().findTable(tableName, this.getPlatform().isDelimitedIdentifierModeOn());
        return this.getPlatform().fetch(this.getModel(), this.getSelectQueryForAllString(table), new Table[]{table});
    }

    public String getSelectQueryForAllString(Table table) {
        StringBuffer query = new StringBuffer();
        query.append("SELECT * FROM ");
        if (this.getPlatform().isDelimitedIdentifierModeOn()) {
            query.append(this.getPlatform().getPlatformInfo().getDelimiterToken());
        }
        query.append(table.getName());
        if (this.getPlatform().isDelimitedIdentifierModeOn()) {
            query.append(this.getPlatform().getPlatformInfo().getDelimiterToken());
        }
        return query.toString();
    }
}

