/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.serializer.objects;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javolution.xml.XMLFormat;
import javolution.xml.sax.Attributes;
import javolution.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSNVPElement {
    private static final String READONLY = "readonly";
    private static final String NULLVALUE = "nullValue";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private String key;
    private String value;
    private String[] values;
    private Map<String, String> attributes = new LinkedHashMap<String, String>();
    private static final XMLFormat XML = new XMLFormat(JSNVPElement.class){

        public boolean isReferencable() {
            return false;
        }

        public void write(Object o, XMLFormat.OutputElement xml) throws XMLStreamException {
            JSNVPElement e = (JSNVPElement)o;
            xml.setAttribute(JSNVPElement.READONLY, e.isReadOnly() ? "true" : "false");
            for (Map.Entry entry : e.attributes.entrySet()) {
                if (((String)entry.getKey()).equals(JSNVPElement.READONLY) || ((String)entry.getKey()).equals(JSNVPElement.NULLVALUE)) continue;
                xml.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
            xml.setAttribute(JSNVPElement.NAME, e.key);
            if (e.isNullValue()) {
                xml.setAttribute(JSNVPElement.NULLVALUE, "true");
            } else if (e.getValue() != null) {
                xml.setAttribute(JSNVPElement.VALUE, e.value);
            } else if (e.values != null) {
                if (e.values.length == 1) {
                    xml.setAttribute(JSNVPElement.VALUE, e.values[0]);
                } else {
                    for (int count = 0; count < e.values.length; ++count) {
                        xml.add((Object)e.values[count], JSNVPElement.VALUE, String.class);
                    }
                }
            }
        }

        public void read(XMLFormat.InputElement xml, Object o) {
            try {
                JSNVPElement g = (JSNVPElement)o;
                Attributes attribs = xml.getAttributes();
                int len = attribs.getLength();
                for (int i = 0; i < len; ++i) {
                    try {
                        String _key = StringEscapeUtils.unescapeHtml((String)attribs.getLocalName(i).toString());
                        String _value = StringEscapeUtils.unescapeHtml((String)attribs.getValue(i).toString());
                        g.setAttribute(_key, _value);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                g.key = g.getAttributes().get(JSNVPElement.NAME);
                if (g.key == null) {
                    g.key = StringEscapeUtils.unescapeHtml((String)((String)xml.get(JSNVPElement.NAME, String.class)));
                }
                if (g.key != null && !g.isNullValue()) {
                    g.value = g.getAttributes().get(JSNVPElement.VALUE);
                    if (g.value == null) {
                        ArrayList<String> strings = new ArrayList<String>();
                        while (xml.hasNext()) {
                            strings.add(StringEscapeUtils.unescapeHtml((String)((String)xml.get(JSNVPElement.VALUE, String.class))));
                        }
                        if (strings.size() > 1) {
                            JSNVPElement.access$302(g, strings.toArray(new String[strings.size()]));
                        } else {
                            g.value = (String)strings.get(0);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public JSNVPElement() {
    }

    public JSNVPElement(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public String[] getValues() {
        return this.values;
    }

    public void setValue(String value) {
        this.value = value;
        this.values = null;
        this.setNullValue(value == null);
    }

    public void setValues(String[] values) {
        this.value = null;
        this.values = values;
        this.setNullValue(values == null);
    }

    public boolean isReadOnly() {
        return this.attributes.get(READONLY) != null;
    }

    public void setReadOnly(boolean isReadOnly) {
        if (isReadOnly) {
            this.attributes.put(READONLY, "true");
        } else {
            this.attributes.remove(READONLY);
        }
    }

    public boolean isNullValue() {
        return this.attributes.get(NULLVALUE) != null;
    }

    public void setNullValue(boolean isNullValue) {
        if (isNullValue) {
            this.attributes.put(NULLVALUE, "true");
        } else {
            this.attributes.remove(NULLVALUE);
        }
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, String value) {
        if (key != null && value != null && key.trim().length() > 0 && value.trim().length() > 0) {
            if (READONLY.equals(key)) {
                this.setReadOnly(Boolean.parseBoolean(value));
            } else if (NULLVALUE.equals(key)) {
                this.setNullValue(Boolean.parseBoolean(value));
            } else {
                this.attributes.put(key, value);
            }
        }
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    static /* synthetic */ String[] access$302(JSNVPElement x0, String[] x1) {
        x0.values = x1;
        return x1;
    }
}

