/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl.cache;

import java.io.Serializable;
import org.apache.jetspeed.cache.CacheElement;
import org.apache.jetspeed.cache.DistributedCacheObject;
import org.apache.jetspeed.cache.JetspeedCache;
import org.apache.jetspeed.cache.JetspeedCacheEventAdapter;
import org.apache.jetspeed.cache.JetspeedCacheEventListener;
import org.apache.jetspeed.cache.impl.EhCacheDistributedElementImpl;
import org.apache.jetspeed.cache.impl.EhCacheDistributedImpl;
import org.apache.jetspeed.security.spi.impl.cache.JSPMCache;
import org.apache.jetspeed.security.spi.impl.cache.JSPMQueryEhCacheElementImpl;
import org.apache.jetspeed.security.spi.impl.cache.JSPMQueryEhCacheImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSPMCacheImpl
implements JSPMCache {
    private static final Logger log = LoggerFactory.getLogger(JSPMCacheImpl.class);
    private EhCacheDistributedImpl principalCache;
    private EhCacheDistributedImpl permissionCache;
    private EhCacheDistributedImpl domainCache;
    private JetspeedCacheEventListener principalCacheListener;
    private JetspeedCacheEventListener permissionCacheListener;
    private JetspeedCacheEventListener domainCacheListener;
    private JSPMQueryEhCacheImpl principalQueryCache;
    private JSPMQueryEhCacheImpl associationQueryCache;
    private JSPMQueryEhCacheImpl passwordCredentialQueryCache;
    private JSPMQueryEhCacheImpl permissionQueryCache;
    private JSPMQueryEhCacheImpl domainQueryCache;

    public JSPMCacheImpl(EhCacheDistributedImpl principalCache, EhCacheDistributedImpl permissionCache, EhCacheDistributedImpl domainCache, JSPMQueryEhCacheImpl principalQueryCache, JSPMQueryEhCacheImpl associationQueryCache, JSPMQueryEhCacheImpl passwordCredentialQueryCache, JSPMQueryEhCacheImpl permissionQueryCache, JSPMQueryEhCacheImpl domainQueryCache) {
        this.principalCache = principalCache;
        this.permissionCache = permissionCache;
        this.domainCache = domainCache;
        this.principalQueryCache = principalQueryCache;
        this.associationQueryCache = associationQueryCache;
        this.passwordCredentialQueryCache = passwordCredentialQueryCache;
        this.permissionQueryCache = permissionQueryCache;
        this.domainQueryCache = domainQueryCache;
    }

    public void initialize() {
        this.principalCacheListener = new JetspeedCacheEventAdapter(){

            public void notifyElementRemoved(JetspeedCache cache, boolean local, Object key, Object element) {
                if (key instanceof Long) {
                    long principalId = (Long)key;
                    JSPMCacheImpl.this.principalQueryCache.evictPrincipal(principalId);
                    JSPMCacheImpl.this.associationQueryCache.evictPrincipal(principalId);
                    JSPMCacheImpl.this.passwordCredentialQueryCache.evictPrincipal(principalId);
                    JSPMCacheImpl.this.permissionQueryCache.evictPrincipal(principalId);
                }
            }
        };
        this.principalCache.addEventListener(this.principalCacheListener, false);
        this.permissionCacheListener = new JetspeedCacheEventAdapter(){

            public void notifyElementRemoved(JetspeedCache cache, boolean local, Object key, Object element) {
                if (key instanceof Long) {
                    long permissionId = (Long)key;
                    JSPMCacheImpl.this.principalQueryCache.evictPermission(permissionId);
                    JSPMCacheImpl.this.permissionQueryCache.evictPermission(permissionId);
                }
            }
        };
        this.permissionCache.addEventListener(this.permissionCacheListener, false);
        this.domainCacheListener = new JetspeedCacheEventAdapter(){

            public void notifyElementRemoved(JetspeedCache cache, boolean local, Object key, Object element) {
                if (key instanceof Long) {
                    long domainId = (Long)key;
                    JSPMCacheImpl.this.principalQueryCache.evictDomain(domainId);
                    JSPMCacheImpl.this.associationQueryCache.evictDomain(domainId);
                    JSPMCacheImpl.this.passwordCredentialQueryCache.evictDomain(domainId);
                    JSPMCacheImpl.this.domainQueryCache.evictDomain(domainId);
                }
            }
        };
        this.domainCache.addEventListener(this.domainCacheListener, false);
    }

    public void terminate() {
        this.principalCache.removeEventListener(this.principalCacheListener, false);
        this.principalCache.removeEventListener(this.principalCacheListener, true);
        this.permissionCache.removeEventListener(this.permissionCacheListener, false);
        this.permissionCache.removeEventListener(this.permissionCacheListener, true);
        this.domainCache.removeEventListener(this.domainCacheListener, false);
        this.domainCache.removeEventListener(this.domainCacheListener, true);
        this.clear();
    }

    @Override
    public Object getPrincipal(Long id) {
        EhCacheDistributedElementImpl cacheElementImpl = (EhCacheDistributedElementImpl)this.principalCache.get((Serializable)id);
        return cacheElementImpl != null ? cacheElementImpl.getContent() : null;
    }

    @Override
    public void putPrincipal(Long id, Object principal) {
        this.principalCache.put((CacheElement)new EhCacheDistributedElementImpl((Serializable)id, (DistributedCacheObject)principal));
    }

    @Override
    public void evictPrincipal(Long id) {
        JSPMCacheImpl.evictFromDistributedCache(this.principalCache, id);
    }

    @Override
    public Object getPermission(Long id) {
        EhCacheDistributedElementImpl cacheElementImpl = (EhCacheDistributedElementImpl)this.permissionCache.get((Serializable)id);
        return cacheElementImpl != null ? cacheElementImpl.getContent() : null;
    }

    @Override
    public void putPermission(Long id, Object permission) {
        this.permissionCache.put((CacheElement)new EhCacheDistributedElementImpl((Serializable)id, (DistributedCacheObject)permission));
    }

    @Override
    public void evictPermission(Long id) {
        JSPMCacheImpl.evictFromDistributedCache(this.permissionCache, id);
    }

    @Override
    public Object getDomain(Long id) {
        EhCacheDistributedElementImpl cacheElementImpl = (EhCacheDistributedElementImpl)this.domainCache.get((Serializable)id);
        return cacheElementImpl != null ? cacheElementImpl.getContent() : null;
    }

    @Override
    public void putDomain(Long id, Object domain) {
        this.domainCache.put((CacheElement)new EhCacheDistributedElementImpl((Serializable)id, (DistributedCacheObject)domain));
    }

    @Override
    public void evictDomain(Long id) {
        JSPMCacheImpl.evictFromDistributedCache(this.domainCache, id);
    }

    @Override
    public Object getPrincipalQuery(String key) {
        JSPMQueryEhCacheElementImpl cacheElementImpl = (JSPMQueryEhCacheElementImpl)this.principalQueryCache.get(key);
        return cacheElementImpl != null ? cacheElementImpl.getImplElement().getObjectValue() : null;
    }

    @Override
    public void putPrincipalQuery(String key, Long principalId, Long permissionId, Long domainId, Object query) {
        this.principalQueryCache.put((CacheElement)JSPMCacheImpl.newJSPMQueryEhCacheElementImpl(key, principalId, null, permissionId, domainId, null, query));
    }

    @Override
    public Object getAssociationQuery(String key) {
        JSPMQueryEhCacheElementImpl cacheElementImpl = (JSPMQueryEhCacheElementImpl)this.associationQueryCache.get(key);
        return cacheElementImpl != null ? cacheElementImpl.getImplElement().getObjectValue() : null;
    }

    @Override
    public void putAssociationQuery(String key, Long principalId, Long[] otherPrincipalIds, Long domainId, Long otherDomainId, Object query) {
        this.associationQueryCache.put((CacheElement)JSPMCacheImpl.newJSPMQueryEhCacheElementImpl(key, principalId, otherPrincipalIds, null, domainId, otherDomainId, query));
    }

    @Override
    public Object getPasswordCredentialQuery(String key) {
        JSPMQueryEhCacheElementImpl cacheElementImpl = (JSPMQueryEhCacheElementImpl)this.passwordCredentialQueryCache.get(key);
        return cacheElementImpl != null ? cacheElementImpl.getImplElement().getObjectValue() : null;
    }

    @Override
    public void putPasswordCredentialQuery(String key, Long principalId, Long domainId, Object query) {
        this.passwordCredentialQueryCache.put((CacheElement)JSPMCacheImpl.newJSPMQueryEhCacheElementImpl(key, principalId, null, null, domainId, null, query));
    }

    @Override
    public Object getPermissionQuery(String key) {
        JSPMQueryEhCacheElementImpl cacheElementImpl = (JSPMQueryEhCacheElementImpl)this.permissionQueryCache.get(key);
        return cacheElementImpl != null ? cacheElementImpl.getImplElement().getObjectValue() : null;
    }

    @Override
    public void putPermissionQuery(String key, Long principalId, Long[] otherPrincipalIds, Long permissionId, Long domainId, Object query) {
        this.permissionQueryCache.put((CacheElement)JSPMCacheImpl.newJSPMQueryEhCacheElementImpl(key, principalId, otherPrincipalIds, permissionId, domainId, null, query));
    }

    @Override
    public Object getDomainQuery(String key) {
        JSPMQueryEhCacheElementImpl cacheElementImpl = (JSPMQueryEhCacheElementImpl)this.domainQueryCache.get(key);
        return cacheElementImpl != null ? cacheElementImpl.getImplElement().getObjectValue() : null;
    }

    @Override
    public void putDomainQuery(String key, Long domainId, Object query) {
        this.domainQueryCache.put((CacheElement)JSPMCacheImpl.newJSPMQueryEhCacheElementImpl(key, null, null, null, domainId, null, query));
    }

    @Override
    public int size() {
        int size = 0;
        size += this.principalCache.getSize();
        size += this.permissionCache.getSize();
        size += this.domainCache.getSize();
        size += this.principalQueryCache.getSize();
        size += this.associationQueryCache.getSize();
        size += this.passwordCredentialQueryCache.getSize();
        size += this.permissionQueryCache.getSize();
        return size += this.domainQueryCache.getSize();
    }

    @Override
    public void clear() {
        this.principalCache.clear();
        this.permissionCache.clear();
        this.domainCache.clear();
        this.principalQueryCache.clear();
        this.associationQueryCache.clear();
        this.passwordCredentialQueryCache.clear();
        this.permissionQueryCache.clear();
        this.domainQueryCache.clear();
    }

    @Override
    public boolean isDistributed() {
        return this.principalCache.isDistributed() && this.permissionCache.isDistributed() && this.domainCache.isDistributed();
    }

    private static JSPMQueryEhCacheElementImpl newJSPMQueryEhCacheElementImpl(String key, Long principalId, Long[] otherPrincipalIds, Long permissionId, Long domainId, Long otherDomainId, Object element) {
        JSPMQueryEhCacheElementImpl cacheElementImpl = new JSPMQueryEhCacheElementImpl((Serializable)((Object)key), element);
        if (principalId != null) {
            if (otherPrincipalIds != null && otherPrincipalIds.length > 0) {
                long[] principalIds = new long[otherPrincipalIds.length + 1];
                principalIds[0] = principalId;
                int limit = otherPrincipalIds.length;
                for (int i = 0; i < limit; ++i) {
                    principalIds[i + 1] = otherPrincipalIds[i];
                }
                cacheElementImpl.setPrincipalIds(principalIds);
            } else {
                cacheElementImpl.setPrincipalIds(new long[]{principalId});
            }
        } else if (otherPrincipalIds != null && otherPrincipalIds.length > 0) {
            long[] principalIds = new long[otherPrincipalIds.length];
            int limit = otherPrincipalIds.length;
            for (int i = 0; i < limit; ++i) {
                principalIds[i] = otherPrincipalIds[i];
            }
            cacheElementImpl.setPrincipalIds(principalIds);
        }
        if (permissionId != null) {
            cacheElementImpl.setPermissionIds(new long[]{permissionId});
        }
        if (domainId != null) {
            if (otherDomainId != null) {
                cacheElementImpl.setDomainIds(new long[]{domainId, otherDomainId});
            } else {
                cacheElementImpl.setDomainIds(new long[]{domainId});
            }
        } else if (otherDomainId != null) {
            cacheElementImpl.setDomainIds(new long[]{otherDomainId});
        }
        return cacheElementImpl;
    }

    private static void evictFromDistributedCache(EhCacheDistributedImpl cache, Long id) {
        if (!cache.remove((Serializable)id)) {
            cache.put((CacheElement)new EhCacheDistributedElementImpl((Serializable)id, (DistributedCacheObject)CACHE_NULL));
            cache.remove((Serializable)id);
        }
    }
}

