/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.security.JetspeedPermission;
import org.apache.jetspeed.security.spi.PersistentJetspeedPermission;
import org.apache.jetspeed.security.spi.impl.PersistentJetspeedPermissionImpl;

public abstract class BaseJetspeedPermission
extends Permission
implements JetspeedPermission {
    protected final int mask;
    private final PersistentJetspeedPermission permission;

    public BaseJetspeedPermission(String type, String name, int mask) {
        super(name);
        this.permission = new PersistentJetspeedPermissionImpl(type, name);
        this.mask = mask;
    }

    public BaseJetspeedPermission(String type, String name, String actions) {
        super(name);
        this.permission = new PersistentJetspeedPermissionImpl(type, name);
        this.mask = JetspeedActions.getContainerActionsMask((String)actions);
    }

    public BaseJetspeedPermission(PersistentJetspeedPermission permission) {
        super(permission.getName());
        this.permission = permission;
        this.mask = JetspeedActions.getContainerActionsMask((String)permission.getActions());
    }

    public PersistentJetspeedPermission getPermission() {
        this.getActions();
        return this.permission;
    }

    public String getType() {
        return this.permission.getType();
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode() ^ this.mask;
    }

    @Override
    public String getActions() {
        if (this.permission.getActions() == null) {
            this.permission.setActions(JetspeedActions.getContainerActions((int)this.mask));
        }
        return this.permission.getActions();
    }

    @Override
    public boolean implies(Permission permission) {
        throw new IllegalStateException("Permission class did not implement implies");
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new JetspeedPermissionCollection();
    }

    private static class JetspeedPermissionCollection
    extends PermissionCollection {
        private static final long serialVersionUID = -3852518088847803886L;
        private ArrayList<Permission> permissions = new ArrayList();

        private JetspeedPermissionCollection() {
        }

        @Override
        public void add(Permission permission) {
            if (!this.permissions.contains(permission)) {
                this.permissions.add(permission);
            }
        }

        @Override
        public Enumeration<Permission> elements() {
            return Collections.enumeration(this.permissions);
        }

        @Override
        public boolean implies(Permission permission) {
            for (Permission p : this.permissions) {
                if (!p.implies(permission)) continue;
                return true;
            }
            return false;
        }
    }
}

