/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.jetspeed.security.AlgorithmUpgradePasswordEncodingService;
import org.apache.jetspeed.security.CredentialPasswordEncoder;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.spi.AlgorithmUpgradeCredentialPasswordEncoder;
import org.apache.jetspeed.security.spi.impl.PBEPasswordService;

public class AlgorithmUpgradePBEPasswordService
extends PBEPasswordService
implements AlgorithmUpgradeCredentialPasswordEncoder,
AlgorithmUpgradePasswordEncodingService {
    private CredentialPasswordEncoder oldEncoder;
    private Timestamp startPBEPasswordEncoding;

    public AlgorithmUpgradePBEPasswordService(String pbePassword, CredentialPasswordEncoder oldEncoder, String startPBEPasswordEncoding) throws InvalidKeySpecException, NoSuchAlgorithmException, ParseException {
        super(pbePassword);
        this.oldEncoder = oldEncoder;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.startPBEPasswordEncoding = new Timestamp(df.parse(startPBEPasswordEncoding).getTime());
    }

    @Override
    public boolean usesOldEncodingAlgorithm(PasswordCredential credential) {
        return this.usesOldEncodingAlgorithm(credential.isEnabled(), credential.getLastAuthenticationDate(), credential.getPreviousAuthenticationDate());
    }

    @Override
    public String encode(PasswordCredential credential, String clearTextPassword) throws SecurityException {
        if (this.usesOldEncodingAlgorithm(credential.isEnabled(), credential.getLastAuthenticationDate(), credential.getPreviousAuthenticationDate())) {
            return this.oldEncoder.encode(credential.getUserName(), clearTextPassword);
        }
        return this.encode(credential.getUserName(), clearTextPassword);
    }

    @Override
    public void recodeIfNeeded(PasswordCredential credential, String clearTextPassword) throws SecurityException {
        if (this.usesOldEncodingAlgorithm(credential.isEnabled(), credential.getLastAuthenticationDate(), credential.getPreviousAuthenticationDate())) {
            credential.setPassword(this.encode(credential.getUserName(), clearTextPassword), true);
        }
    }

    private boolean usesOldEncodingAlgorithm(boolean encoded, Timestamp lastAuthDate, Timestamp prevAuthDate) {
        if (encoded) {
            if (lastAuthDate != null) {
                return lastAuthDate.before(this.startPBEPasswordEncoding);
            }
            if (prevAuthDate != null) {
                return prevAuthDate.before(this.startPBEPasswordEncoding);
            }
            return true;
        }
        return false;
    }
}

