/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl.ext;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.security.auth.Subject;
import org.apache.jetspeed.security.AuthenticatedUser;
import org.apache.jetspeed.security.AuthenticationProvider;
import org.apache.jetspeed.security.Role;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.UserSubjectPrincipal;
import org.apache.jetspeed.security.impl.DefaultLoginModule;
import org.apache.jetspeed.security.impl.RoleImpl;

public class JBossLoginModule
extends DefaultLoginModule {
    public JBossLoginModule() {
    }

    protected JBossLoginModule(AuthenticationProvider authProvider, UserManager userManager) {
        super(authProvider, userManager);
    }

    public JBossLoginModule(AuthenticationProvider authProvider, UserManager userManager, String portalUserRole) {
        super(authProvider, userManager, portalUserRole);
    }

    @Override
    protected void commitSubject(Subject containerSubject, Subject jetspeedSubject, AuthenticatedUser user) {
        Principal userSubjectPrincipal = SubjectHelper.getPrincipal((Subject)jetspeedSubject, UserSubjectPrincipal.class);
        this.subject.getPrincipals().add(userSubjectPrincipal);
        boolean hasPortalUserRole = false;
        JBossGroup roles = new JBossGroup("Roles");
        for (Principal role : SubjectHelper.getPrincipals((Subject)jetspeedSubject, Role.class)) {
            roles.addMember(role);
            if (!role.getName().equals(this.portalUserRole)) continue;
            hasPortalUserRole = true;
        }
        if (!hasPortalUserRole) {
            roles.addMember((Principal)((Object)new RoleImpl(this.portalUserRole)));
        }
        this.subject.getPrincipals().add((Principal)((Object)roles));
    }

    private static class JBossGroup
    implements Group {
        private String name;
        private ArrayList<Principal> members = new ArrayList();

        public JBossGroup(String name) {
            this.name = name;
        }

        public boolean addMember(Principal user) {
            if (!this.isMember(user)) {
                this.members.add(user);
                return true;
            }
            return false;
        }

        public boolean isMember(Principal member) {
            return this.members.contains(member);
        }

        public boolean removeMember(Principal user) {
            return this.members.remove(user);
        }

        public Enumeration<Principal> members() {
            return Collections.enumeration(this.members);
        }

        public String getName() {
            return this.name;
        }
    }
}

