/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.List;
import org.apache.jetspeed.security.PermissionManager;
import org.apache.jetspeed.security.SecurityPolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbmsPolicy
extends Policy {
    private static final Logger log = LoggerFactory.getLogger(RdbmsPolicy.class);
    private PermissionManager pms = null;

    public RdbmsPolicy(PermissionManager pms) {
        if (log.isDebugEnabled()) {
            log.debug("RdbmsPolicy constructed.");
        }
        this.pms = pms;
    }

    @Override
    public void refresh() {
    }

    @Override
    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        Principal[] principals = protectionDomain.getPrincipals();
        Permissions perms = new Permissions();
        boolean permImplied = false;
        if (null != principals && principals.length > 0) {
            if (permission.getClass().getName().startsWith("java")) {
                ((PermissionCollection)perms).add(new AllPermission());
            } else {
                perms = this.pms.getPermissions(principals);
            }
        } else {
            ((PermissionCollection)perms).add(new AllPermission());
        }
        if (null != perms) {
            permImplied = ((PermissionCollection)perms).implies(permission);
        }
        return permImplied;
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        PermissionCollection otherPerms = new Permissions();
        if (null != domain) {
            otherPerms = this.getPermissions(domain.getCodeSource());
        }
        return otherPerms;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection otherPerms = this.getOtherPoliciesPermissions(codeSource);
        return otherPerms;
    }

    private PermissionCollection getOtherPoliciesPermissions(CodeSource codeSource) {
        log.debug("CodeSource: " + codeSource.getLocation().getPath());
        List securityPolicies = SecurityPolicies.getInstance().getUsedPolicies();
        Permissions otherPerms = new Permissions();
        for (int i = 0; i < securityPolicies.size(); ++i) {
            Policy currPolicy = (Policy)securityPolicies.get(i);
            if (currPolicy.getClass().equals(this.getClass())) continue;
            if (log.isDebugEnabled()) {
                log.debug("Checking policy: " + currPolicy.getClass().getName());
            }
            PermissionCollection currPerms = currPolicy.getPermissions(codeSource);
            RdbmsPolicy.addPermissions(otherPerms, currPerms);
        }
        return otherPerms;
    }

    private static void addPermissions(PermissionCollection perms, PermissionCollection permsToAdd) {
        int permsAdded = 0;
        if (null != permsToAdd) {
            Enumeration<Permission> permsToAddEnum = permsToAdd.elements();
            while (permsToAddEnum.hasMoreElements()) {
                ++permsAdded;
                Permission currPerm = permsToAddEnum.nextElement();
                perms.add(currPerm);
                if (!log.isDebugEnabled()) continue;
                log.debug("Adding the permission: [class, " + currPerm.getClass().getName() + "], " + "[name, " + currPerm.getName() + "], " + "[actions, " + currPerm.getActions() + "]");
            }
        }
        if (permsAdded == 0 && log.isDebugEnabled()) {
            log.debug("No permissions to add...");
        }
    }
}

