/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.security.Permission;
import org.apache.jetspeed.security.spi.PersistentJetspeedPermission;
import org.apache.jetspeed.security.spi.impl.BaseJetspeedPermission;
import org.apache.jetspeed.security.spi.impl.FolderPermission;
import org.apache.jetspeed.security.spi.impl.JetspeedPermissionFactory;

public class FragmentPermission
extends BaseJetspeedPermission {
    private static final long serialVersionUID = -7577936466248811111L;

    protected FragmentPermission(PersistentJetspeedPermission permission) {
        super(permission);
    }

    protected FragmentPermission(String type, String name, int mask) {
        super(type, name, mask);
    }

    protected FragmentPermission(String type, String name, String actions) {
        super(type, name, actions);
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof FragmentPermission)) {
            return false;
        }
        FragmentPermission fragmentPerm = (FragmentPermission)permission;
        String ruleName = this.getName();
        if (!ruleName.equals("<<ALL FRAGMENTS>>")) {
            String testName = fragmentPerm.getName();
            int testNamesSeparator = testName.lastIndexOf("::");
            if (ruleName.endsWith("::" + FolderPermission.WILD_CHAR_STR) && testNamesSeparator > 0) {
                ruleName = ruleName.substring(0, ruleName.length() - 3);
                testName = testName.substring(0, testNamesSeparator);
            }
            if (!ruleName.startsWith(FolderPermission.FOLDER_SEPARATOR_STR) && testName.startsWith(FolderPermission.FOLDER_SEPARATOR_STR)) {
                int testPathIndex = testName.lastIndexOf(47);
                testName = testName.substring(testPathIndex + 1);
            }
            if (!ruleName.equals(testName)) {
                return false;
            }
        }
        return (this.mask & fragmentPerm.mask) == fragmentPerm.mask;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FragmentPermission)) {
            return false;
        }
        FragmentPermission p = (FragmentPermission)object;
        return p.mask == this.mask && p.getName().equals(this.getName());
    }

    public static class Factory
    extends JetspeedPermissionFactory {
        public Factory() {
            super("fragment");
        }

        @Override
        public FragmentPermission newPermission(String name, String actions) {
            return new FragmentPermission(this.getType(), name, actions);
        }

        @Override
        public FragmentPermission newPermission(String name, int mask) {
            return new FragmentPermission(this.getType(), name, mask);
        }

        @Override
        public FragmentPermission newPermission(PersistentJetspeedPermission permission) {
            if (permission.getType().equals(this.getType())) {
                return new FragmentPermission(permission);
            }
            throw new IllegalArgumentException("Permission is not of type " + this.getType());
        }
    }
}

