/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Base64;
import org.apache.jetspeed.security.CredentialPasswordEncoder;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.util.UnixCrypt;

public class LdapCredentialPasswordEncoder
implements CredentialPasswordEncoder {
    private static final long serialVersionUID = -575380709827140201L;
    private final HashMethod hashMethod;
    private final MessageDigest digester;
    private final boolean saltedDigest;

    public LdapCredentialPasswordEncoder(String hashMethod) throws NoSuchAlgorithmException {
        if (HashMethod.CRYPT.toString().equals(hashMethod)) {
            this.hashMethod = HashMethod.CRYPT;
            this.digester = null;
            this.saltedDigest = false;
        } else if (HashMethod.SHA.toString().equals(hashMethod)) {
            this.hashMethod = HashMethod.SHA;
            this.digester = MessageDigest.getInstance("SHA");
            this.saltedDigest = false;
        } else if (HashMethod.SSHA.toString().equals(hashMethod)) {
            this.hashMethod = HashMethod.SSHA;
            this.digester = MessageDigest.getInstance("SHA");
            this.saltedDigest = true;
        } else if (HashMethod.MD5.toString().equals(hashMethod)) {
            this.hashMethod = HashMethod.MD5;
            this.digester = MessageDigest.getInstance("MD5");
            this.saltedDigest = false;
        } else if (HashMethod.SMD5.toString().equals(hashMethod)) {
            this.hashMethod = HashMethod.SMD5;
            this.digester = MessageDigest.getInstance("MD5");
            this.saltedDigest = true;
        } else {
            throw new IllegalArgumentException("Unsupported hashMethod " + hashMethod);
        }
    }

    public String encode(String userName, String clearTextPassword) throws SecurityException {
        StringBuffer sb = new StringBuffer().append('{').append((Object)this.hashMethod).append('}');
        if (this.hashMethod == HashMethod.CRYPT) {
            byte[] salt = new byte[2];
            SecureRandom sr = new SecureRandom();
            int i1 = sr.nextInt(64);
            int i2 = sr.nextInt(64);
            salt[0] = (byte)(i1 < 12 ? i1 + 46 : (i1 < 38 ? i1 + 65 - 12 : i1 + 97 - 38));
            salt[1] = (byte)(i2 < 12 ? i2 + 46 : (i2 < 38 ? i2 + 65 - 12 : i2 + 97 - 38));
            String saltString = LdapCredentialPasswordEncoder.utf8decode(salt);
            sb.append(saltString).append(UnixCrypt.crypt(clearTextPassword, saltString).substring(2));
        } else {
            sb.append(this.digest(clearTextPassword, this.saltedDigest));
        }
        return sb.toString();
    }

    private static byte[] utf8encode(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s.getBytes();
        }
    }

    private static String utf8decode(byte[] b) {
        try {
            return new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String digest(String password, boolean salted) {
        byte[] result;
        byte[] passwordBytes = LdapCredentialPasswordEncoder.utf8encode(password);
        MessageDigest messageDigest = this.digester;
        synchronized (messageDigest) {
            this.digester.reset();
            if (salted) {
                byte[] salt = new byte[8];
                new SecureRandom().nextBytes(salt);
                this.digester.update(passwordBytes);
                this.digester.update(salt);
                byte[] hashedPassword = this.digester.digest();
                result = new byte[hashedPassword.length + salt.length];
                System.arraycopy(hashedPassword, 0, result, 0, hashedPassword.length);
                System.arraycopy(salt, 0, result, hashedPassword.length, salt.length);
            } else {
                result = this.digester.digest(passwordBytes);
            }
        }
        return LdapCredentialPasswordEncoder.utf8decode(Base64.encodeBase64((byte[])result));
    }

    public static void main(String[] arg) throws Exception {
        if (arg.length != 2) {
            System.err.println("Usage - java org.apache.jetspeed.security.spi.impl.LdapCredentialPasswordEncoder <CRYPT|SHA|SSHA|MD5|SMD5> <password>");
            System.exit(1);
        } else {
            System.err.println("Encoded password=" + new LdapCredentialPasswordEncoder(arg[0]).encode(null, arg[1]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum HashMethod {
        SHA,
        SSHA,
        MD5,
        SMD5,
        CRYPT;

    }
}

