/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.JetspeedPrincipalManager;
import org.apache.jetspeed.security.JetspeedPrincipalManagerProvider;
import org.apache.jetspeed.security.SecurityAttribute;
import org.apache.jetspeed.security.SecurityAttributeType;
import org.apache.jetspeed.security.SecurityAttributes;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.mapping.SecurityEntityManager;
import org.apache.jetspeed.security.mapping.SecurityEntityRelationType;
import org.apache.jetspeed.security.mapping.model.Attribute;
import org.apache.jetspeed.security.mapping.model.Entity;
import org.apache.jetspeed.security.spi.JetspeedSecuritySynchronizer;
import org.apache.jetspeed.security.spi.impl.SynchronizationStateAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJetspeedSecuritySynchronizer
implements JetspeedSecuritySynchronizer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultJetspeedSecuritySynchronizer.class);
    JetspeedPrincipalManagerProvider principalManagerProvider;
    SecurityEntityManager securityEntityManager;
    Collection<String> supportedExternalEntityTypes = Collections.emptyList();
    Collection<SecurityEntityRelationType> supportedExternalEntityRelationTypes = Collections.emptyList();
    Map<String, Collection<SecurityEntityRelationType>> entityToRelationTypes = Collections.emptyMap();

    public DefaultJetspeedSecuritySynchronizer(JetspeedPrincipalManagerProvider principalManagerProvider, SecurityEntityManager securityEntityManager) {
        this.principalManagerProvider = principalManagerProvider;
        this.securityEntityManager = securityEntityManager;
        this.createRelations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void synchronizeAll() {
        this.setSynchronizing(true);
        try {
            ArrayList<String> skipEntities = new ArrayList<String>();
            InternalSynchronizationState synchronizationState = new InternalSynchronizationState(skipEntities);
            for (String type : this.securityEntityManager.getSupportedEntityTypes()) {
                for (Entity entity : this.securityEntityManager.getAllEntities(type)) {
                    this.recursiveSynchronizeEntity(entity, synchronizationState, false);
                }
            }
        }
        finally {
            this.setSynchronizing(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void synchronizePrincipalsByType(String type, boolean recursive) {
        this.setSynchronizing(true);
        try {
            Collection<Entity> entites = this.securityEntityManager.getAllEntities(type);
            ArrayList<String> skipEntities = new ArrayList<String>();
            if (!type.equals("user")) {
                skipEntities.add("user");
            }
            InternalSynchronizationState synchronizationState = new InternalSynchronizationState(skipEntities);
            for (Entity entity : entites) {
                this.recursiveSynchronizeEntity(entity, synchronizationState, recursive);
            }
        }
        finally {
            this.setSynchronizing(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void synchronizeUserPrincipal(String name, boolean recursive) {
        this.setSynchronizing(true);
        try {
            List<String> skipEntities = Arrays.asList("user");
            this.recursiveSynchronizeEntity(this.securityEntityManager.getEntity("user", name), new InternalSynchronizationState(skipEntities), recursive);
        }
        finally {
            this.setSynchronizing(false);
        }
    }

    protected JetspeedPrincipal recursiveSynchronizeEntity(Entity entity, InternalSynchronizationState syncState, boolean recursive) {
        JetspeedPrincipal updatedPrincipal = null;
        if (entity != null && !syncState.isProcessed(entity)) {
            syncState.setProcessed(entity);
            updatedPrincipal = this.synchronizePrincipalAttributes(entity);
            if (updatedPrincipal != null) {
                this.synchronizeEntityRelations(updatedPrincipal, entity, syncState, recursive);
            }
        }
        return updatedPrincipal;
    }

    protected JetspeedPrincipal synchronizeEntityRelations(JetspeedPrincipal principal, Entity entity, InternalSynchronizationState syncState, boolean recursive) {
        if (this.entityToRelationTypes.values().size() != 0) {
            for (SecurityEntityRelationType relationTypeForThisEntity : this.entityToRelationTypes.get(entity.getType())) {
                if (relationTypeForThisEntity.getFromEntityType().equals(entity.getType()) && syncState.shouldFollowRelationTo(entity, true, relationTypeForThisEntity.getToEntityType())) {
                    Collection<Long> updatedRelationToIds = this.synchronizeAddedEntityRelations(relationTypeForThisEntity, entity, principal, true, syncState, recursive);
                    this.synchronizeRemovedAssociations(updatedRelationToIds, relationTypeForThisEntity.getRelationType(), principal, true);
                }
                if (!relationTypeForThisEntity.getToEntityType().equals(entity.getType()) || !syncState.shouldFollowRelationTo(entity, false, relationTypeForThisEntity.getFromEntityType())) continue;
                Collection<Long> updatedRelationFromIds = this.synchronizeAddedEntityRelations(relationTypeForThisEntity, entity, principal, false, syncState, recursive);
                this.synchronizeRemovedAssociations(updatedRelationFromIds, relationTypeForThisEntity.getRelationType(), principal, false);
            }
        }
        return principal;
    }

    protected Collection<Long> synchronizeAddedEntityRelations(SecurityEntityRelationType relationTypeForThisEntity, Entity entity, JetspeedPrincipal principal, boolean entityIsFromEntity, InternalSynchronizationState syncState, boolean recursive) {
        Collection<Entity> relatedEntities = entityIsFromEntity ? this.securityEntityManager.getRelatedEntitiesFrom(entity, relationTypeForThisEntity) : this.securityEntityManager.getRelatedEntitiesTo(entity, relationTypeForThisEntity);
        ArrayList<Long> externalRelatedEntityIds = new ArrayList<Long>();
        if (relatedEntities != null) {
            for (Entity relatedEntity : relatedEntities) {
                JetspeedPrincipal toPrincipal;
                Entity toEntity;
                Entity fromEntity = entityIsFromEntity ? entity : relatedEntity;
                if (syncState.isRelationProcessed(relationTypeForThisEntity, fromEntity, toEntity = entityIsFromEntity ? relatedEntity : entity)) continue;
                syncState.setRelationProcessed(relationTypeForThisEntity, fromEntity, toEntity, entityIsFromEntity);
                JetspeedPrincipal relatedPrincipal = null;
                if (recursive) {
                    relatedPrincipal = this.recursiveSynchronizeEntity(relatedEntity, syncState, recursive);
                } else {
                    JetspeedPrincipalManager principalManager = this.principalManagerProvider.getManager(this.principalManagerProvider.getPrincipalType(relatedEntity.getType()));
                    if (principalManager != null) {
                        relatedPrincipal = principalManager.getPrincipal(relatedEntity.getId());
                    }
                }
                JetspeedPrincipal fromPrincipal = entityIsFromEntity ? principal : relatedPrincipal;
                JetspeedPrincipal jetspeedPrincipal = toPrincipal = entityIsFromEntity ? relatedPrincipal : principal;
                if (relatedPrincipal == null || this.associationExists(fromPrincipal, toPrincipal, relationTypeForThisEntity.getRelationType())) continue;
                this.synchronizeAddedPrincipalAssocation(fromPrincipal, toPrincipal, relationTypeForThisEntity.getRelationType());
                externalRelatedEntityIds.add(relatedPrincipal.getId());
            }
        }
        return externalRelatedEntityIds;
    }

    protected void synchronizeRemovedAssociations(Collection<Long> externalRelatedEntityIds, String associationName, JetspeedPrincipal principal, boolean isFromPrincipal) {
        if (logger.isDebugEnabled()) {
            logger.debug("--- Synchronize removed associations ---");
        }
        JetspeedPrincipalManager principalManager = this.principalManagerProvider.getManager(principal.getType());
        List relatedToPrincipals = null;
        relatedToPrincipals = isFromPrincipal ? principalManager.getAssociatedFrom(principal.getName(), principal.getType(), associationName) : principalManager.getAssociatedTo(principal.getName(), principal.getType(), associationName);
        for (JetspeedPrincipal relatedPrincipal : relatedToPrincipals) {
            if (externalRelatedEntityIds.contains(relatedPrincipal.getId())) continue;
            try {
                if (isFromPrincipal) {
                    principalManager.removeAssociation(principal, relatedPrincipal, associationName);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Removed association [" + principal.getName() + " (" + principal.getType().getName() + ")] ---[" + associationName + "]--> [" + relatedPrincipal.getName() + " (" + relatedPrincipal.getType().getName() + ")]");
                    continue;
                }
                principalManager.removeAssociation(relatedPrincipal, principal, associationName);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Removed association [" + relatedPrincipal.getName() + " (" + relatedPrincipal.getType().getName() + ")] ---[" + associationName + "]--> [" + principal.getName() + " (" + principal.getType().getName() + ")]");
            }
            catch (SecurityException e) {
                if (isFromPrincipal) {
                    logger.error("Unexpected SecurityException trying to remove (" + principal.getType().getName() + "," + relatedPrincipal.getType().getName() + "," + associationName + ") association during synchronization.", (Throwable)e);
                    continue;
                }
                logger.error("Unexpected SecurityException trying to remove (" + relatedPrincipal.getType().getName() + "," + principal.getType().getName() + "," + associationName + ") association during synchronization.", (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("--- /END Synchronize removed associations ---");
        }
    }

    protected boolean associationExists(JetspeedPrincipal fromPrincipal, JetspeedPrincipal toPrincipal, String associationName) {
        JetspeedPrincipalManager principalManager = this.principalManagerProvider.getManager(fromPrincipal.getType());
        List toPrincipals = principalManager.getAssociatedNamesFrom(fromPrincipal.getName(), fromPrincipal.getType(), associationName);
        return toPrincipals.contains(toPrincipal.getName());
    }

    protected void synchronizeAddedPrincipalAssocation(JetspeedPrincipal fromPrincipal, JetspeedPrincipal toPrincipal, String associationName) {
        JetspeedPrincipalManager principalManager = this.principalManagerProvider.getManager(fromPrincipal.getType());
        try {
            principalManager.addAssociation(fromPrincipal, toPrincipal, associationName);
        }
        catch (SecurityException e) {
            logger.error("Unexpected SecurityException during synchronization.", (Throwable)e);
        }
    }

    protected JetspeedPrincipal synchronizePrincipalAttributes(Entity entity) {
        JetspeedPrincipal updatedPrincipal = null;
        JetspeedPrincipalManager principalManager = this.principalManagerProvider.getManager(this.principalManagerProvider.getPrincipalType(entity.getType()));
        if (logger.isDebugEnabled()) {
            logger.debug("--- Synchronize principal attributes ---");
        }
        if (principalManager != null) {
            SecurityAttributes principalAttrs;
            updatedPrincipal = principalManager.getPrincipal(entity.getId());
            Map<String, Attribute> mappedEntityAttrs = entity.getMappedAttributes();
            ArrayList<Attribute> attrsToBeUpdated = new ArrayList<Attribute>();
            if (updatedPrincipal == null) {
                block25: {
                    updatedPrincipal = principalManager.newPrincipal(entity.getId(), true);
                    try {
                        principalManager.addPrincipal(updatedPrincipal, null);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Adding principal " + updatedPrincipal.getName() + " of type " + updatedPrincipal.getType().getName() + " ...");
                        }
                    }
                    catch (SecurityException sexp) {
                        if (!logger.isErrorEnabled()) break block25;
                        logger.error("Unexpected exception in adding new pricipal of type " + updatedPrincipal.getType().getName() + ".", (Throwable)sexp);
                    }
                }
                attrsToBeUpdated.addAll(mappedEntityAttrs.values());
            } else if (updatedPrincipal.isMapped()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Updating principal " + updatedPrincipal.getName() + " of type " + updatedPrincipal.getType().getName() + " ...");
                }
                principalAttrs = updatedPrincipal.getSecurityAttributes();
                for (Map.Entry<String, Attribute> entityAttrEntry : mappedEntityAttrs.entrySet()) {
                    SecurityAttribute principalAttr = principalAttrs.getAttribute(entityAttrEntry.getKey());
                    Attribute entityAttr = entityAttrEntry.getValue();
                    if (principalAttr != null) {
                        if (entityAttr.getDefinition().isMultiValue() || StringUtils.equals((String)principalAttr.getStringValue(), (String)entityAttr.getValue())) continue;
                        attrsToBeUpdated.add(entityAttr);
                        continue;
                    }
                    attrsToBeUpdated.add(entityAttr);
                }
            }
            principalAttrs = updatedPrincipal.getSecurityAttributes();
            Map securityAttrTypes = principalAttrs.getSecurityAttributeTypes().getAttributeTypeMap();
            for (Attribute addedEntityAttr : attrsToBeUpdated) {
                if (addedEntityAttr.getDefinition().isMultiValue()) continue;
                SecurityAttribute principalAttr = null;
                try {
                    SecurityAttributeType securityAttrType = (SecurityAttributeType)securityAttrTypes.get(addedEntityAttr.getMappedName());
                    if (securityAttrType != null) {
                        principalAttr = principalAttrs.getAttribute(addedEntityAttr.getMappedName(), true);
                    }
                    if (principalAttr != null) {
                        principalAttr.setStringValue(addedEntityAttr.getValue());
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Marked attribute " + principalAttr.getName() + " as updated for principal " + updatedPrincipal.getName() + ". New value: " + principalAttr.getStringValue());
                }
                catch (SecurityException e) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("Unexpected exception for attribute " + addedEntityAttr.getMappedName() + ".", (Throwable)e);
                }
            }
            if (updatedPrincipal.isMapped()) {
                boolean updated = attrsToBeUpdated.size() > 0;
                for (Map.Entry principalAttrEntry : principalAttrs.getAttributeMap().entrySet()) {
                    if (mappedEntityAttrs.containsKey(principalAttrEntry.getKey())) continue;
                    try {
                        principalAttrs.removeAttribute((String)principalAttrEntry.getKey());
                        updated = true;
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Marked attribute " + (String)principalAttrEntry.getKey() + " as removed for principal " + updatedPrincipal.getName());
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                }
                if (updated) {
                    try {
                        principalManager.updatePrincipal(updatedPrincipal);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Committing attribute changes for principal " + updatedPrincipal.getName());
                        }
                    }
                    catch (SecurityException e) {
                        logger.error("Unexpected SecurityException: could not synchronize principal " + updatedPrincipal.getName() + " of type " + updatedPrincipal.getType().getName(), (Throwable)e);
                    }
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("--- /END Synchronize principal attributes ---");
        }
        return updatedPrincipal;
    }

    private void setSynchronizing(boolean sync) {
        SynchronizationStateAccess.setSynchronizing(sync ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setPrincipalManagerProvider(JetspeedPrincipalManagerProvider principalManagerProvider) {
        this.principalManagerProvider = principalManagerProvider;
    }

    private void createRelations() {
        this.supportedExternalEntityTypes = this.securityEntityManager.getSupportedEntityTypes();
        this.supportedExternalEntityRelationTypes = this.securityEntityManager.getSupportedEntityRelationTypes();
        this.entityToRelationTypes = new HashMap<String, Collection<SecurityEntityRelationType>>();
        for (String entityType : this.supportedExternalEntityTypes) {
            this.entityToRelationTypes.put(entityType, this.securityEntityManager.getSupportedEntityRelationTypes(entityType));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InternalSynchronizationState {
        Map<String, Set<String>> processedEntities = new HashMap<String, Set<String>>();
        Map<SecurityEntityRelationType, Map<String, Collection<String>>> processedEntityRelationsFromTo = new HashMap<SecurityEntityRelationType, Map<String, Collection<String>>>();
        Collection<String> skipEntities;

        InternalSynchronizationState(Collection<String> skipEntities) {
            this.skipEntities = skipEntities;
        }

        protected boolean isProcessed(Entity entity) {
            Set<String> processedEntitiesByType = this.processedEntities.get(entity.getType());
            return processedEntitiesByType != null && processedEntitiesByType.contains(entity.getId());
        }

        protected boolean shouldFollowRelationTo(Entity entity, boolean isFromEntity, String relationType) {
            return !this.skipEntities.contains(relationType);
        }

        protected void setProcessed(Entity entity) {
            Set<String> processedEntitiesByType = this.processedEntities.get(entity.getType());
            if (processedEntitiesByType == null) {
                processedEntitiesByType = new HashSet<String>();
            }
            processedEntitiesByType.add(entity.getId());
        }

        protected boolean isRelationProcessed(SecurityEntityRelationType relationType, Entity fromEntity, Entity toEntity) {
            Map<String, Collection<String>> e2eMap = this.processedEntityRelationsFromTo.get(relationType);
            if (e2eMap != null) {
                Collection<String> endIds = e2eMap.get(fromEntity.getId());
                return endIds != null && endIds.contains(toEntity.getId());
            }
            return false;
        }

        protected void setRelationProcessed(SecurityEntityRelationType relationType, Entity startEntity, Entity endEntity, boolean startEntityIsFrom) {
            if (startEntityIsFrom) {
                this.setRelationProcessed(relationType, startEntity, endEntity);
            } else {
                this.setRelationProcessed(relationType, endEntity, startEntity);
            }
        }

        protected void setRelationProcessed(SecurityEntityRelationType relationType, Entity fromEntity, Entity toEntity) {
            Collection<String> endIds;
            Map<String, Collection<String>> e2eMap = this.processedEntityRelationsFromTo.get(relationType);
            if (e2eMap == null) {
                e2eMap = new HashMap<String, Collection<String>>();
                this.processedEntityRelationsFromTo.put(relationType, e2eMap);
            }
            if ((endIds = e2eMap.get(fromEntity.getId())) == null) {
                endIds = new ArrayList<String>();
                e2eMap.put(fromEntity.getId(), endIds);
            }
            endIds.add(toEntity.getId());
        }
    }
}

