/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mapping.ldap.dao.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.mapping.EntityFactory;
import org.apache.jetspeed.security.mapping.ldap.EntityFactoryImpl;
import org.apache.jetspeed.security.mapping.ldap.dao.DefaultEntityContextMapper;
import org.apache.jetspeed.security.mapping.ldap.dao.EntityDAO;
import org.apache.jetspeed.security.mapping.ldap.dao.LDAPEntityDAOConfiguration;
import org.apache.jetspeed.security.mapping.ldap.dao.SearchUtil;
import org.apache.jetspeed.security.mapping.ldap.filter.SimpleFilter;
import org.apache.jetspeed.security.mapping.model.AttributeDef;
import org.apache.jetspeed.security.mapping.model.Entity;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.OrFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringLDAPEntityDAO
implements EntityDAO {
    protected LdapTemplate ldapTemplate;
    protected final LDAPEntityDAOConfiguration configuration;
    protected final DistinguishedName searchDN;
    protected ContextMapper contextMapper;
    protected EntityFactory entityFactory;

    public SpringLDAPEntityDAO(LDAPEntityDAOConfiguration configuration) {
        this.configuration = configuration;
        this.searchDN = new DistinguishedName(this.getConfiguration().getSearchDN());
        this.entityFactory = new EntityFactoryImpl(configuration);
        this.contextMapper = new DefaultEntityContextMapper(this.entityFactory);
    }

    public void initialize(LdapTemplate ldapTemplate) {
        this.ldapTemplate = ldapTemplate;
    }

    public LDAPEntityDAOConfiguration getConfiguration() {
        return this.configuration;
    }

    public ContextMapper getContextMapper() {
        return this.contextMapper;
    }

    @Override
    public EntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    public void setLdapTemplate(LdapTemplate ldapTemplate) {
        this.ldapTemplate = ldapTemplate;
    }

    public void setContextMapper(ContextMapper contextMapper) {
        this.contextMapper = contextMapper;
    }

    @Override
    public Entity getEntity(String entityId) {
        Filter idFilter = this.createFilterForIdSearch(entityId);
        Collection<Entity> entities = this.getEntities(idFilter);
        if (entities != null && entities.size() == 1) {
            return entities.iterator().next();
        }
        return null;
    }

    @Override
    public Collection<Entity> getEntitiesById(Collection<String> entityIds) {
        OrFilter idFilter = new OrFilter();
        String idAttr = this.configuration.getLdapIdAttribute();
        for (String id : entityIds) {
            idFilter.or((Filter)new EqualsFilter(idAttr, id));
        }
        Object combinedFilter = null;
        combinedFilter = this.configuration.getSearchFilter() != null ? SearchUtil.andFilters(new Filter[]{idFilter, this.configuration.getSearchFilter()}) : idFilter;
        return this.getEntities((Filter)combinedFilter);
    }

    @Override
    public Collection<Entity> getEntitiesByInternalId(Collection<String> internalIds) {
        ArrayList<Entity> resultSet = new ArrayList<Entity>();
        Iterator<String> iterator = internalIds.iterator();
        while (iterator.hasNext()) {
            Entity resultEntity = this.getEntityByInternalId(iterator.next());
            if (resultEntity == null) continue;
            resultSet.add(resultEntity);
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entity getEntityByInternalId(String internalId) {
        String searchDNStr;
        Entity resultEntity = null;
        DistinguishedName principalDN = this.getRelativeDN(internalId);
        String relativeDN = principalDN.toCompactString();
        if (relativeDN.equals(searchDNStr = this.searchDN.toCompactString()) || relativeDN.endsWith(searchDNStr)) {
            internalId = principalDN.toCompactString();
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                resultEntity = (Entity)this.ldapTemplate.lookup(internalId, this.getContextMapper());
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        return resultEntity;
    }

    @Override
    public Entity getParentEntity(Entity childEntity) {
        DistinguishedName parentDN = new DistinguishedName(childEntity.getInternalId());
        parentDN.removeLast();
        return this.getEntityByInternalId(parentDN.encode());
    }

    protected DistinguishedName getRelativeDN(String fullDN) {
        DistinguishedName principalDN = new DistinguishedName(fullDN);
        if (this.configuration.getBaseDN() != null && this.configuration.getBaseDN().length() > 0) {
            principalDN.removeFirst((Name)new DistinguishedName(this.configuration.getBaseDN()));
        }
        return principalDN;
    }

    protected String createSearchFilter(Filter filter) {
        String filterStr;
        if (this.configuration.getSearchFilter() != null) {
            filter = filter == null ? this.configuration.getSearchFilter() : SearchUtil.andFilters(this.configuration.getSearchFilter(), filter);
        }
        if (StringUtils.isEmpty((String)(filterStr = filter.encode()))) {
            filterStr = "(objectClass=*)";
        }
        return filterStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Entity> getEntities(Filter filter) {
        String filterStr = this.createSearchFilter(filter);
        List results = null;
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            results = this.ldapTemplate.search(this.configuration.getSearchDN(), filterStr, 2, this.getContextMapper());
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Entity> getEntities(Entity parent, Filter filter) {
        String filterStr = this.createSearchFilter(filter);
        List results = null;
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            String parentId = parent.getInternalId();
            DistinguishedName parentDN = this.getRelativeDN(parentId);
            results = this.ldapTemplate.search(parentDN.encode(), filterStr, 1, this.getContextMapper());
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
        return results;
    }

    @Override
    public Collection<Entity> getAllEntities() {
        String finalFilter = this.configuration.getSearchFilter() != null ? this.configuration.getSearchFilter().encode() : "(objectClass=*)";
        return this.getEntities(new SimpleFilter(finalFilter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalUpdate(Entity entity, UpdateMode umode) throws SecurityException {
        String internalId = entity.getInternalId();
        if (internalId == null) {
            Entity ldapEntity = this.getEntity(entity.getId());
            if (ldapEntity == null || ldapEntity.getInternalId() == null) {
                throw new SecurityException(SecurityException.PRINCIPAL_UPDATE_FAILURE.createScoped(entity.getType(), (Object)entity.getId()));
            }
            internalId = ldapEntity.getInternalId();
        }
        DistinguishedName dn = this.getRelativeDN(internalId);
        DirContextOperations dirCtxOps = null;
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            dirCtxOps = this.ldapTemplate.lookupContext((Name)dn);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
        if (dirCtxOps == null) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(entity.getType(), (Object)entity.getId()));
        }
        Collection<ModificationItem> modItems = this.getModItems(entity, dirCtxOps, umode);
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.ldapTemplate.modifyAttributes((Name)dn, modItems.toArray(new ModificationItem[0]));
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    @Override
    public void add(Entity entity, Entity parentEntity) throws SecurityException {
        if (parentEntity == null || parentEntity.getInternalId() == null) {
            throw new SecurityException(SecurityException.UNEXPECTED.create((Object)this.getClass().getName(), (Object)"add(Entity entity, Entity parentEntity)", (Object)"Provided parent entity is null or has no internal ID."));
        }
        DistinguishedName parentDn = new DistinguishedName(parentEntity.getInternalId());
        parentDn.removeFirst((Name)new DistinguishedName(this.configuration.getBaseDN()));
        this.internalAdd(entity, parentDn);
    }

    @Override
    public void add(Entity entity) throws SecurityException {
        DistinguishedName dn = new DistinguishedName();
        if (this.configuration.getSearchDN() != null && this.configuration.getSearchDN().length() > 0) {
            try {
                dn.addAll((Name)new DistinguishedName(this.configuration.getSearchDN()));
            }
            catch (InvalidNameException inex) {
                throw new SecurityException(SecurityException.UNEXPECTED.create((Object)this.getClass().getName(), (Object)"add(Entity entity)", (Object)inex));
            }
        }
        this.internalAdd(entity, dn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalAdd(Entity entity, DistinguishedName dn) throws SecurityException {
        if (this.entityExists(entity)) {
            throw new SecurityException(SecurityException.PRINCIPAL_ALREADY_EXISTS.createScoped(entity.getType(), (Object)entity.getId()));
        }
        DirContextAdapter context = new DirContextAdapter();
        if (dn != null) {
            dn.add(this.configuration.getLdapIdAttribute(), entity.getId());
            for (AttributeDef attrDef : this.configuration.getAttributeDefinitions()) {
                String requiredValue;
                org.apache.jetspeed.security.mapping.model.Attribute entityAttr = entity.getAttribute(attrDef.getName());
                BasicAttribute basicAttr = null;
                if (entityAttr != null) {
                    if (attrDef.isMultiValue()) {
                        Collection<String> entityAttrValues = entityAttr.getValues();
                        if (entityAttrValues != null && entityAttrValues.size() > 0) {
                            basicAttr = new BasicAttribute(attrDef.getName());
                            for (String val : entityAttrValues) {
                                basicAttr.add(val);
                            }
                        }
                    } else {
                        basicAttr = new BasicAttribute(attrDef.getName());
                        basicAttr.add(entityAttr.getValue());
                    }
                } else if (attrDef.isIdAttribute()) {
                    basicAttr = new BasicAttribute(attrDef.getName());
                    basicAttr.add(entity.getId());
                } else if (attrDef.isRequired() && (requiredValue = attrDef.getRequiredDefaultValue()) != null && requiredValue.length() > 0) {
                    basicAttr = new BasicAttribute(attrDef.getName());
                    basicAttr.add(attrDef.getRequiredDefaultValue());
                }
                if (basicAttr == null) continue;
                context.setAttribute((Attribute)basicAttr);
            }
            BasicAttribute attr = new BasicAttribute("objectClass");
            for (String objClass : this.configuration.getObjectClassesArray()) {
                attr.add(objClass);
            }
            context.setAttribute((Attribute)attr);
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.ldapTemplate.bind((Name)dn, (Object)context, null);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Entity entity) throws SecurityException {
        if (!this.entityExists(entity)) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(entity.getType(), (Object)entity.getId()));
        }
        String internalIdStr = entity.getInternalId();
        if (internalIdStr == null) {
            Entity ldapEntity = this.getEntity(entity.getId());
            if (ldapEntity == null || ldapEntity.getInternalId() == null) {
                return;
            }
            internalIdStr = ldapEntity.getInternalId();
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.ldapTemplate.unbind((Name)this.getRelativeDN(internalIdStr));
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    @Override
    public void update(Entity entity) throws SecurityException {
        this.internalUpdate(entity, UpdateMode.MAPPED);
    }

    @Override
    public void updateInternalAttributes(Entity entity) throws SecurityException {
        this.internalUpdate(entity, UpdateMode.INTERNAL);
    }

    protected boolean entityExists(Entity entity) {
        return this.getEntity(entity.getId()) != null;
    }

    protected boolean setNamingAttribute(org.apache.jetspeed.security.mapping.model.Attribute entityAttr, DirContextOperations dirCtxOps) {
        boolean attrAdded = false;
        if (entityAttr != null) {
            AttributeDef attrDef = entityAttr.getDefinition();
            if (attrDef.isMultiValue()) {
                Collection<String> values = entityAttr.getValues();
                if (values != null) {
                    dirCtxOps.setAttributeValues(attrDef.getName(), values.toArray());
                    attrAdded = true;
                }
            } else {
                String value = entityAttr.getValue();
                if (value != null) {
                    dirCtxOps.setAttributeValue(attrDef.getName(), (Object)value);
                    attrAdded = true;
                }
            }
        }
        return attrAdded;
    }

    protected Collection<ModificationItem> getModItems(Entity entity, DirContextOperations dirCtxOps, UpdateMode umode) {
        ArrayList<ModificationItem> modItems = new ArrayList<ModificationItem>();
        for (AttributeDef attrDef : this.configuration.getAttributeDefinitions()) {
            Object namingAttrValue;
            if (attrDef.getName().equals(this.configuration.getLdapIdAttribute()) || umode != UpdateMode.ALL && (umode != UpdateMode.MAPPED || !attrDef.isMapped()) && (umode != UpdateMode.INTERNAL || attrDef.isMapped())) continue;
            org.apache.jetspeed.security.mapping.model.Attribute entityAttr = entity.getAttribute(attrDef.getName());
            boolean attrAdded = false;
            if (entityAttr != null) {
                BasicAttribute namingAttr;
                if (attrDef.isMultiValue()) {
                    Collection<String> values = entityAttr.getValues();
                    if (values != null) {
                        namingAttr = new BasicAttribute(entityAttr.getName());
                        if (values.size() > 0) {
                            for (String val : values) {
                                namingAttr.add(val);
                            }
                            modItems.add(new ModificationItem(2, namingAttr));
                            attrAdded = true;
                        }
                    }
                } else {
                    String value = entityAttr.getValue();
                    if (value != null) {
                        namingAttr = new BasicAttribute(entityAttr.getName(), entityAttr.getValue());
                        modItems.add(new ModificationItem(2, namingAttr));
                        attrAdded = true;
                    }
                }
            }
            if (attrAdded || (namingAttrValue = dirCtxOps.getObjectAttribute(attrDef.getName())) == null) continue;
            BasicAttribute basicAttr = new BasicAttribute(attrDef.getName());
            if (attrDef.isRequired()) {
                if (attrDef.getRequiredDefaultValue() == null) break;
                basicAttr.add(attrDef.getRequiredDefaultValue());
                modItems.add(new ModificationItem(2, basicAttr));
                continue;
            }
            modItems.add(new ModificationItem(3, basicAttr));
        }
        return modItems;
    }

    protected Filter createFilterForIdSearch(String entityId) {
        return SearchUtil.constructMatchingFieldsFilter(this.configuration.getSearchFilter(), (String[][])new String[][]{{this.configuration.getLdapIdAttribute(), entityId}});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum UpdateMode {
        MAPPED,
        INTERNAL,
        ALL;

    }
}

