/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl.ldap;

import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.i18n.KeyedMessage;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.spi.impl.ldap.AbstractLdapDao;
import org.apache.jetspeed.security.spi.impl.ldap.LdapBindingConfig;
import org.apache.jetspeed.security.spi.impl.ldap.LdapUserCredentialDao;

public class LdapUserCredentialDaoImpl
extends AbstractLdapDao
implements LdapUserCredentialDao {
    private static final Log logger = LogFactory.getLog((Class)LdapUserCredentialDaoImpl.class);

    public LdapUserCredentialDaoImpl() throws SecurityException {
    }

    public LdapUserCredentialDaoImpl(LdapBindingConfig ldapConfig) throws SecurityException {
        super(ldapConfig);
    }

    public void changePassword(String uid, String password) throws SecurityException {
        this.validateUid(uid);
        this.validatePassword(password);
        logger.debug((Object)("changePassword for " + uid + " with " + password));
        String userDn = this.lookupByUid(uid);
        logger.debug((Object)("userDn = " + userDn));
        try {
            this.setPassword(userDn, password);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    public boolean authenticate(String uid, String password) throws SecurityException {
        this.validateUid(uid);
        this.validatePassword(password);
        try {
            Hashtable<?, ?> env = this.ctx.getEnvironment();
            String oldCredential = (String)env.get("java.naming.security.credentials");
            String oldUsername = (String)env.get("java.naming.security.principal");
            String dn = this.lookupByUid(uid);
            if (dn == null) {
                throw new SecurityException(new KeyedMessage("User " + uid + " not found"));
            }
            if (!StringUtils.isEmpty((String)this.getRootContext())) {
                dn = dn + "," + this.getRootContext();
            }
            env.put("java.naming.security.principal", dn);
            env.put("java.naming.security.credentials", password);
            new InitialContext(env);
            env.put("java.naming.security.principal", oldUsername);
            env.put("java.naming.security.credentials", oldCredential);
            return true;
        }
        catch (AuthenticationException e) {
            return false;
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    public char[] getPassword(String uid) throws SecurityException {
        this.validateUid(uid);
        try {
            SearchControls cons = this.setSearchControls();
            NamingEnumeration results = this.searchByWildcardedUid(uid, cons);
            return this.getPassword(results, uid);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    private void setPassword(String userDn, String password) throws NamingException {
        logger.debug((Object)("setPassword userDn = " + userDn));
        String rdn = this.getSubcontextName(userDn);
        logger.debug((Object)("setPassword rdn = " + rdn));
        BasicAttributes attrs = new BasicAttributes(false);
        attrs.put(this.getUserPasswordAttribute(), password);
        this.ctx.modifyAttributes(rdn, 2, (Attributes)attrs);
    }

    private char[] getPassword(NamingEnumeration results, String uid) throws NamingException {
        if (!results.hasMore()) {
            throw new NamingException("Could not find any user with uid[" + uid + "]");
        }
        Attributes userAttributes = this.getFirstUser(results);
        char[] rawPassword = this.convertRawPassword(this.getAttribute(this.getUserPasswordAttribute(), userAttributes));
        return rawPassword;
    }

    private Attribute getAttribute(String attributeName, Attributes userAttributes) throws NamingException {
        NamingEnumeration<? extends Attribute> ae = userAttributes.getAll();
        while (ae.hasMore()) {
            Attribute attr = ae.next();
            if (!attr.getID().equalsIgnoreCase(attributeName)) continue;
            return attr;
        }
        return null;
    }

    private char[] convertRawPassword(Attribute attr) throws NamingException {
        char[] charPass = null;
        if (attr != null) {
            byte[] rawPass = (byte[])attr.getAll().next();
            charPass = new char[rawPass.length];
            for (int i = 0; i < rawPass.length; ++i) {
                charPass[i] = (char)rawPass[i];
            }
        } else {
            charPass = new char[]{};
        }
        return charPass;
    }

    private Attributes getFirstUser(NamingEnumeration results) throws NamingException {
        SearchResult result = (SearchResult)results.next();
        Attributes answer = result.getAttributes();
        return answer;
    }

    protected String getEntryPrefix() {
        return this.getUserIdAttribute();
    }

    protected String getSearchSuffix() {
        return this.getUserFilter();
    }

    protected String getSearchDomain() {
        return this.getUserFilterBase();
    }

    protected String[] getObjectClasses() {
        return this.getUserObjectClasses();
    }

    protected String[] getAttributes() {
        return this.getUserAttributes();
    }
}

