/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl.ldap;

import java.security.Principal;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.impl.RolePrincipalImpl;
import org.apache.jetspeed.security.spi.impl.ldap.LdapBindingConfig;
import org.apache.jetspeed.security.spi.impl.ldap.LdapPrincipalDaoImpl;

public class LdapRoleDaoImpl
extends LdapPrincipalDaoImpl {
    public LdapRoleDaoImpl() throws SecurityException {
    }

    public LdapRoleDaoImpl(LdapBindingConfig ldapConfig) throws SecurityException {
        super(ldapConfig);
    }

    protected Attributes defineLdapAttributes(String principalUid) {
        int i;
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute classes = new BasicAttribute("objectclass");
        for (i = 0; i < this.getObjectClasses().length; ++i) {
            classes.add(this.getObjectClasses()[i]);
        }
        attrs.put(classes);
        attrs.put(this.getEntryPrefix(), principalUid);
        if (!StringUtils.isEmpty((String)this.getRoleObjectRequiredAttributeClasses())) {
            String key = this.getRoleObjectRequiredAttributeClasses();
            if (key.indexOf(44) >= 0) {
                String[] allKeys = key.split(",");
                for (int i2 = 0; i2 < allKeys.length; ++i2) {
                    attrs.put(allKeys[i2], "");
                }
            } else {
                attrs.put(this.getRoleObjectRequiredAttributeClasses(), "");
            }
        }
        for (i = 0; i < this.getAttributes().length; ++i) {
            attrs.put(this.parseAttr(this.getAttributes()[i], principalUid)[0], this.parseAttr(this.getAttributes()[i], principalUid)[1]);
        }
        return attrs;
    }

    protected String getDnSuffix() {
        return this.getRoleFilterBase();
    }

    protected Principal makePrincipal(String principalUid) {
        return new RolePrincipalImpl(principalUid);
    }

    protected String getEntryPrefix() {
        return this.getRoleIdAttribute();
    }

    protected String getSearchSuffix() {
        return this.getRoleFilter();
    }

    protected String getSearchDomain() {
        return this.getRoleFilterBase();
    }

    protected String[] getObjectClasses() {
        return this.getRoleObjectClasses();
    }

    protected String getUidAttributeForPrincipal() {
        return this.getRoleUidAttribute();
    }

    protected String[] getAttributes() {
        return this.getRoleAttributes();
    }
}

