/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl.ldap;

import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.security.InvalidDnException;
import org.apache.jetspeed.security.InvalidPasswordException;
import org.apache.jetspeed.security.InvalidUidException;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.spi.impl.ldap.LdapBindingConfig;
import org.apache.jetspeed.security.spi.impl.ldap.LdapContextProxy;

public abstract class AbstractLdapDao {
    private static final Log logger = LogFactory.getLog((Class)AbstractLdapDao.class);
    private LdapBindingConfig ldapBindingConfig = null;
    protected LdapContext ctx;

    public AbstractLdapDao() {
        throw new UnsupportedOperationException("Must be instantiated with LDAP binding configuration.");
    }

    public AbstractLdapDao(LdapBindingConfig ldapConfig) throws SecurityException {
        this.ldapBindingConfig = ldapConfig;
        this.bindToServer(ldapConfig.getRootDn(), ldapConfig.getRootPassword());
    }

    protected void bindToServer(String rootDn, String rootPassword) throws SecurityException {
        if (this.ctx == null) {
            this.validateDn(rootDn);
            this.validatePassword(rootPassword);
            this.ctx = LdapContextProxy.createProxy(this.ldapBindingConfig);
        }
    }

    protected String getSubcontextName(String dn) throws NamingException {
        String rootStr;
        Name root;
        NameParser parser = this.ctx.getNameParser("");
        Name name = parser.parse(dn);
        if (name.startsWith(root = parser.parse(rootStr = this.ctx.getNameInNamespace()))) {
            Name rname = name.getSuffix(root.size());
            return rname.toString();
        }
        return dn;
    }

    protected void validateDn(String dn) throws SecurityException {
        if (StringUtils.isEmpty((String)dn)) {
            throw new InvalidDnException();
        }
    }

    protected void validatePassword(String password) throws SecurityException {
        if (StringUtils.isEmpty((String)password)) {
            throw new InvalidPasswordException();
        }
    }

    protected SearchControls setSearchControls() {
        SearchControls controls = new SearchControls();
        controls.setReturningAttributes(this.getKnownAttributes());
        controls.setSearchScope(2);
        controls.setReturningObjFlag(true);
        return controls;
    }

    public String lookupByUid(String uid) throws SecurityException {
        this.validateUid(uid);
        try {
            SearchControls cons = this.setSearchControls();
            NamingEnumeration searchResults = this.searchByWildcardedUid(uid, cons);
            return this.getFirstDnForUid(searchResults);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    private String getFirstDnForUid(NamingEnumeration searchResults) throws NamingException {
        String userDn = null;
        while (null != searchResults && searchResults.hasMore()) {
            SearchResult searchResult = (SearchResult)searchResults.next();
            userDn = searchResult.getName();
            String searchDomain = this.getSearchDomain();
            if (searchDomain.length() <= 0) continue;
            userDn = userDn + "," + StringUtils.replace((String)searchDomain, (String)("," + this.getRootContext()), (String)"");
        }
        return userDn;
    }

    protected void validateUid(String uid) throws SecurityException {
        String pattern = ".*\\(.*|.*\\[.*|.*\\{.*|.*\\\\.*|.*\\^.*|.*\\$.*|.*\\|.*|.*\\).*|.*\\?.*|.*\\*.*|.*\\+.*|.*\\..*";
        if (StringUtils.isEmpty((String)uid) || uid.matches(pattern)) {
            throw new InvalidUidException();
        }
    }

    protected NamingEnumeration searchByWildcardedUid(String filter, SearchControls cons) throws NamingException {
        String query = "";
        query = StringUtils.isEmpty((String)this.getSearchSuffix()) ? "(" + this.getEntryPrefix() + "=" + (StringUtils.isEmpty((String)filter) ? "*" : filter) + ")" : "(&(" + this.getEntryPrefix() + "=" + (StringUtils.isEmpty((String)filter) ? "*" : filter) + ")" + this.getSearchSuffix() + ")";
        logger.debug((Object)("searchByWildCardedUid = " + query));
        cons.setSearchScope(this.getSearchScope());
        String searchBase = StringUtils.replace((String)this.getSearchDomain(), (String)("," + this.getRootContext()), (String)"");
        NamingEnumeration<SearchResult> results = this.ctx.search(searchBase, query, cons);
        return results;
    }

    protected NamingEnumeration searchGroupByWildcardedUid(String filter, SearchControls cons) throws NamingException {
        String query = "";
        query = StringUtils.isEmpty((String)this.getGroupFilter()) ? "(" + this.getGroupIdAttribute() + "=" + (StringUtils.isEmpty((String)filter) ? "*" : filter) + ")" : "(&(" + this.getGroupIdAttribute() + "=" + (StringUtils.isEmpty((String)filter) ? "*" : filter) + ")" + this.getGroupFilter() + ")";
        String searchBase = "";
        if (!StringUtils.isEmpty((String)this.getGroupFilterBase())) {
            searchBase = searchBase + this.getGroupFilterBase();
        }
        cons.setSearchScope(this.getSearchScope());
        NamingEnumeration<SearchResult> results = this.ctx.search(searchBase, query, cons);
        return results;
    }

    protected NamingEnumeration searchRoleByWildcardedUid(String filter, SearchControls cons) throws NamingException {
        String query = "";
        query = StringUtils.isEmpty((String)this.getRoleFilter()) ? "(" + this.getRoleIdAttribute() + "=" + (StringUtils.isEmpty((String)filter) ? "*" : filter) + ")" : "(&(" + this.getRoleIdAttribute() + "=" + (StringUtils.isEmpty((String)filter) ? "*" : filter) + ")" + this.getRoleFilter() + ")";
        String searchBase = "";
        if (!StringUtils.isEmpty((String)this.getRoleFilterBase())) {
            searchBase = searchBase + this.getRoleFilterBase();
        }
        cons.setSearchScope(this.getSearchScope());
        NamingEnumeration<SearchResult> results = this.ctx.search(searchBase, query, cons);
        return results;
    }

    protected String getGroupFilterBase() {
        return this.ldapBindingConfig.getGroupFilterBase();
    }

    protected String[] getGroupObjectClasses() {
        return this.ldapBindingConfig.getGroupObjectClasses();
    }

    protected String getRoleFilterBase() {
        return this.ldapBindingConfig.getRoleFilterBase();
    }

    protected String[] getRoleObjectClasses() {
        return this.ldapBindingConfig.getRoleObjectClasses();
    }

    protected String getUserFilterBase() {
        return this.ldapBindingConfig.getUserFilterBase();
    }

    protected String getGroupFilter() {
        return this.ldapBindingConfig.getGroupFilter();
    }

    protected String getRoleFilter() {
        return this.ldapBindingConfig.getRoleFilter();
    }

    protected String getRootContext() {
        return this.ldapBindingConfig.getRootContext();
    }

    protected abstract String getEntryPrefix();

    protected abstract String getSearchSuffix();

    protected abstract String getSearchDomain();

    protected String getUserFilter() {
        return this.ldapBindingConfig.getUserFilter();
    }

    protected String[] getUserObjectClasses() {
        return this.ldapBindingConfig.getUserObjectClasses();
    }

    protected String getGroupMembershipAttribute() {
        return this.ldapBindingConfig.getGroupMembershipAttributes();
    }

    protected String getUserGroupMembershipAttribute() {
        return this.ldapBindingConfig.getUserGroupMembershipAttributes();
    }

    protected String getGroupMembershipForRoleAttribute() {
        return this.ldapBindingConfig.getGroupMembershipForRoleAttributes();
    }

    protected String getRoleGroupMembershipForRoleAttribute() {
        return this.ldapBindingConfig.getRoleGroupMembershipForRoleAttributes();
    }

    protected String getRoleMembershipAttribute() {
        return this.ldapBindingConfig.getRoleMembershipAttributes();
    }

    protected String getUserRoleMembershipAttribute() {
        return this.ldapBindingConfig.getUserRoleMembershipAttributes();
    }

    protected String getRoleIdAttribute() {
        return this.ldapBindingConfig.getRoleIdAttribute();
    }

    protected String getGroupIdAttribute() {
        return this.ldapBindingConfig.getGroupIdAttribute();
    }

    protected String getUserIdAttribute() {
        return this.ldapBindingConfig.getUserIdAttribute();
    }

    protected String getUidAttribute() {
        return this.ldapBindingConfig.getUidAttribute();
    }

    protected int getSearchScope() {
        return Integer.parseInt(this.ldapBindingConfig.getMemberShipSearchScope());
    }

    protected String getRoleUidAttribute() {
        return this.ldapBindingConfig.getRoleUidAttribute();
    }

    protected String getGroupUidAttribute() {
        return this.ldapBindingConfig.getGroupUidAttribute();
    }

    protected String getUserUidAttribute() {
        return this.ldapBindingConfig.getUserUidAttribute();
    }

    protected String getGroupObjectRequiredAttributeClasses() {
        return this.ldapBindingConfig.getGroupObjectRequiredAttributeClasses();
    }

    protected String getRoleObjectRequiredAttributeClasses() {
        return this.ldapBindingConfig.getRoleObjectRequiredAttributeClasses();
    }

    protected String[] getUserAttributes() {
        return this.ldapBindingConfig.getUserAttributes();
    }

    protected String[] getGroupAttributes() {
        return this.ldapBindingConfig.getGroupAttributes();
    }

    protected String[] getRoleAttributes() {
        return this.ldapBindingConfig.getRoleAttributes();
    }

    protected String getUserPasswordAttribute() {
        return this.ldapBindingConfig.getUserPasswordAttribute();
    }

    protected String[] getKnownAttributes() {
        return this.ldapBindingConfig.getKnownAttributes();
    }

    protected abstract String[] getObjectClasses();

    protected abstract String[] getAttributes();
}

