/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.om.InternalCredential;
import org.apache.jetspeed.security.spi.InternalPasswordCredentialInterceptor;
import org.apache.jetspeed.security.spi.PasswordCredentialProvider;
import org.apache.jetspeed.security.spi.impl.AbstractInternalPasswordCredentialInterceptorImpl;

public class ValidatePasswordOnLoadInterceptor
extends AbstractInternalPasswordCredentialInterceptorImpl {
    private static final Log log = LogFactory.getLog((Class)InternalPasswordCredentialInterceptor.class);

    public boolean afterLoad(PasswordCredentialProvider pcProvider, String userName, InternalCredential credential) throws SecurityException {
        boolean updated = false;
        if (!credential.isEncoded() && pcProvider.getValidator() != null) {
            try {
                pcProvider.getValidator().validate(credential.getValue());
            }
            catch (SecurityException e) {
                log.error((Object)("Loaded password for user " + userName + " is invalid. The user will be required to change it."));
                credential.setUpdateRequired(true);
                updated = true;
            }
        }
        return updated;
    }
}

