/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import org.apache.jetspeed.security.PasswordAlreadyUsedException;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.om.InternalCredential;
import org.apache.jetspeed.security.om.InternalUserPrincipal;
import org.apache.jetspeed.security.om.impl.InternalCredentialImpl;
import org.apache.jetspeed.security.spi.impl.AbstractInternalPasswordCredentialInterceptorImpl;

public class PasswordHistoryInterceptor
extends AbstractInternalPasswordCredentialInterceptorImpl {
    private int historySize;
    public static final String HISTORICAL_PASSWORD_CREDENTIAL = "org.apache.jetspeed.security.spi.impl.HistoricalPasswordCredentialImpl";
    private static final Comparator internalCredentialCreationDateComparator = new Comparator(){

        public int compare(Object obj1, Object obj2) {
            return ((InternalCredential)obj2).getCreationDate().compareTo(((InternalCredential)obj1).getCreationDate());
        }
    };

    public PasswordHistoryInterceptor(int historySize) {
        this.historySize = historySize;
    }

    public void beforeSetPassword(InternalUserPrincipal internalUser, Collection credentials, String userName, InternalCredential credential, String password, boolean authenticated) throws SecurityException {
        InternalCredential historicalPasswordCredential;
        int i;
        Collection internalCredentials = internalUser.getCredentials();
        ArrayList<InternalCredential> historicalPasswordCredentials = new ArrayList<InternalCredential>();
        if (internalCredentials != null) {
            Iterator iter = internalCredentials.iterator();
            while (iter.hasNext()) {
                InternalCredential currCredential = (InternalCredential)iter.next();
                if (currCredential.getType() != 0 || null == currCredential.getClassname() || !currCredential.getClassname().equals(HISTORICAL_PASSWORD_CREDENTIAL)) continue;
                historicalPasswordCredentials.add(currCredential);
            }
        }
        if (historicalPasswordCredentials.size() > 1) {
            Collections.sort(historicalPasswordCredentials, internalCredentialCreationDateComparator);
        }
        int historyCount = historicalPasswordCredentials.size();
        if (authenticated) {
            for (i = 0; i < historyCount && i < this.historySize; ++i) {
                historicalPasswordCredential = (InternalCredential)historicalPasswordCredentials.get(i);
                if (historicalPasswordCredential.getValue() == null || !historicalPasswordCredential.getValue().equals(password)) continue;
                throw new PasswordAlreadyUsedException();
            }
        }
        for (i = this.historySize - 1; i < historyCount; ++i) {
            credentials.remove(historicalPasswordCredentials.get(i));
        }
        historicalPasswordCredential = new InternalCredentialImpl(credential, HISTORICAL_PASSWORD_CREDENTIAL);
        credentials.add(historicalPasswordCredential);
        credential.setCreationDate(new Timestamp(new Date().getTime()));
    }
}

