/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.security.AlgorithmUpgradePasswordEncodingService;
import org.apache.jetspeed.security.InvalidNewPasswordException;
import org.apache.jetspeed.security.InvalidPasswordException;
import org.apache.jetspeed.security.PasswordAlreadyUsedException;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.om.InternalCredential;
import org.apache.jetspeed.security.om.InternalUserPrincipal;
import org.apache.jetspeed.security.om.impl.InternalCredentialImpl;
import org.apache.jetspeed.security.spi.AlgorithmUpgradeCredentialPasswordEncoder;
import org.apache.jetspeed.security.spi.CredentialHandler;
import org.apache.jetspeed.security.spi.InternalPasswordCredentialInterceptor;
import org.apache.jetspeed.security.spi.PasswordCredentialProvider;
import org.apache.jetspeed.security.spi.SecurityAccess;

public class DefaultCredentialHandler
implements CredentialHandler {
    private static final Log log = LogFactory.getLog((Class)DefaultCredentialHandler.class);
    private SecurityAccess securityAccess;
    private PasswordCredentialProvider pcProvider;
    private InternalPasswordCredentialInterceptor ipcInterceptor;

    public DefaultCredentialHandler(SecurityAccess securityAccess, PasswordCredentialProvider pcProvider, InternalPasswordCredentialInterceptor ipcInterceptor) {
        this.securityAccess = securityAccess;
        this.pcProvider = pcProvider;
        this.ipcInterceptor = ipcInterceptor;
    }

    public Set getPrivateCredentials(String username) {
        HashSet<PasswordCredential> credentials;
        block3: {
            InternalCredential credential;
            credentials = new HashSet<PasswordCredential>();
            InternalUserPrincipal internalUser = this.securityAccess.getInternalUserPrincipal(username, false);
            if (null != internalUser && (credential = this.getPasswordCredential(internalUser, username)) != null) {
                try {
                    credentials.add(this.pcProvider.create(username, credential));
                }
                catch (SecurityException e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)("Failure creating a PasswordCredential for InternalCredential " + credential), (Throwable)e);
                }
            }
        }
        return credentials;
    }

    public Set getPublicCredentials(String username) {
        return new HashSet();
    }

    private InternalCredential getPasswordCredential(InternalUserPrincipal internalUser, String username) {
        InternalCredential credential = null;
        Collection internalCredentials = internalUser.getCredentials();
        if (internalCredentials != null) {
            Iterator iter = internalCredentials.iterator();
            while (iter.hasNext()) {
                block5: {
                    credential = (InternalCredential)iter.next();
                    if (credential.getType() == 0 && null != credential.getClassname() && credential.getClassname().equals(this.pcProvider.getPasswordCredentialClass().getName())) {
                        try {
                            if (this.ipcInterceptor == null || !this.ipcInterceptor.afterLoad(this.pcProvider, username, credential)) break;
                            this.securityAccess.setInternalUserPrincipal(internalUser, internalUser.isMappingOnly());
                            break;
                        }
                        catch (SecurityException e) {
                            if (!log.isErrorEnabled()) break block5;
                            log.error((Object)("Failure loading InternalCredential " + credential), (Throwable)e);
                        }
                    }
                }
                credential = null;
            }
        }
        return credential;
    }

    public void setPassword(String userName, String oldPassword, String newPassword) throws SecurityException {
        this.setPassword(userName, oldPassword, newPassword, false);
    }

    public void importPassword(String userName, String newPassword) throws SecurityException {
        this.setPassword(userName, null, newPassword, true);
    }

    protected void setPassword(String userName, String oldPassword, String newPassword, boolean raw) throws SecurityException {
        boolean create;
        InternalUserPrincipal internalUser = this.securityAccess.getInternalUserPrincipal(userName, false);
        if (null == internalUser) {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)userName));
        }
        ArrayList<InternalCredential> credentials = internalUser.getCredentials();
        if (null == credentials) {
            credentials = new ArrayList<InternalCredential>();
        }
        InternalCredential credential = this.getPasswordCredential(internalUser, userName);
        if (null != oldPassword && credential != null && credential.getValue() != null && credential.isEncoded() && this.pcProvider.getEncoder() != null) {
            oldPassword = this.pcProvider.getEncoder() instanceof AlgorithmUpgradeCredentialPasswordEncoder ? ((AlgorithmUpgradeCredentialPasswordEncoder)this.pcProvider.getEncoder()).encode(userName, oldPassword, credential) : this.pcProvider.getEncoder().encode(userName, oldPassword);
        }
        if (!(oldPassword == null || credential != null && credential.getValue() != null && credential.getValue().equals(oldPassword))) {
            throw new InvalidPasswordException();
        }
        if (!raw && this.pcProvider.getValidator() != null) {
            try {
                this.pcProvider.getValidator().validate(newPassword);
            }
            catch (InvalidPasswordException ipe) {
                throw new InvalidNewPasswordException();
            }
        }
        boolean encoded = false;
        if (this.pcProvider.getEncoder() != null) {
            if (!raw) {
                newPassword = this.pcProvider.getEncoder().encode(userName, newPassword);
            }
            encoded = true;
        }
        boolean bl = create = credential == null;
        if (create) {
            credential = new InternalCredentialImpl(internalUser.getPrincipalId(), newPassword, 0, this.pcProvider.getPasswordCredentialClass().getName());
            credential.setEncoded(encoded);
            credentials.add(credential);
        } else if (oldPassword != null && oldPassword.equals(newPassword)) {
            throw new PasswordAlreadyUsedException();
        }
        if (this.ipcInterceptor != null) {
            if (create) {
                this.ipcInterceptor.beforeCreate(internalUser, credentials, userName, credential, newPassword);
            } else {
                this.ipcInterceptor.beforeSetPassword(internalUser, credentials, userName, credential, newPassword, oldPassword != null);
            }
        }
        if (!create) {
            credential.setValue(newPassword);
            credential.setEncoded(encoded);
            credential.setUpdateRequired(false);
        }
        long time = new java.util.Date().getTime();
        if (oldPassword == null) {
            if (encoded && this.pcProvider.getEncoder() instanceof AlgorithmUpgradePasswordEncodingService) {
                credential.setPreviousAuthenticationDate(new Timestamp(new java.util.Date().getTime()));
                credential.setLastAuthenticationDate(null);
            }
        } else {
            credential.setPreviousAuthenticationDate(credential.getLastAuthenticationDate());
            credential.setLastAuthenticationDate(new Timestamp(time));
        }
        credential.setModifiedDate(new Timestamp(time));
        internalUser.setModifiedDate(new Timestamp(time));
        internalUser.setCredentials(credentials);
        this.securityAccess.setInternalUserPrincipal(internalUser, false);
    }

    public void setPasswordEnabled(String userName, boolean enabled) throws SecurityException {
        InternalUserPrincipal internalUser = this.securityAccess.getInternalUserPrincipal(userName, false);
        if (null != internalUser) {
            InternalCredential credential = this.getPasswordCredential(internalUser, userName);
            if (credential != null && !credential.isExpired() && credential.isEnabled() != enabled) {
                long time = new java.util.Date().getTime();
                credential.setEnabled(enabled);
                credential.setAuthenticationFailures(0);
                credential.setModifiedDate(new Timestamp(time));
                internalUser.setModifiedDate(new Timestamp(time));
                this.securityAccess.setInternalUserPrincipal(internalUser, false);
            }
        } else {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)userName));
        }
    }

    public void setPasswordUpdateRequired(String userName, boolean updateRequired) throws SecurityException {
        InternalUserPrincipal internalUser = this.securityAccess.getInternalUserPrincipal(userName, false);
        if (null != internalUser) {
            InternalCredential credential = this.getPasswordCredential(internalUser, userName);
            if (credential != null && !credential.isExpired() && credential.isUpdateRequired() != updateRequired) {
                if (!updateRequired && !credential.isEncoded() && this.pcProvider.getValidator() != null) {
                    this.pcProvider.getValidator().validate(credential.getValue());
                }
                credential.setUpdateRequired(updateRequired);
                long time = new java.util.Date().getTime();
                credential.setModifiedDate(new Timestamp(time));
                credential.setPreviousAuthenticationDate(new Timestamp(time));
                credential.setModifiedDate(new Timestamp(time));
                internalUser.setModifiedDate(new Timestamp(time));
                this.securityAccess.setInternalUserPrincipal(internalUser, false);
            }
        } else {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)userName));
        }
    }

    public void setPasswordExpiration(String userName, Date expirationDate) throws SecurityException {
        InternalUserPrincipal internalUser = this.securityAccess.getInternalUserPrincipal(userName, false);
        if (null != internalUser) {
            InternalCredential credential = this.getPasswordCredential(internalUser, userName);
            if (credential != null) {
                long time = new java.util.Date().getTime();
                if (expirationDate != null && new Date(time).after(expirationDate)) {
                    credential.setExpired(true);
                } else {
                    credential.setExpired(false);
                }
                credential.setExpirationDate(expirationDate);
                credential.setModifiedDate(new Timestamp(time));
                internalUser.setModifiedDate(new Timestamp(time));
                this.securityAccess.setInternalUserPrincipal(internalUser, false);
            }
        } else {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)userName));
        }
    }

    public boolean authenticate(String userName, String password) throws SecurityException {
        boolean authenticated = false;
        InternalUserPrincipal internalUser = this.securityAccess.getInternalUserPrincipal(userName, false);
        if (null != internalUser) {
            InternalCredential credential = this.getPasswordCredential(internalUser, userName);
            if (credential != null && credential.isEnabled() && !credential.isExpired()) {
                String encodedPassword = password;
                if (this.pcProvider.getEncoder() != null && credential.isEncoded()) {
                    encodedPassword = this.pcProvider.getEncoder() instanceof AlgorithmUpgradeCredentialPasswordEncoder ? ((AlgorithmUpgradeCredentialPasswordEncoder)this.pcProvider.getEncoder()).encode(userName, password, credential) : this.pcProvider.getEncoder().encode(userName, password);
                }
                authenticated = credential.getValue().equals(encodedPassword);
                boolean update = false;
                if (this.ipcInterceptor != null && (update = this.ipcInterceptor.afterAuthenticated(internalUser, userName, credential, authenticated)) && (!credential.isEnabled() || credential.isExpired())) {
                    authenticated = false;
                }
                long time = new java.util.Date().getTime();
                if (authenticated) {
                    credential.setAuthenticationFailures(0);
                    if (this.pcProvider.getEncoder() != null && this.pcProvider.getEncoder() instanceof AlgorithmUpgradeCredentialPasswordEncoder) {
                        ((AlgorithmUpgradeCredentialPasswordEncoder)this.pcProvider.getEncoder()).recodeIfNeeded(userName, password, credential);
                    }
                    credential.setPreviousAuthenticationDate(credential.getLastAuthenticationDate());
                    credential.setLastAuthenticationDate(new Timestamp(time));
                    update = true;
                }
                if (update) {
                    credential.setModifiedDate(new Timestamp(time));
                    internalUser.setModifiedDate(new Timestamp(time));
                    this.securityAccess.setInternalUserPrincipal(internalUser, false);
                }
            }
        } else {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)userName));
        }
        return authenticated;
    }
}

