/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.i18n.KeyedMessage;
import org.apache.jetspeed.security.AuthenticationProviderProxy;
import org.apache.jetspeed.security.Role;
import org.apache.jetspeed.security.RoleManager;
import org.apache.jetspeed.security.RolePrincipal;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.SecurityProvider;
import org.apache.jetspeed.security.impl.RoleImpl;
import org.apache.jetspeed.security.impl.RolePrincipalImpl;
import org.apache.jetspeed.security.spi.RoleSecurityHandler;
import org.apache.jetspeed.security.spi.SecurityMappingHandler;
import org.apache.jetspeed.util.ArgUtil;

public class RoleManagerImpl
implements RoleManager {
    private static final Log log = LogFactory.getLog((Class)RoleManagerImpl.class);
    private AuthenticationProviderProxy atnProviderProxy = null;
    private RoleSecurityHandler roleSecurityHandler = null;
    private SecurityMappingHandler securityMappingHandler = null;

    public RoleManagerImpl(SecurityProvider securityProvider) {
        this.atnProviderProxy = securityProvider.getAuthenticationProviderProxy();
        this.roleSecurityHandler = securityProvider.getRoleSecurityHandler();
        this.securityMappingHandler = securityProvider.getSecurityMappingHandler();
    }

    public void addRole(String roleFullPathName) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{roleFullPathName}, (String[])new String[]{"roleFullPathName"}, (String)"addRole(java.lang.String)");
        if (this.roleExists(roleFullPathName)) {
            throw new SecurityException(SecurityException.ROLE_ALREADY_EXISTS.create((Object)roleFullPathName));
        }
        RolePrincipalImpl rolePrincipal = new RolePrincipalImpl(roleFullPathName);
        String fullPath = rolePrincipal.getFullPath();
        Preferences preferences = Preferences.userRoot().node(fullPath);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added role preferences node: " + fullPath));
        }
        try {
            if (null != preferences && preferences.absolutePath().equals(fullPath)) {
                this.roleSecurityHandler.setRolePrincipal((RolePrincipal)rolePrincipal);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Added role: " + fullPath));
                }
            }
        }
        catch (SecurityException se) {
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"RoleManager.addRole", (Object)("RoleSecurityHandler.setRolePrincipal(" + rolePrincipal.getName() + ")"), (Object)se.getMessage());
            log.error((Object)msg, (Throwable)se);
            try {
                preferences.removeNode();
            }
            catch (BackingStoreException bse) {
                bse.printStackTrace();
            }
            throw new SecurityException(msg, (Throwable)se);
        }
    }

    public void removeRole(String roleFullPathName) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{roleFullPathName}, (String[])new String[]{"roleFullPathName"}, (String)"removeRole(java.lang.String)");
        Preferences prefs = Preferences.userRoot().node(RolePrincipalImpl.getFullPathFromPrincipalName(roleFullPathName));
        String[] roles = this.securityMappingHandler.getRoleHierarchyResolver().resolveChildren(prefs);
        for (int i = 0; i < roles.length; ++i) {
            try {
                this.roleSecurityHandler.removeRolePrincipal((RolePrincipal)new RolePrincipalImpl(RolePrincipalImpl.getPrincipalNameFromFullPath(roles[i])));
            }
            catch (Exception e) {
                KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"RoleManager.removeRole", (Object)("RoleSecurityHandler.removeRolePrincipal(" + RolePrincipalImpl.getPrincipalNameFromFullPath(roles[i]) + ")"), (Object)e.getMessage());
                log.error((Object)msg, (Throwable)e);
                throw new SecurityException(msg, (Throwable)e);
            }
            Preferences rolePref = Preferences.userRoot().node(roles[i]);
            try {
                rolePref.removeNode();
                continue;
            }
            catch (BackingStoreException bse) {
                KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"RoleManager.removeRole", (Object)("Preferences.removeNode(" + roles[i] + ")"), (Object)bse.getMessage());
                log.error((Object)msg, (Throwable)bse);
                throw new SecurityException(msg, (Throwable)bse);
            }
        }
    }

    public boolean roleExists(String roleFullPathName) {
        boolean roleExists;
        ArgUtil.notNull((Object[])new Object[]{roleFullPathName}, (String[])new String[]{"roleFullPathName"}, (String)"roleExists(java.lang.String)");
        RolePrincipal principal = this.roleSecurityHandler.getRolePrincipal(roleFullPathName);
        boolean bl = roleExists = null != principal;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Role exists: " + roleExists));
            log.debug((Object)("Role: " + roleFullPathName));
        }
        return roleExists;
    }

    public Role getRole(String roleFullPathName) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{roleFullPathName}, (String[])new String[]{"roleFullPathName"}, (String)"getRole(java.lang.String)");
        String fullPath = RolePrincipalImpl.getFullPathFromPrincipalName(roleFullPathName);
        RolePrincipal rolePrincipal = this.roleSecurityHandler.getRolePrincipal(roleFullPathName);
        if (null == rolePrincipal) {
            throw new SecurityException(SecurityException.ROLE_DOES_NOT_EXIST.create((Object)roleFullPathName));
        }
        Preferences preferences = Preferences.userRoot().node(fullPath);
        RoleImpl role = new RoleImpl((Principal)rolePrincipal, preferences);
        return role;
    }

    public Collection getRolesForUser(String username) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{username}, (String[])new String[]{"username"}, (String)"getRolesForUser(java.lang.String)");
        ArrayList<RoleImpl> roles = new ArrayList<RoleImpl>();
        Set rolePrincipals = this.securityMappingHandler.getRolePrincipals(username);
        Iterator rolePrincipalsIter = rolePrincipals.iterator();
        while (rolePrincipalsIter.hasNext()) {
            Principal rolePrincipal = (Principal)rolePrincipalsIter.next();
            Preferences preferences = Preferences.userRoot().node(RolePrincipalImpl.getFullPathFromPrincipalName(rolePrincipal.getName()));
            roles.add(new RoleImpl(rolePrincipal, preferences));
        }
        return roles;
    }

    public Collection getRolesInGroup(String groupFullPathName) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{groupFullPathName}, (String[])new String[]{"groupFullPathName"}, (String)"getRolesInGroup(java.lang.String)");
        ArrayList<RoleImpl> roles = new ArrayList<RoleImpl>();
        Set rolePrincipals = this.securityMappingHandler.getRolePrincipalsInGroup(groupFullPathName);
        Iterator rolePrincipalsIter = rolePrincipals.iterator();
        while (rolePrincipalsIter.hasNext()) {
            Principal rolePrincipal = (Principal)rolePrincipalsIter.next();
            Preferences preferences = Preferences.userRoot().node(RolePrincipalImpl.getFullPathFromPrincipalName(rolePrincipal.getName()));
            roles.add(new RoleImpl(rolePrincipal, preferences));
        }
        return roles;
    }

    public void addRoleToUser(String username, String roleFullPathName) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{username, roleFullPathName}, (String[])new String[]{"username", "roleFullPathName"}, (String)"addUserToRole(java.lang.String, java.lang.String)");
        RolePrincipal rolePrincipal = this.roleSecurityHandler.getRolePrincipal(roleFullPathName);
        if (null == rolePrincipal) {
            throw new SecurityException(SecurityException.ROLE_DOES_NOT_EXIST.create((Object)roleFullPathName));
        }
        Principal userPrincipal = this.atnProviderProxy.getUserPrincipal(username);
        if (null == userPrincipal) {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)username));
        }
        Set rolePrincipals = this.securityMappingHandler.getRolePrincipals(username);
        if (!rolePrincipals.contains(rolePrincipal)) {
            this.securityMappingHandler.setUserPrincipalInRole(username, roleFullPathName);
        }
    }

    public void removeRoleFromUser(String username, String roleFullPathName) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{username, roleFullPathName}, (String[])new String[]{"username", "roleFullPathName"}, (String)"removeRoleFromUser(java.lang.String, java.lang.String)");
        Principal userPrincipal = this.atnProviderProxy.getUserPrincipal(username);
        if (null == userPrincipal) {
            throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)username));
        }
        RolePrincipal rolePrincipal = this.roleSecurityHandler.getRolePrincipal(roleFullPathName);
        if (null != rolePrincipal) {
            this.securityMappingHandler.removeUserPrincipalInRole(username, roleFullPathName);
        }
    }

    public boolean isUserInRole(String username, String roleFullPathName) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{username, roleFullPathName}, (String[])new String[]{"username", "roleFullPathName"}, (String)"isUserInRole(java.lang.String, java.lang.String)");
        boolean isUserInRole = false;
        Set rolePrincipals = this.securityMappingHandler.getRolePrincipals(username);
        RolePrincipalImpl rolePrincipal = new RolePrincipalImpl(roleFullPathName);
        if (rolePrincipals.contains(rolePrincipal)) {
            isUserInRole = true;
        }
        return isUserInRole;
    }

    public void addRoleToGroup(String roleFullPathName, String groupFullPathName) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{roleFullPathName, groupFullPathName}, (String[])new String[]{"roleFullPathName", "groupFullPathName"}, (String)"addRoleToGroup(java.lang.String, java.lang.String)");
        RolePrincipal rolePrincipal = this.roleSecurityHandler.getRolePrincipal(roleFullPathName);
        if (null == rolePrincipal) {
            throw new SecurityException(SecurityException.ROLE_DOES_NOT_EXIST.create((Object)roleFullPathName));
        }
        this.securityMappingHandler.setRolePrincipalInGroup(groupFullPathName, roleFullPathName);
    }

    public void removeRoleFromGroup(String roleFullPathName, String groupFullPathName) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{roleFullPathName, groupFullPathName}, (String[])new String[]{"roleFullPathName", "groupFullPathName"}, (String)"removeRoleFromGroup(java.lang.String, java.lang.String)");
        RolePrincipal rolePrincipal = this.roleSecurityHandler.getRolePrincipal(roleFullPathName);
        if (null != rolePrincipal) {
            this.securityMappingHandler.removeRolePrincipalInGroup(groupFullPathName, roleFullPathName);
        }
    }

    public boolean isGroupInRole(String groupFullPathName, String roleFullPathName) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{roleFullPathName, groupFullPathName}, (String[])new String[]{"roleFullPathName", "groupFullPathName"}, (String)"isGroupInRole(java.lang.String, java.lang.String)");
        boolean isGroupInRole = false;
        Set rolePrincipals = this.securityMappingHandler.getRolePrincipalsInGroup(groupFullPathName);
        RolePrincipalImpl rolePrincipal = new RolePrincipalImpl(roleFullPathName);
        if (rolePrincipals.contains(rolePrincipal)) {
            isGroupInRole = true;
        }
        return isGroupInRole;
    }

    public Iterator getRoles(String filter) throws SecurityException {
        LinkedList<Role> roles = new LinkedList<Role>();
        Iterator rolePrincipals = this.roleSecurityHandler.getRolePrincipals(filter).iterator();
        while (rolePrincipals.hasNext()) {
            String roleName = ((Principal)rolePrincipals.next()).getName();
            Role role = this.getRole(roleName);
            roles.add(role);
        }
        return roles.iterator();
    }

    public void setRoleEnabled(String roleFullPathName, boolean enabled) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{roleFullPathName}, (String[])new String[]{"roleFullPathName"}, (String)"setRoleEnabled(java.lang.String,boolean)");
        RolePrincipalImpl rolePrincipal = (RolePrincipalImpl)this.roleSecurityHandler.getRolePrincipal(roleFullPathName);
        if (null == rolePrincipal) {
            throw new SecurityException(SecurityException.ROLE_DOES_NOT_EXIST.create((Object)roleFullPathName));
        }
        if (enabled != rolePrincipal.isEnabled()) {
            rolePrincipal.setEnabled(enabled);
            this.roleSecurityHandler.setRolePrincipal((RolePrincipal)rolePrincipal);
        }
    }
}

