/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.Permission;
import java.security.Permissions;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.i18n.KeyedMessage;
import org.apache.jetspeed.security.JSSubject;
import org.apache.jetspeed.security.PermissionManager;
import org.apache.jetspeed.security.RolePrincipal;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.SecurityHelper;
import org.apache.jetspeed.security.UserPrincipal;
import org.apache.jetspeed.security.om.InternalPermission;
import org.apache.jetspeed.security.om.InternalPrincipal;
import org.apache.jetspeed.security.om.impl.InternalPermissionImpl;
import org.apache.jetspeed.security.om.impl.InternalPrincipalImpl;
import org.apache.jetspeed.util.ArgUtil;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.springframework.orm.ojb.support.PersistenceBrokerDaoSupport;

public class PermissionManagerImpl
extends PersistenceBrokerDaoSupport
implements PermissionManager {
    private static final Log log = LogFactory.getLog((Class)PermissionManagerImpl.class);
    private static ThreadLocal permissionsCache = new ThreadLocal();
    static /* synthetic */ Class class$java$lang$String;

    public Permissions getPermissions(Principal principal) {
        HashSet principalPermissions;
        String fullPath = SecurityHelper.getPreferencesFullPath(principal);
        ArgUtil.notNull((Object[])new Object[]{fullPath}, (String[])new String[]{"fullPath"}, (String)"removePermission(java.security.Principal)");
        HashMap permissionsMap = (HashMap)permissionsCache.get();
        if (permissionsMap == null) {
            permissionsMap = new HashMap();
            permissionsCache.set(permissionsMap);
        }
        if ((principalPermissions = (HashSet)permissionsMap.get(fullPath)) == null) {
            InternalPrincipal internalPrincipal = this.getInternalPrincipal(fullPath);
            if (null != internalPrincipal) {
                principalPermissions = this.getSecurityPermissions(internalPrincipal.getPermissions());
            }
            if (principalPermissions == null) {
                principalPermissions = new HashSet();
            }
            permissionsMap.put(fullPath, principalPermissions);
        }
        Permissions permissions = new Permissions();
        Iterator iter = principalPermissions.iterator();
        while (iter.hasNext()) {
            permissions.add((Permission)iter.next());
        }
        return permissions;
    }

    public Permissions getPermissions(Collection principals) {
        ArgUtil.notNull((Object[])new Object[]{principals}, (String[])new String[]{"principals"}, (String)"getPermissions(java.util.Collection)");
        Permissions permissions = new Permissions();
        Collection principalsFullPath = this.getPrincipalsFullPath(principals);
        if (null != principalsFullPath && principalsFullPath.size() > 0) {
            HashSet principalPermissions;
            HashSet permissionsSet = new HashSet();
            HashMap permissionsMap = (HashMap)permissionsCache.get();
            if (permissionsMap == null) {
                permissionsMap = new HashMap();
                permissionsCache.set(permissionsMap);
            }
            Iterator iter = principalsFullPath.iterator();
            while (iter.hasNext()) {
                principalPermissions = (HashSet)permissionsMap.get(iter.next());
                if (principalPermissions == null) continue;
                iter.remove();
                permissionsSet.addAll(principalPermissions);
            }
            if (principalsFullPath.size() > 0) {
                Criteria filter = new Criteria();
                filter.addIn("fullPath", principalsFullPath);
                QueryByCriteria query = QueryFactory.newQuery((Class)InternalPrincipalImpl.class, (Criteria)filter);
                Collection internalPrincipals = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
                Iterator internalPrincipalsIter = internalPrincipals.iterator();
                while (internalPrincipalsIter.hasNext()) {
                    InternalPrincipal internalPrincipal = (InternalPrincipal)internalPrincipalsIter.next();
                    Collection internalPermissions = internalPrincipal.getPermissions();
                    if (null != internalPermissions) {
                        principalPermissions = this.getSecurityPermissions(internalPermissions);
                        permissionsSet.addAll(principalPermissions);
                    } else {
                        principalPermissions = new HashSet();
                    }
                    permissionsMap.put(internalPrincipal.getFullPath(), principalPermissions);
                }
            }
            iter = permissionsSet.iterator();
            while (iter.hasNext()) {
                permissions.add((Permission)iter.next());
            }
        }
        return permissions;
    }

    private Collection getPrincipalsFullPath(Collection principals) {
        ArrayList<String> principalsFullPath = new ArrayList<String>();
        Iterator principalsIterator = principals.iterator();
        while (principalsIterator.hasNext()) {
            Principal principal = (Principal)principalsIterator.next();
            String fullPath = SecurityHelper.getPreferencesFullPath(principal);
            if (null == fullPath) continue;
            principalsFullPath.add(fullPath);
        }
        return principalsFullPath;
    }

    private HashSet getSecurityPermissions(Collection omPermissions) {
        HashSet<Permission> permissions = new HashSet<Permission>();
        Iterator internalPermissionsIter = omPermissions.iterator();
        while (internalPermissionsIter.hasNext()) {
            InternalPermission internalPermission = (InternalPermission)internalPermissionsIter.next();
            Permission permission = null;
            try {
                Object[] initArgs;
                Class<?> permissionClass = Class.forName(internalPermission.getClassname());
                Class[] parameterTypes = new Class[]{class$java$lang$String == null ? PermissionManagerImpl.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? PermissionManagerImpl.class$("java.lang.String") : class$java$lang$String};
                Constructor<?> permissionConstructor = permissionClass.getConstructor(parameterTypes);
                permission = (Permission)permissionConstructor.newInstance(initArgs = new Object[]{internalPermission.getName(), internalPermission.getActions()});
                if (!permissions.add(permission) || !log.isDebugEnabled()) continue;
                log.debug((Object)("Added permimssion: [class, " + permission.getClass().getName() + "], " + "[name, " + permission.getName() + "], " + "[actions, " + permission.getActions() + "]"));
            }
            catch (Exception e) {
                log.error((Object)"Internal error", (Throwable)e);
            }
        }
        return permissions;
    }

    public void addPermission(Permission permission) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{permission}, (String[])new String[]{"permission"}, (String)"addPermission(java.security.Permission)");
        InternalPermissionImpl internalPermission = new InternalPermissionImpl(permission.getClass().getName(), permission.getName(), permission.getActions());
        try {
            this.getPersistenceBrokerTemplate().store((Object)internalPermission);
        }
        catch (Exception e) {
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"PermissionManager.addPermission", (Object)"store", (Object)e.getMessage());
            this.logger.error((Object)msg, (Throwable)e);
            throw new SecurityException(msg, (Throwable)e);
        }
    }

    public void removePermission(Permission permission) throws SecurityException {
        ArgUtil.notNull((Object[])new Object[]{permission}, (String[])new String[]{"permission"}, (String)"removePermission(java.security.Permission)");
        InternalPermission internalPermission = this.getInternalPermission(permission);
        if (null != internalPermission) {
            permissionsCache.set(null);
            try {
                this.getPersistenceBrokerTemplate().delete((Object)internalPermission);
            }
            catch (Exception e) {
                KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"PermissionManager.removePermission", (Object)"delete", (Object)e.getMessage());
                this.logger.error((Object)msg, (Throwable)e);
                throw new SecurityException(msg, (Throwable)e);
            }
        }
    }

    public void removePermissions(Principal principal) throws SecurityException {
        String fullPath = SecurityHelper.getPreferencesFullPath(principal);
        ArgUtil.notNull((Object[])new Object[]{fullPath}, (String[])new String[]{"fullPath"}, (String)"removePermission(java.security.Principal)");
        InternalPrincipal internalPrincipal = this.getInternalPrincipal(fullPath);
        if (null != internalPrincipal) {
            Collection internalPermissions = internalPrincipal.getPermissions();
            if (null != internalPermissions) {
                internalPermissions.clear();
            }
            permissionsCache.set(null);
            try {
                internalPrincipal.setModifiedDate(new Timestamp(System.currentTimeMillis()));
                internalPrincipal.setPermissions(internalPermissions);
                this.getPersistenceBrokerTemplate().store((Object)internalPrincipal);
            }
            catch (Exception e) {
                KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"PermissionManager.removePermissions", (Object)"store", (Object)e.getMessage());
                this.logger.error((Object)msg, (Throwable)e);
                throw new SecurityException(msg, (Throwable)e);
            }
        }
    }

    public void grantPermission(Principal principal, Permission permission) throws SecurityException {
        String fullPath = SecurityHelper.getPreferencesFullPath(principal);
        ArgUtil.notNull((Object[])new Object[]{fullPath, permission}, (String[])new String[]{"fullPath", "permission"}, (String)"grantPermission(java.security.Principal, java.security.Permission)");
        ArrayList<InternalPermission> internalPermissions = new ArrayList<InternalPermission>();
        InternalPrincipal internalPrincipal = this.getInternalPrincipal(fullPath);
        if (null == internalPrincipal) {
            if (principal instanceof UserPrincipal) {
                throw new SecurityException(SecurityException.USER_DOES_NOT_EXIST.create((Object)principal.getName()));
            }
            if (principal instanceof RolePrincipal) {
                throw new SecurityException(SecurityException.ROLE_DOES_NOT_EXIST.create((Object)principal.getName()));
            }
            throw new SecurityException(SecurityException.GROUP_DOES_NOT_EXIST.create((Object)principal.getName()));
        }
        InternalPermission internalPermission = this.getInternalPermission(permission);
        if (null == internalPermission) {
            throw new SecurityException(SecurityException.PERMISSION_DOES_NOT_EXIST.create((Object)permission.getName()));
        }
        if (null != internalPrincipal.getPermissions()) {
            internalPermissions.addAll(internalPrincipal.getPermissions());
        }
        if (!internalPermissions.contains(internalPermission)) {
            internalPermissions.add(internalPermission);
        }
        permissionsCache.set(null);
        try {
            internalPrincipal.setModifiedDate(new Timestamp(System.currentTimeMillis()));
            internalPrincipal.setPermissions(internalPermissions);
            this.getPersistenceBrokerTemplate().store((Object)internalPrincipal);
        }
        catch (Exception e) {
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"PermissionManager.grantPermission", (Object)"store", (Object)e.getMessage());
            this.logger.error((Object)msg, (Throwable)e);
            throw new SecurityException(msg, (Throwable)e);
        }
    }

    public boolean permissionExists(Permission permission) {
        boolean permissionExists = true;
        InternalPermission internalPermission = this.getInternalPermission(permission);
        if (null == internalPermission) {
            permissionExists = false;
        }
        return permissionExists;
    }

    public void revokePermission(Principal principal, Permission permission) throws SecurityException {
        Collection internalPermissions;
        String fullPath = SecurityHelper.getPreferencesFullPath(principal);
        ArgUtil.notNull((Object[])new Object[]{fullPath, permission}, (String[])new String[]{"fullPath", "permission"}, (String)"revokePermission(java.security.Principal, java.security.Permission)");
        InternalPrincipal internalPrincipal = this.getInternalPrincipal(fullPath);
        if (null != internalPrincipal && null != (internalPermissions = internalPrincipal.getPermissions())) {
            boolean revokePermission = false;
            ArrayList<InternalPermission> newInternalPermissions = new ArrayList<InternalPermission>();
            Iterator internalPermissionsIter = internalPermissions.iterator();
            while (internalPermissionsIter.hasNext()) {
                InternalPermission internalPermission = (InternalPermission)internalPermissionsIter.next();
                if (!(internalPermission.getClassname().equals(permission.getClass().getName()) && internalPermission.getName().equals(permission.getName()) && internalPermission.getActions().equals(permission.getActions()))) {
                    newInternalPermissions.add(internalPermission);
                    continue;
                }
                revokePermission = true;
            }
            if (revokePermission) {
                permissionsCache.set(null);
                try {
                    internalPrincipal.setModifiedDate(new Timestamp(System.currentTimeMillis()));
                    internalPrincipal.setPermissions(newInternalPermissions);
                    this.getPersistenceBrokerTemplate().store((Object)internalPrincipal);
                }
                catch (Exception e) {
                    KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"PermissionManager.revokePermission", (Object)"store", (Object)e.getMessage());
                    this.logger.error((Object)msg, (Throwable)e);
                    throw new SecurityException(msg, (Throwable)e);
                }
            }
        }
    }

    InternalPrincipal getInternalPrincipal(String fullPath) {
        Criteria filter = new Criteria();
        filter.addEqualTo("fullPath", (Object)fullPath);
        QueryByCriteria query = QueryFactory.newQuery((Class)InternalPrincipalImpl.class, (Criteria)filter);
        InternalPrincipal internalPrincipal = (InternalPrincipal)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        return internalPrincipal;
    }

    InternalPermission getInternalPermission(Permission permission) {
        Criteria filter = new Criteria();
        filter.addEqualTo("classname", (Object)permission.getClass().getName());
        filter.addEqualTo("name", (Object)permission.getName());
        filter.addEqualTo("actions", (Object)permission.getActions());
        QueryByCriteria query = QueryFactory.newQuery((Class)InternalPermissionImpl.class, (Criteria)filter);
        InternalPermission internalPermission = (InternalPermission)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        return internalPermission;
    }

    public boolean checkPermission(Subject subject, final Permission permission) {
        try {
            JSSubject.doAsPrivileged((Subject)subject, (PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    AccessController.checkPermission(permission);
                    return null;
                }
            }, null);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Collection getPermissions() {
        QueryByCriteria query = QueryFactory.newQuery((Class)InternalPermissionImpl.class, (Criteria)new Criteria());
        query.addOrderByAscending("classname");
        query.addOrderByAscending("name");
        Collection internalPermissions = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        return internalPermissions;
    }

    public Permissions getPermissions(String classname, String resource) {
        Criteria filter = new Criteria();
        filter.addEqualTo("classname", (Object)classname);
        filter.addEqualTo("name", (Object)resource);
        QueryByCriteria query = QueryFactory.newQuery((Class)InternalPermissionImpl.class, (Criteria)filter);
        Collection internalPermissions = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        Permissions permissions = new Permissions();
        Iterator iter = internalPermissions.iterator();
        try {
            while (iter.hasNext()) {
                InternalPermission internalPermission = (InternalPermission)iter.next();
                Class<?> permissionClass = Class.forName(internalPermission.getClassname());
                Class[] parameterTypes = new Class[]{class$java$lang$String == null ? PermissionManagerImpl.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? PermissionManagerImpl.class$("java.lang.String") : class$java$lang$String};
                Constructor<?> permissionConstructor = permissionClass.getConstructor(parameterTypes);
                Object[] initArgs = new Object[]{internalPermission.getName(), internalPermission.getActions()};
                Permission permission = (Permission)permissionConstructor.newInstance(initArgs);
                permissions.add(permission);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to retrieve permissions", (Throwable)e);
        }
        return permissions;
    }

    public int updatePermission(Permission permission, Collection principals) throws SecurityException {
        int count = 0;
        InternalPermission internal = this.getInternalPermission(permission);
        Iterator iter = principals.iterator();
        LinkedList<InternalPrincipal> newPrincipals = new LinkedList<InternalPrincipal>();
        while (iter.hasNext()) {
            Principal principal = (Principal)iter.next();
            String fullPath = SecurityHelper.getPreferencesFullPath(principal);
            InternalPrincipal internalPrincipal = this.getInternalPrincipal(fullPath);
            newPrincipals.add(internalPrincipal);
        }
        internal.setPrincipals(newPrincipals);
        internal.setModifiedDate(new Timestamp(System.currentTimeMillis()));
        try {
            this.getPersistenceBrokerTemplate().store((Object)internal);
        }
        catch (Exception e) {
            KeyedMessage msg = SecurityException.UNEXPECTED.create((Object)"PermissionManager.updatePermission", (Object)"store", (Object)e.getMessage());
            this.logger.error((Object)msg, (Throwable)e);
            throw new SecurityException(msg, (Throwable)e);
        }
        return count;
    }

    public Collection getPrincipals(Permission permission) {
        LinkedList<Principal> result = new LinkedList<Principal>();
        InternalPermission internalPermission = this.getInternalPermission(permission);
        if (internalPermission == null) {
            return result;
        }
        Iterator principals = internalPermission.getPrincipals().iterator();
        while (principals.hasNext()) {
            InternalPrincipal internalPrincipal = (InternalPrincipal)principals.next();
            Principal principal = SecurityHelper.createPrincipalFromFullPath(internalPrincipal.getFullPath());
            result.add(principal);
        }
        return result;
    }
}

