/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import org.apache.jetspeed.security.BasePrincipal;

public abstract class BasePrincipalImpl
implements BasePrincipal {
    private static final long serialVersionUID = 5687385387290144541L;
    private final String name;
    private final String fullPath;
    private boolean enabled = true;
    private boolean isMapping = false;

    public BasePrincipalImpl(String name, String prefsRoot, boolean hiearchicalNames) {
        this(name, prefsRoot, hiearchicalNames, true, false);
    }

    public BasePrincipalImpl(String name, String prefsRoot, boolean hiearchicalNames, boolean isEnabled, boolean isMapping) {
        this.name = name;
        this.fullPath = BasePrincipalImpl.getFullPathFromPrincipalName(name, prefsRoot, hiearchicalNames);
        this.enabled = isEnabled;
        this.isMapping = isMapping;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public static String getFullPathFromPrincipalName(String name, String prefsRoot, boolean hiearchicalNames) {
        String fullPath = name;
        if (null != name) {
            fullPath = prefsRoot + (hiearchicalNames ? name.replace('.', '/') : name);
        }
        return fullPath;
    }

    public static String getPrincipalNameFromFullPath(String fullPath, String prefsRoot, boolean hiearchicalNames) {
        String name = fullPath;
        if (null != name) {
            name = name.substring(prefsRoot.length(), name.length());
            if (hiearchicalNames) {
                name = name.replace('/', '.');
            }
        }
        return name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isMapping() {
        return this.isMapping;
    }
}

