/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.security.GroupPrincipal;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.security.RolePrincipal;
import org.apache.jetspeed.security.UserPrincipal;
import org.apache.jetspeed.security.impl.BasePrincipalImpl;
import org.apache.jetspeed.security.impl.GroupPrincipalImpl;
import org.apache.jetspeed.security.impl.PrincipalsSet;
import org.apache.jetspeed.security.impl.RolePrincipalImpl;
import org.apache.jetspeed.security.impl.UserPrincipalImpl;

public class SecurityHelper {
    private static final Log log = LogFactory.getLog((Class)SecurityHelper.class);

    public static Principal getPrincipal(Subject subject, Class classe) {
        Principal principal = null;
        Set<Principal> principalList = subject.getPrincipals();
        if (principalList != null) {
            Iterator<Principal> principals = subject.getPrincipals().iterator();
            while (principals.hasNext()) {
                Principal p = principals.next();
                if (!classe.isInstance(p)) continue;
                principal = p;
                break;
            }
        }
        return principal;
    }

    public static Principal getBestPrincipal(Subject subject, Class classe) {
        Principal principal = null;
        Iterator<Principal> principals = subject.getPrincipals().iterator();
        while (principals.hasNext()) {
            Principal p = principals.next();
            if (classe.isInstance(p)) {
                principal = p;
                break;
            }
            if (principal != null) continue;
            principal = p;
        }
        return principal;
    }

    public static Principal getBestPrincipal(Principal[] principals, Class classe) {
        Principal principal = null;
        for (int i = 0; i < principals.length; ++i) {
            Principal p = principals[i];
            if (classe.isInstance(p)) {
                principal = p;
                break;
            }
            if (principal != null) continue;
            principal = p;
        }
        return principal;
    }

    public static String getPreferencesFullPath(Principal principal) {
        if (UserPrincipal.class.isInstance(principal)) {
            return UserPrincipalImpl.getFullPathFromPrincipalName(principal.getName());
        }
        if (RolePrincipal.class.isInstance(principal)) {
            return RolePrincipalImpl.getFullPathFromPrincipalName(principal.getName());
        }
        if (GroupPrincipal.class.isInstance(principal)) {
            return GroupPrincipalImpl.getFullPathFromPrincipalName(principal.getName());
        }
        return null;
    }

    public static Subject createSubject(String principalName) {
        UserPrincipalImpl principal = new UserPrincipalImpl(principalName);
        PrincipalsSet principals = new PrincipalsSet();
        principals.add(principal);
        return new Subject(true, principals, new HashSet(), new HashSet());
    }

    public static List getPrincipals(Subject subject, Class classe) {
        LinkedList<Principal> result = new LinkedList<Principal>();
        Iterator<Principal> principals = subject.getPrincipals().iterator();
        while (principals.hasNext()) {
            Principal p = principals.next();
            if (!classe.isInstance(p)) continue;
            result.add(p);
        }
        return result;
    }

    public static List getPrincipals(Subject subject, String jptName) {
        LinkedList<Principal> result = new LinkedList<Principal>();
        Iterator<Principal> principals = subject.getPrincipals().iterator();
        while (principals.hasNext()) {
            Principal p = principals.next();
            if (!(p instanceof BasePrincipalImpl) || !("group".equals(jptName) && p instanceof GroupPrincipalImpl || "role".equals(jptName) && p instanceof RolePrincipalImpl) && (!"user".equals(jptName) || !(p instanceof UserPrincipalImpl))) continue;
            result.add(p);
        }
        return result;
    }

    public static PasswordCredential getPasswordCredential(Subject subject) {
        Iterator<Object> iter = subject.getPrivateCredentials().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof PasswordCredential)) continue;
            return (PasswordCredential)o;
        }
        return null;
    }

    public static void addPermissions(PermissionCollection perms, PermissionCollection permsToAdd) {
        int permsAdded = 0;
        if (null != permsToAdd) {
            Enumeration<Permission> permsToAddEnum = permsToAdd.elements();
            while (permsToAddEnum.hasMoreElements()) {
                ++permsAdded;
                Permission currPerm = permsToAddEnum.nextElement();
                perms.add(currPerm);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Adding the permission: [class, " + currPerm.getClass().getName() + "], " + "[name, " + currPerm.getName() + "], " + "[actions, " + currPerm.getActions() + "]"));
            }
        }
        if (permsAdded == 0 && log.isDebugEnabled()) {
            log.debug((Object)"No permissions to add...");
        }
    }

    public static Principal createPrincipalFromFullPath(String fullPath) {
        BasePrincipalImpl principal = null;
        if (fullPath.startsWith("/role/")) {
            String name = RolePrincipalImpl.getPrincipalNameFromFullPath(fullPath);
            principal = new RolePrincipalImpl(name);
        } else if (fullPath.startsWith("/user/")) {
            String name = UserPrincipalImpl.getPrincipalNameFromFullPath(fullPath);
            principal = new UserPrincipalImpl(name);
        } else if (fullPath.startsWith("/group/")) {
            String name = GroupPrincipalImpl.getPrincipalNameFromFullPath(fullPath);
            principal = new GroupPrincipalImpl(name);
        }
        return principal;
    }
}

